/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WeakEventListenerList {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Object[] data = EMPTY_ARRAY;
    private int size;
    private final int increment;
    private int count;

    public WeakEventListenerList() {
        this.increment = 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> void add(Class<T> t, T l) {
        this.lock.writeLock().lock();
        try {
            this.ensureCapacity(this.size + 2);
            this.data[this.size] = t;
            this.data[this.size + 1] = new WeakReference<T>(l);
            this.size += 2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> void remove(Class<T> t, T l) {
        this.lock.writeLock().lock();
        try {
            int position = this.findInternal(t, l);
            if (position < 0) {
                return;
            }
            int shiftElements = this.size - position - 2;
            if (shiftElements == 0) {
                this.data[position] = null;
                this.data[position + 1] = null;
                this.size -= 2;
                return;
            }
            this.size -= 2;
            System.arraycopy(this.data, position + 2, this.data, position, shiftElements);
            this.data[this.size] = null;
            this.data[this.size + 1] = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private <T extends EventListener> int findInternal(Class<T> t, T l) {
        for (int i = 0; i < this.size; i += 2) {
            WeakReference l2 = (WeakReference)this.data[i + 1];
            if (l2 == null) continue;
            Object o = l2.get();
            if (o == null) {
                this.data[i] = null;
                this.data[i + 1] = null;
                ++this.count;
                continue;
            }
            if (o != l || this.data[i] != t) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        this.lock.readLock().lock();
        try {
            int n = this.size / 2;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getListenerCount(Class<?> t) {
        this.lock.readLock().lock();
        try {
            int retval = 0;
            for (int i = 0; i < this.size; i += 2) {
                if (this.data[i] != t) continue;
                WeakReference l2 = (WeakReference)this.data[i + 1];
                Object o = l2.get();
                if (o == null) {
                    this.data[i] = null;
                    this.data[i + 1] = null;
                    ++this.count;
                    continue;
                }
                ++retval;
            }
            int n = retval;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> T[] getListeners(Class<T> t) {
        ArrayList list = new ArrayList();
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.size; i += 2) {
                if (this.data[i] != t) continue;
                WeakReference l2 = (WeakReference)this.data[i + 1];
                Object o = l2.get();
                if (o == null) {
                    this.data[i] = null;
                    this.data[i + 1] = null;
                    ++this.count;
                    continue;
                }
                list.add(o);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.pack();
        EventListener[] result = (EventListener[])Array.newInstance(t, list.size());
        return list.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pack() {
        if (this.count < 5) {
            this.lock.writeLock().lock();
            try {
                int correction = 0;
                for (int i = 0; i < this.size; i += 2) {
                    Object o = this.data[i];
                    if (o == null) {
                        correction += 2;
                        continue;
                    }
                    this.data[i - correction] = o;
                    this.data[i - correction + 1] = this.data[i + 1];
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private void ensureCapacity(int c) {
        if (this.data.length < c) {
            Object[] newData = new Object[Math.max(this.data.length + this.increment, c)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }
}

