/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.bulk;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.pentaho.reporting.libraries.base.util.BulkDataUtility;
import org.pentaho.reporting.libraries.designtime.swing.Messages;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;

public class SortBulkDownAction
extends AbstractAction
implements ListSelectionListener,
ListDataListener {
    private BulkDataProvider tableModel;
    private ListSelectionModel listSelectionModel;
    private JTable editorTable;

    public SortBulkDownAction(BulkDataProvider tableModel, ListSelectionModel listSelectionModel) {
        this.tableModel = tableModel;
        this.listSelectionModel = listSelectionModel;
        this.listSelectionModel.addListSelectionListener(this);
        this.putValue("SmallIcon", Messages.getInstance().getIcon("Icons.MOVE_DOWN"));
        this.putValue("ShortDescription", Messages.getInstance().getString("Action.MOVE_DOWN"));
    }

    public SortBulkDownAction(BulkDataProvider tableModel, ListSelectionModel listSelectionModel, JTable table) {
        this(tableModel, listSelectionModel);
        this.editorTable = table;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabled();
    }

    private void updateEnabled() {
        if (this.listSelectionModel.isSelectionEmpty()) {
            this.setEnabled(false);
        } else if (this.listSelectionModel.getMaxSelectionIndex() == this.tableModel.getBulkDataSize() - 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updateEnabled();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updateEnabled();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        TableCellEditor cellEditor;
        if (this.listSelectionModel.isSelectionEmpty()) {
            return;
        }
        Object[] data = this.tableModel.getBulkData();
        if (this.listSelectionModel.getMaxSelectionIndex() == data.length - 1) {
            return;
        }
        if (this.editorTable != null && (cellEditor = this.editorTable.getCellEditor()) != null) {
            cellEditor.stopCellEditing();
        }
        Object[] result = (Object[])data.clone();
        boolean[] selections = new boolean[result.length];
        for (i = this.listSelectionModel.getMinSelectionIndex(); i <= this.listSelectionModel.getMaxSelectionIndex(); ++i) {
            selections[i] = this.listSelectionModel.isSelectedIndex(i);
        }
        BulkDataUtility.pushDown((Object[])result, (boolean[])selections);
        this.tableModel.setBulkData(result);
        this.listSelectionModel.setValueIsAdjusting(true);
        this.listSelectionModel.removeSelectionInterval(0, selections.length);
        for (i = 0; i < selections.length; ++i) {
            boolean selection = selections[i];
            if (!selection) continue;
            this.listSelectionModel.addSelectionInterval(i, i);
        }
        this.listSelectionModel.setValueIsAdjusting(false);
    }
}

