/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.ORL_O34_SPECIMEN;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class ORL_O34_RESPONSE
extends AbstractGroup {
    public ORL_O34_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(ORL_O34_SPECIMEN.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating ORL_O34_RESPONSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORL_O34_SPECIMEN getSPECIMEN() {
        ORL_O34_SPECIMEN ret = null;
        try {
            ret = (ORL_O34_SPECIMEN)this.get("SPECIMEN");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORL_O34_SPECIMEN getSPECIMEN(int rep) {
        ORL_O34_SPECIMEN ret = null;
        try {
            ret = (ORL_O34_SPECIMEN)this.get("SPECIMEN", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSPECIMENReps() {
        int reps = -1;
        try {
            reps = this.getAll("SPECIMEN").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSPECIMEN(ORL_O34_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", (Structure)structure, rep);
    }

    public ORL_O34_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O34_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public ORL_O34_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O34_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

