/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class BoundedCompletionService<V> {
    private final Executor executor;
    private final List<Future<V>> tasks;
    private final BlockingQueue<Future<V>> completed;

    public BoundedCompletionService(Executor executor, int maxTasks) {
        this.executor = executor;
        this.tasks = new ArrayList<Future<V>>(maxTasks);
        this.completed = new ArrayBlockingQueue<Future<V>>(maxTasks);
    }

    public Future<V> submit(Callable<V> task) {
        QueueingFuture newFuture = new QueueingFuture(task);
        this.executor.execute(newFuture);
        this.tasks.add(newFuture);
        return newFuture;
    }

    public Future<V> take() throws InterruptedException {
        return this.completed.take();
    }

    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completed.poll(timeout, unit);
    }

    public void cancelAll(boolean interrupt) {
        for (Future<V> future : this.tasks) {
            future.cancel(interrupt);
        }
    }

    class QueueingFuture
    extends FutureTask<V> {
        public QueueingFuture(Callable<V> callable) {
            super(callable);
        }

        @Override
        protected void done() {
            BoundedCompletionService.this.completed.add(this);
        }
    }
}

