/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Hash;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class JenkinsHash
extends Hash {
    private static final int BYTE_MASK = 255;
    private static JenkinsHash _instance = new JenkinsHash();

    public static Hash getInstance() {
        return _instance;
    }

    @Override
    public int hash(byte[] key, int off, int nbytes, int initval) {
        int length;
        int c;
        int b = c = -559038737 + length + initval;
        int a = c;
        int offset = off;
        for (length = nbytes; length > 12; length -= 12) {
            a += key[offset] & 0xFF;
            a += (key[offset + 1] & 0xFF) << 8;
            a += (key[offset + 2] & 0xFF) << 16;
            a += (key[offset + 3] & 0xFF) << 24;
            b += key[offset + 4] & 0xFF;
            b += (key[offset + 5] & 0xFF) << 8;
            b += (key[offset + 6] & 0xFF) << 16;
            b += (key[offset + 7] & 0xFF) << 24;
            c += key[offset + 8] & 0xFF;
            c += (key[offset + 9] & 0xFF) << 8;
            c += (key[offset + 10] & 0xFF) << 16;
            a -= (c += (key[offset + 11] & 0xFF) << 24);
            a ^= Integer.rotateLeft(c, 4);
            c += b;
            b -= a;
            b ^= Integer.rotateLeft(a, 6);
            a += c;
            c -= b;
            c ^= Integer.rotateLeft(b, 8);
            b += a;
            a -= c;
            a ^= Integer.rotateLeft(c, 16);
            c += b;
            b -= a;
            b ^= Integer.rotateLeft(a, 19);
            a += c;
            c -= b;
            c ^= Integer.rotateLeft(b, 4);
            b += a;
            offset += 12;
        }
        switch (length) {
            case 12: {
                c += (key[offset + 11] & 0xFF) << 24;
            }
            case 11: {
                c += (key[offset + 10] & 0xFF) << 16;
            }
            case 10: {
                c += (key[offset + 9] & 0xFF) << 8;
            }
            case 9: {
                c += key[offset + 8] & 0xFF;
            }
            case 8: {
                b += (key[offset + 7] & 0xFF) << 24;
            }
            case 7: {
                b += (key[offset + 6] & 0xFF) << 16;
            }
            case 6: {
                b += (key[offset + 5] & 0xFF) << 8;
            }
            case 5: {
                b += key[offset + 4] & 0xFF;
            }
            case 4: {
                a += (key[offset + 3] & 0xFF) << 24;
            }
            case 3: {
                a += (key[offset + 2] & 0xFF) << 16;
            }
            case 2: {
                a += (key[offset + 1] & 0xFF) << 8;
            }
            case 1: {
                a += key[offset + 0] & 0xFF;
                break;
            }
            case 0: {
                return c;
            }
        }
        c ^= b;
        a ^= (c -= Integer.rotateLeft(b, 14));
        b ^= (a -= Integer.rotateLeft(c, 11));
        c ^= (b -= Integer.rotateLeft(a, 25));
        a ^= (c -= Integer.rotateLeft(b, 16));
        b ^= (a -= Integer.rotateLeft(c, 4));
        c ^= (b -= Integer.rotateLeft(a, 14));
        return c -= Integer.rotateLeft(b, 24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Usage: JenkinsHash filename");
            System.exit(-1);
        }
        FileInputStream in = new FileInputStream(args[0]);
        byte[] bytes = new byte[512];
        int value = 0;
        try {
            JenkinsHash hash = new JenkinsHash();
            int length = in.read(bytes);
            while (length > 0) {
                value = hash.hash(bytes, length, value);
                length = in.read(bytes);
            }
        }
        finally {
            in.close();
        }
        System.out.println(Math.abs(value));
    }
}

