/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.bytebuffer;

import java.nio.ByteBuffer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.lucene.store.bytebuffer.ByteBufferDirectory;

public class ByteBufferFile {
    private final CopyOnWriteArrayList<ByteBuffer> buffers = new CopyOnWriteArrayList();
    private final ByteBufferDirectory dir;
    final int bufferSize;
    private volatile long length;
    private volatile long lastModified = System.currentTimeMillis();

    public ByteBufferFile(ByteBufferDirectory dir, int bufferSize) {
        this.dir = dir;
        this.bufferSize = bufferSize;
    }

    public long getLength() {
        return this.length;
    }

    protected void setLength(long length) {
        this.length = length;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    protected void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    protected final void addBuffer(ByteBuffer buffer) {
        this.buffers.add(buffer);
    }

    protected final ByteBuffer getBuffer(int index) {
        return this.buffers.get(index);
    }

    protected final int numBuffers() {
        return this.buffers.size();
    }

    void clean() {
        if (this.buffers != null) {
            for (ByteBuffer buffer : this.buffers) {
                this.dir.releaseBuffer(buffer);
            }
            this.buffers.clear();
        }
    }
}

