/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.ping.replication;

import java.io.IOException;
import org.elasticsearch.action.admin.cluster.ping.replication.IndexReplicationPingRequest;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ShardReplicationPingRequest
extends ShardReplicationOperationRequest {
    private int shardId;

    public ShardReplicationPingRequest(IndexReplicationPingRequest request, int shardId) {
        this(request.index(), shardId);
        this.timeout = request.timeout();
        this.replicationType(request.replicationType());
    }

    public ShardReplicationPingRequest(String index, int shardId) {
        this.index = index;
        this.shardId = shardId;
    }

    ShardReplicationPingRequest() {
    }

    public int shardId() {
        return this.shardId;
    }

    @Override
    public ShardReplicationPingRequest listenerThreaded(boolean threadedListener) {
        super.listenerThreaded(threadedListener);
        return this;
    }

    @Override
    public ShardReplicationPingRequest operationThreaded(boolean threadedOperation) {
        super.operationThreaded(threadedOperation);
        return this;
    }

    @Override
    public ShardReplicationPingRequest replicationType(ReplicationType replicationType) {
        super.replicationType(replicationType);
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shardId);
    }

    public String toString() {
        return "replication_ping {[" + this.index + "][" + this.shardId + "]}";
    }
}

