/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;

public class CountRequest
extends BroadcastOperationRequest {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    public static final float DEFAULT_MIN_SCORE = -1.0f;
    private float minScore = -1.0f;
    @Nullable
    protected String queryHint;
    @Nullable
    protected String routing;
    private byte[] querySource;
    private int querySourceOffset;
    private int querySourceLength;
    private boolean querySourceUnsafe;
    private String[] types = Strings.EMPTY_ARRAY;
    private String queryParserName;

    CountRequest() {
    }

    public CountRequest(String ... indices) {
        super(indices);
        this.queryHint = null;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.querySource == null) {
            validationException = Actions.addValidationError("query is missing", validationException);
        }
        return validationException;
    }

    public String queryHint() {
        return this.queryHint;
    }

    @Override
    public CountRequest operationThreading(BroadcastOperationThreading operationThreading) {
        super.operationThreading(operationThreading);
        return this;
    }

    @Override
    protected void beforeLocalFork() {
        if (this.querySourceUnsafe) {
            this.querySource = Arrays.copyOfRange(this.querySource, this.querySourceOffset, this.querySourceOffset + this.querySourceLength);
            this.querySourceOffset = 0;
            this.querySourceUnsafe = false;
        }
    }

    @Override
    public CountRequest listenerThreaded(boolean threadedListener) {
        super.listenerThreaded(threadedListener);
        return this;
    }

    @Override
    public CountRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public CountRequest queryHint(String queryHint) {
        this.queryHint = queryHint;
        return this;
    }

    float minScore() {
        return this.minScore;
    }

    public CountRequest minScore(float minScore) {
        this.minScore = minScore;
        return this;
    }

    byte[] querySource() {
        return this.querySource;
    }

    int querySourceOffset() {
        return this.querySourceOffset;
    }

    int querySourceLength() {
        return this.querySourceLength;
    }

    @Required
    public CountRequest query(QueryBuilder queryBuilder) {
        BytesStream bos = queryBuilder.buildAsUnsafeBytes();
        this.querySource = bos.unsafeByteArray();
        this.querySourceOffset = 0;
        this.querySourceLength = bos.size();
        this.querySourceUnsafe = true;
        return this;
    }

    @Required
    public CountRequest query(Map querySource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(querySource);
            return this.query(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + querySource + "]", e);
        }
    }

    @Required
    public CountRequest query(XContentBuilder builder) {
        try {
            this.querySource = builder.unsafeBytes();
            this.querySourceOffset = 0;
            this.querySourceLength = builder.unsafeBytesLength();
            this.querySourceUnsafe = true;
            return this;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + builder + "]", e);
        }
    }

    @Required
    public CountRequest query(String querySource) {
        UnicodeUtil.UTF8Result result = Unicode.fromStringAsUtf8(querySource);
        this.querySource = result.result;
        this.querySourceOffset = 0;
        this.querySourceLength = result.length;
        this.querySourceUnsafe = true;
        return this;
    }

    @Required
    public CountRequest query(byte[] querySource) {
        return this.query(querySource, 0, querySource.length, false);
    }

    @Required
    public CountRequest query(byte[] querySource, int offset, int length, boolean unsafe) {
        this.querySource = querySource;
        this.querySourceOffset = offset;
        this.querySourceLength = length;
        this.querySourceUnsafe = unsafe;
        return this;
    }

    String queryParserName() {
        return this.queryParserName;
    }

    public CountRequest queryParserName(String queryParserName) {
        this.queryParserName = queryParserName;
        return this;
    }

    String[] types() {
        return this.types;
    }

    public CountRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public CountRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public CountRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int typesSize;
        super.readFrom(in);
        this.minScore = in.readFloat();
        if (in.readBoolean()) {
            this.queryHint = in.readUTF();
        }
        if (in.readBoolean()) {
            this.routing = in.readUTF();
        }
        this.querySourceUnsafe = false;
        this.querySourceOffset = 0;
        this.querySourceLength = in.readVInt();
        this.querySource = new byte[this.querySourceLength];
        in.readFully(this.querySource);
        if (in.readBoolean()) {
            this.queryParserName = in.readUTF();
        }
        if ((typesSize = in.readVInt()) > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readUTF();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeFloat(this.minScore);
        if (this.queryHint == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.queryHint);
        }
        if (this.routing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.routing);
        }
        out.writeVInt(this.querySourceLength);
        out.writeBytes(this.querySource, this.querySourceOffset, this.querySourceLength);
        if (this.queryParserName == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.queryParserName);
        }
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
    }

    public String toString() {
        return "[" + Arrays.toString(this.indices) + "]" + Arrays.toString(this.types) + ", querySource[" + Unicode.fromBytes(this.querySource) + "]";
    }
}

