/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport.action.support;

import java.lang.reflect.Constructor;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.transport.action.ClientTransportAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public abstract class BaseClientTransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends AbstractComponent
implements ClientTransportAction<Request, Response> {
    protected final TransportService transportService;
    private final Constructor<Response> responseConstructor;

    protected BaseClientTransportAction(Settings settings, TransportService transportService, Class<Response> type) {
        super(settings);
        this.transportService = transportService;
        try {
            this.responseConstructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ElasticSearchIllegalArgumentException("No default constructor is declared for [" + type.getName() + "]");
        }
        this.responseConstructor.setAccessible(true);
    }

    @Override
    public ActionFuture<Response> execute(DiscoveryNode node, Request request) throws ElasticSearchException {
        PlainActionFuture future = PlainActionFuture.newFuture();
        request.listenerThreaded(false);
        this.execute(node, request, future);
        return future;
    }

    @Override
    public void execute(DiscoveryNode node, Request request, ActionListener<Response> listener) {
        this.transportService.sendRequest(node, this.action(), (Streamable)request, this.options(), new BaseTransportResponseHandler<Response>((ActionRequest)request, listener){
            final /* synthetic */ ActionRequest val$request;
            final /* synthetic */ ActionListener val$listener;
            {
                this.val$request = actionRequest;
                this.val$listener = actionListener;
            }

            @Override
            public Response newInstance() {
                return BaseClientTransportAction.this.newInstance();
            }

            @Override
            public String executor() {
                if (this.val$request.listenerThreaded()) {
                    return "cached";
                }
                return "same";
            }

            @Override
            public void handleResponse(Response response) {
                this.val$listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                this.val$listener.onFailure(exp);
            }
        });
    }

    protected TransportRequestOptions options() {
        return TransportRequestOptions.EMPTY;
    }

    protected abstract String action();

    protected Response newInstance() {
        try {
            return (Response)((ActionResponse)this.responseConstructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new ElasticSearchIllegalStateException("Failed to create a new instance");
        }
    }
}

