/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolver;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.math.MathProcessor;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class OperativeAssign
extends ASTNode {
    private String varName;
    private ExecutableStatement statement;
    private final int operation;
    private int knownInType = -1;

    public OperativeAssign(String variableName, char[] expr, int start, int offset, int operation, int fields, ParserContext pCtx) {
        this.varName = variableName;
        this.operation = operation;
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        if ((fields & 0x10) != 0) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, offset, pCtx);
            this.egressType = this.statement.getKnownEgressType();
            if (pCtx.isStrongTyping()) {
                this.knownInType = ParseTools.__resolveType(this.egressType);
            }
            if (!pCtx.hasVarOrInput(this.varName)) {
                pCtx.addInput(this.varName, this.egressType);
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        VariableResolver resolver = factory.getVariableResolver(this.varName);
        ctx = MathProcessor.doOperations(resolver.getValue(), this.operation, this.knownInType, this.statement.getValue(ctx, thisValue, factory));
        resolver.setValue(ctx);
        return ctx;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        VariableResolver resolver = factory.getVariableResolver(this.varName);
        ctx = MathProcessor.doOperations(resolver.getValue(), this.operation, MVEL.eval(this.expr, this.start, this.offset, ctx, factory));
        resolver.setValue(ctx);
        return ctx;
    }
}

