/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public enum DistanceUnit {
    MILES(3959.0, 24902.0){

        public String toString() {
            return "miles";
        }

        @Override
        public double toMiles(double distance) {
            return distance;
        }

        @Override
        public double toKilometers(double distance) {
            return distance * 1.609344;
        }

        @Override
        public String toString(double distance) {
            return distance + "mi";
        }
    }
    ,
    KILOMETERS(6371.0, 40076.0){

        public String toString() {
            return "km";
        }

        @Override
        public double toMiles(double distance) {
            return distance / 1.609344;
        }

        @Override
        public double toKilometers(double distance) {
            return distance;
        }

        @Override
        public String toString(double distance) {
            return distance + "km";
        }
    };

    static final double MILES_KILOMETRES_RATIO = 1.609344;
    protected final double earthCircumference;
    protected final double earthRadius;

    public static double convert(double distance, DistanceUnit from, DistanceUnit to) {
        if (from == to) {
            return distance;
        }
        return to == MILES ? distance / 1.609344 : distance * 1.609344;
    }

    public static double parse(String distance, DistanceUnit defaultUnit, DistanceUnit to) {
        if (distance.endsWith("mi")) {
            return DistanceUnit.convert(Double.parseDouble(distance.substring(0, distance.length() - "mi".length())), MILES, to);
        }
        if (distance.endsWith("miles")) {
            return DistanceUnit.convert(Double.parseDouble(distance.substring(0, distance.length() - "miles".length())), MILES, to);
        }
        if (distance.endsWith("km")) {
            return DistanceUnit.convert(Double.parseDouble(distance.substring(0, distance.length() - "km".length())), KILOMETERS, to);
        }
        return DistanceUnit.convert(Double.parseDouble(distance), defaultUnit, to);
    }

    public static DistanceUnit parseUnit(String distance, DistanceUnit defaultUnit) {
        if (distance.endsWith("mi")) {
            return MILES;
        }
        if (distance.endsWith("miles")) {
            return MILES;
        }
        if (distance.endsWith("km")) {
            return KILOMETERS;
        }
        return defaultUnit;
    }

    private DistanceUnit(double earthRadius, double earthCircumference) {
        this.earthCircumference = earthCircumference;
        this.earthRadius = earthRadius;
    }

    public abstract double toMiles(double var1);

    public abstract double toKilometers(double var1);

    public abstract String toString(double var1);

    public static DistanceUnit fromString(String unit) {
        if ("km".equals(unit)) {
            return KILOMETERS;
        }
        if ("mi".equals(unit)) {
            return MILES;
        }
        if ("miles".equals(unit)) {
            return MILES;
        }
        throw new ElasticSearchIllegalArgumentException("No distance unit match [" + unit + "]");
    }

    public static void writeDistanceUnit(StreamOutput out, DistanceUnit unit) throws IOException {
        if (unit == MILES) {
            out.writeByte((byte)0);
        } else if (unit == KILOMETERS) {
            out.writeByte((byte)1);
        }
    }

    public static DistanceUnit readDistanceUnit(StreamInput in) throws IOException {
        byte b = in.readByte();
        if (b == 0) {
            return MILES;
        }
        if (b == 1) {
            return KILOMETERS;
        }
        throw new ElasticSearchIllegalArgumentException("No type for distance unit matching [" + b + "]");
    }
}

