/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.util.List;
import java.util.Map;

public class XContentMapValues {
    public static boolean isObject(Object node) {
        return node instanceof Map;
    }

    public static boolean isArray(Object node) {
        return node instanceof List;
    }

    public static String nodeStringValue(Object node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.toString();
    }

    public static float nodeFloatValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).floatValue();
        }
        return Float.parseFloat(node.toString());
    }

    public static double nodeDoubleValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).doubleValue();
        }
        return Double.parseDouble(node.toString());
    }

    public static int nodeIntegerValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).intValue();
        }
        return Integer.parseInt(node.toString());
    }

    public static int nodeIntegerValue(Object node, int defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        if (node instanceof Number) {
            return ((Number)node).intValue();
        }
        return Integer.parseInt(node.toString());
    }

    public static short nodeShortValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).shortValue();
        }
        return Short.parseShort(node.toString());
    }

    public static byte nodeByteValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).byteValue();
        }
        return Byte.parseByte(node.toString());
    }

    public static long nodeLongValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).longValue();
        }
        return Long.parseLong(node.toString());
    }

    public static boolean nodeBooleanValue(Object node, boolean defaulValue) {
        if (node == null) {
            return defaulValue;
        }
        return XContentMapValues.nodeBooleanValue(node);
    }

    public static boolean nodeBooleanValue(Object node) {
        if (node instanceof Boolean) {
            return (Boolean)node;
        }
        if (node instanceof Number) {
            return ((Number)node).intValue() != 0;
        }
        String value = node.toString();
        return !value.equals("false") && !value.equals("0") && !value.equals("off");
    }
}

