/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.CharStream;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.lucene.analysis.HTMLStripCharFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractCharFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class HtmlStripCharFilterFactory
extends AbstractCharFilterFactory {
    private final ImmutableSet<String> escapedTags;
    private final int readAheadLimit;

    @Inject
    public HtmlStripCharFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name);
        this.readAheadLimit = settings.getAsInt("read_ahead", 8192);
        String[] escapedTags = settings.getAsArray("escaped_tags");
        this.escapedTags = escapedTags.length > 0 ? ImmutableSet.copyOf(escapedTags) : null;
    }

    public ImmutableSet<String> escapedTags() {
        return this.escapedTags;
    }

    public int readAheadLimit() {
        return this.readAheadLimit;
    }

    @Override
    public CharStream create(CharStream tokenStream) {
        return new HTMLStripCharFilter(tokenStream, this.escapedTags, this.readAheadLimit);
    }
}

