/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.LengthFilter;
import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class LengthTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int min;
    private final int max;
    private final boolean enablePositionIncrements;

    @Inject
    public LengthTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.min = settings.getAsInt("min", 0);
        this.max = settings.getAsInt("max", Integer.MAX_VALUE);
        this.enablePositionIncrements = settings.getAsBoolean("enabled_position_increments", true);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new LengthFilter(this.enablePositionIncrements, tokenStream, this.min, this.max);
    }
}

