/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.bloom.simple;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.bloom.BloomFilter;
import org.elasticsearch.common.bloom.BloomFilterFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.SizeUnit;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.bloom.BloomCache;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.threadpool.ThreadPool;

public class SimpleBloomCache
extends AbstractIndexComponent
implements BloomCache,
IndexReader.ReaderFinishedListener {
    private final ThreadPool threadPool;
    private final long maxSize;
    private final ConcurrentMap<Object, ConcurrentMap<String, BloomFilterEntry>> cache;
    private final Object creationMutex = new Object();

    @Inject
    public SimpleBloomCache(Index index, @IndexSettings Settings indexSettings, ThreadPool threadPool) {
        super(index, indexSettings);
        this.threadPool = threadPool;
        this.maxSize = indexSettings.getAsSize("index.cache.bloom.max_size", new SizeValue(500L, SizeUnit.MEGA)).singles();
        this.cache = ConcurrentCollections.newConcurrentMap();
    }

    @Override
    public void close() throws ElasticSearchException {
        this.clear();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public void finished(IndexReader reader) {
        this.clear(reader);
    }

    @Override
    public void clear(IndexReader reader) {
        ConcurrentMap map = (ConcurrentMap)this.cache.remove(reader.getCoreCacheKey());
        if (map != null) {
            map.clear();
        }
    }

    @Override
    public long sizeInBytes() {
        long sizeInBytes = 0L;
        for (ConcurrentMap map : this.cache.values()) {
            for (BloomFilterEntry filter : map.values()) {
                sizeInBytes += filter.filter.sizeInBytes();
            }
        }
        return sizeInBytes;
    }

    @Override
    public long sizeInBytes(String fieldName) {
        long sizeInBytes = 0L;
        for (ConcurrentMap map : this.cache.values()) {
            BloomFilterEntry filter = (BloomFilterEntry)map.get(fieldName);
            if (filter == null) continue;
            sizeInBytes += filter.filter.sizeInBytes();
        }
        return sizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BloomFilter filter(IndexReader reader, String fieldName, boolean asyncLoad) {
        BloomFilterEntry filter;
        int currentNumDocs = reader.numDocs();
        if (currentNumDocs == 0) {
            return BloomFilter.EMPTY;
        }
        ConcurrentMap<String, BloomFilterEntry> fieldCache = (ConcurrentMap<String, BloomFilterEntry>)this.cache.get(reader.getCoreCacheKey());
        if (fieldCache == null) {
            Object object = this.creationMutex;
            synchronized (object) {
                fieldCache = (ConcurrentMap)this.cache.get(reader.getCoreCacheKey());
                if (fieldCache == null) {
                    reader.addReaderFinishedListener((IndexReader.ReaderFinishedListener)this);
                    fieldCache = ConcurrentCollections.newConcurrentMap();
                    this.cache.put(reader.getCoreCacheKey(), fieldCache);
                }
            }
        }
        if ((filter = (BloomFilterEntry)fieldCache.get(fieldName)) == null) {
            ConcurrentMap<String, BloomFilterEntry> concurrentMap = fieldCache;
            synchronized (concurrentMap) {
                filter = (BloomFilterEntry)fieldCache.get(fieldName);
                if (filter == null) {
                    filter = new BloomFilterEntry(currentNumDocs, BloomFilter.NONE);
                    fieldCache.put(fieldName, filter);
                    if ((long)currentNumDocs < this.maxSize) {
                        filter.loading.set(true);
                        BloomFilterLoader loader = new BloomFilterLoader(reader, fieldName);
                        if (asyncLoad) {
                            this.threadPool.cached().execute(loader);
                        } else {
                            loader.run();
                            filter = (BloomFilterEntry)fieldCache.get(fieldName);
                        }
                    }
                }
            }
        }
        if (filter.numDocs > 1000 && (long)filter.numDocs < this.maxSize && (double)(currentNumDocs / filter.numDocs) < 0.6 && filter.loading.compareAndSet(false, true)) {
            BloomFilterLoader loader = new BloomFilterLoader(reader, fieldName);
            if (asyncLoad) {
                this.threadPool.cached().execute(loader);
            } else {
                loader.run();
                filter = (BloomFilterEntry)fieldCache.get(fieldName);
            }
        }
        return filter.filter;
    }

    static class BloomFilterEntry {
        final int numDocs;
        final BloomFilter filter;
        final AtomicBoolean loading = new AtomicBoolean();

        public BloomFilterEntry(int numDocs, BloomFilter filter) {
            this.numDocs = numDocs;
            this.filter = filter;
        }
    }

    class BloomFilterLoader
    implements Runnable {
        private final IndexReader reader;
        private final String field;

        BloomFilterLoader(IndexReader reader, String field) {
            this.reader = reader;
            this.field = StringHelper.intern((String)field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TermDocs termDocs = null;
            TermEnum termEnum = null;
            try {
                ConcurrentMap fieldCache;
                Term term;
                BloomFilter filter = BloomFilterFactory.getFilter((long)this.reader.numDocs(), 15);
                termDocs = this.reader.termDocs();
                termEnum = this.reader.terms(new Term(this.field));
                while ((term = termEnum.term()) != null && term.field() == this.field) {
                    UnicodeUtil.UTF8Result utf8Result = Unicode.fromStringAsUtf8(term.text());
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        if (this.reader.isDeleted(termDocs.doc())) continue;
                        filter.add(utf8Result.result, 0, utf8Result.length);
                    }
                    if (termEnum.next()) continue;
                }
                if ((fieldCache = (ConcurrentMap)SimpleBloomCache.this.cache.get(this.reader.getCoreCacheKey())) != null && fieldCache.containsKey(this.field)) {
                    BloomFilterEntry filterEntry = new BloomFilterEntry(this.reader.numDocs(), filter);
                    filterEntry.loading.set(false);
                    fieldCache.put(this.field, filterEntry);
                }
            }
            catch (AlreadyClosedException e) {
            }
            catch (Exception e) {
                SimpleBloomCache.this.logger.warn("failed to load bloom filter for [{}]", e, this.field);
            }
            finally {
                try {
                    if (termDocs != null) {
                        termDocs.close();
                    }
                }
                catch (IOException e) {}
                try {
                    if (termEnum != null) {
                        termEnum.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

