/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.IntegerFieldMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.NumberFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;

public class SizeFieldMapper
extends IntegerFieldMapper {
    public static final String CONTENT_TYPE = "_size";
    private final boolean enabled;

    public SizeFieldMapper() {
        this(false, Defaults.STORE);
    }

    public SizeFieldMapper(boolean enabled, Field.Store store) {
        super(new FieldMapper.Names(CONTENT_TYPE), 4, Defaults.FUZZY_FACTOR, Defaults.INDEX, store, 1.0f, true, true, Defaults.NULL_VALUE);
        this.enabled = enabled;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        if (!this.enabled) {
            return null;
        }
        return new IntegerFieldMapper.CustomIntegerNumericField((NumberFieldMapper)this, ((Number)context.externalValue()).intValue());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.enabled && this.store == Defaults.STORE) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class Builder
    extends XContentMapper.Builder<Builder, IntegerFieldMapper> {
        protected boolean enabled = false;
        protected Field.Store store = Defaults.STORE;

        public Builder() {
            super(SizeFieldMapper.CONTENT_TYPE);
            this.builder = this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return (Builder)this.builder;
        }

        public Builder store(Field.Store store) {
            this.store = store;
            return (Builder)this.builder;
        }

        @Override
        public SizeFieldMapper build(XContentMapper.BuilderContext context) {
            return new SizeFieldMapper(this.enabled, this.store);
        }
    }

    public static class Defaults
    extends IntegerFieldMapper.Defaults {
        public static final String NAME = "_size";
        public static final boolean ENABLED = false;
    }
}

