/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.internal.SearchContext;

public class CustomScoreQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "custom_score";

    @Inject
    public CustomScoreQueryParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query query = null;
        float boost = 1.0f;
        String script = null;
        String scriptLang = null;
        Map<String, Object> vars = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    continue;
                }
                if (!"params".equals(currentFieldName)) continue;
                vars = parser.map();
                continue;
            }
            if (!token.isValue()) continue;
            if ("script".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("lang".equals(currentFieldName)) {
                scriptLang = parser.text();
                continue;
            }
            if (!"boost".equals(currentFieldName)) continue;
            boost = parser.floatValue();
        }
        if (query == null) {
            throw new QueryParsingException(this.index, "[custom_score] requires 'query' field");
        }
        if (script == null) {
            throw new QueryParsingException(this.index, "[custom_score] requires 'script' field");
        }
        SearchContext context = SearchContext.current();
        if (context == null) {
            throw new ElasticSearchIllegalStateException("No search context on going...");
        }
        SearchScript searchScript = context.scriptService().search(context.lookup(), scriptLang, script, vars);
        FunctionScoreQuery functionScoreQuery = new FunctionScoreQuery(query, new ScriptScoreFunction(searchScript));
        functionScoreQuery.setBoost(boost);
        return functionScoreQuery;
    }

    public static class ScriptScoreFunction
    implements ScoreFunction {
        private final SearchScript script;

        private ScriptScoreFunction(SearchScript script) {
            this.script = script;
        }

        @Override
        public void setNextReader(IndexReader reader) {
            this.script.setNextReader(reader);
        }

        @Override
        public float score(int docId, float subQueryScore) {
            this.script.setNextDocId(docId);
            this.script.setNextScore(subQueryScore);
            return this.script.runAsFloat();
        }

        @Override
        public Explanation explain(int docId, Explanation subQueryExpl) {
            float score = this.score(docId, subQueryExpl.getValue());
            Explanation exp = new Explanation(score, "script score function: product of:");
            exp.addDetail(subQueryExpl);
            return exp;
        }
    }
}

