/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.trove.map.hash.TObjectFloatHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;

public class QueryStringQueryBuilder
extends BaseQueryBuilder {
    private final String queryString;
    private String defaultField;
    private Operator defaultOperator;
    private String analyzer;
    private Boolean autoGeneratePhraseQueries;
    private Boolean allowLeadingWildcard;
    private Boolean lowercaseExpandedTerms;
    private Boolean enablePositionIncrements;
    private Boolean analyzeWildcard;
    private float fuzzyMinSim = -1.0f;
    private float boost = -1.0f;
    private int fuzzyPrefixLength = -1;
    private int phraseSlop = -1;
    private List<String> fields;
    private TObjectFloatHashMap<String> fieldsBoosts;
    private Boolean useDisMax;
    private float tieBreaker = -1.0f;

    public QueryStringQueryBuilder(String queryString) {
        this.queryString = queryString;
    }

    public QueryStringQueryBuilder defaultField(String defaultField) {
        this.defaultField = defaultField;
        return this;
    }

    public QueryStringQueryBuilder field(String field) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(field);
        return this;
    }

    public QueryStringQueryBuilder field(String field, float boost) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(field);
        if (this.fieldsBoosts == null) {
            this.fieldsBoosts = new TObjectFloatHashMap(10, 0.5f, -1.0f);
        }
        this.fieldsBoosts.put(field, boost);
        return this;
    }

    public QueryStringQueryBuilder useDisMax(boolean useDisMax) {
        this.useDisMax = useDisMax;
        return this;
    }

    public QueryStringQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
        return this;
    }

    public QueryStringQueryBuilder defaultOperator(Operator defaultOperator) {
        this.defaultOperator = defaultOperator;
        return this;
    }

    public QueryStringQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public void autoGeneratePhraseQueries(boolean autoGeneratePhraseQueries) {
        this.autoGeneratePhraseQueries = autoGeneratePhraseQueries;
    }

    public QueryStringQueryBuilder allowLeadingWildcard(boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
        return this;
    }

    public QueryStringQueryBuilder lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        return this;
    }

    public QueryStringQueryBuilder enablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
        return this;
    }

    public QueryStringQueryBuilder fuzzyMinSim(float fuzzyMinSim) {
        this.fuzzyMinSim = fuzzyMinSim;
        return this;
    }

    public QueryStringQueryBuilder fuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
        return this;
    }

    public QueryStringQueryBuilder phraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
        return this;
    }

    public QueryStringQueryBuilder analyzeWildcard(boolean analyzeWildcard) {
        this.analyzeWildcard = analyzeWildcard;
        return this;
    }

    public QueryStringQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("query_string");
        builder.field("query", this.queryString);
        if (this.defaultField != null) {
            builder.field("default_field", this.defaultField);
        }
        if (this.fields != null) {
            builder.startArray("fields");
            for (String field : this.fields) {
                float boost = -1.0f;
                if (this.fieldsBoosts != null) {
                    boost = this.fieldsBoosts.get(field);
                }
                if (boost != -1.0f) {
                    field = field + "^" + boost;
                }
                builder.value(field);
            }
            builder.endArray();
        }
        if (this.useDisMax != null) {
            builder.field("use_dis_max", (Object)this.useDisMax);
        }
        if (this.tieBreaker != -1.0f) {
            builder.field("tie_breaker", this.tieBreaker);
        }
        if (this.defaultOperator != null) {
            builder.field("default_operator", this.defaultOperator.name().toLowerCase());
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.autoGeneratePhraseQueries != null) {
            builder.field("auto_generate_phrase_queries", (Object)this.autoGeneratePhraseQueries);
        }
        if (this.allowLeadingWildcard != null) {
            builder.field("allow_leading_wildcard", (Object)this.allowLeadingWildcard);
        }
        if (this.lowercaseExpandedTerms != null) {
            builder.field("lowercase_expanded_terms", (Object)this.lowercaseExpandedTerms);
        }
        if (this.enablePositionIncrements != null) {
            builder.field("enable_position_increments", (Object)this.enablePositionIncrements);
        }
        if (this.fuzzyMinSim != -1.0f) {
            builder.field("fuzzy_min_sim", this.fuzzyMinSim);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.fuzzyPrefixLength != -1) {
            builder.field("fuzzy_prefix_length", this.fuzzyPrefixLength);
        }
        if (this.phraseSlop != -1) {
            builder.field("phrase_slop", this.phraseSlop);
        }
        if (this.analyzeWildcard != null) {
            builder.field("analyze_wildcard", (Object)this.analyzeWildcard);
        }
        builder.endObject();
    }

    public static enum Operator {
        OR,
        AND;

    }
}

