/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldData;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldDataType;
import org.elasticsearch.index.search.geo.GeoDistance;

public class GeoDistanceDataComparator
extends FieldComparator {
    protected final String fieldName;
    protected final String indexFieldName;
    protected final double lat;
    protected final double lon;
    protected final DistanceUnit unit;
    protected final GeoDistance geoDistance;
    protected final FieldDataCache fieldDataCache;
    protected GeoPointFieldData fieldData;
    private final double[] values;
    private double bottom;

    public static FieldComparatorSource comparatorSource(String fieldName, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, FieldDataCache fieldDataCache, MapperService mapperService) {
        return new InnerSource(fieldName, lat, lon, unit, geoDistance, fieldDataCache, mapperService);
    }

    public GeoDistanceDataComparator(int numHits, String fieldName, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, FieldDataCache fieldDataCache, MapperService mapperService) {
        this.values = new double[numHits];
        this.fieldName = fieldName;
        this.lat = lat;
        this.lon = lon;
        this.unit = unit;
        this.geoDistance = geoDistance;
        this.fieldDataCache = fieldDataCache;
        FieldMapper mapper = mapperService.smartNameFieldMapper(fieldName);
        if (mapper == null) {
            throw new ElasticSearchIllegalArgumentException("No mapping found for field [" + fieldName + "] for geo distance sort");
        }
        if (mapper.fieldDataType() != GeoPointFieldDataType.TYPE) {
            throw new ElasticSearchIllegalArgumentException("field [" + fieldName + "] is not a geo_point field");
        }
        this.indexFieldName = mapper.names().indexName();
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (GeoPointFieldData)this.fieldDataCache.cache(GeoPointFieldDataType.TYPE, reader, this.indexFieldName);
    }

    public int compare(int slot1, int slot2) {
        double v1 = this.values[slot1];
        double v2 = this.values[slot2];
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    public int compareBottom(int doc) {
        double distance = !this.fieldData.hasValue(doc) ? Double.MAX_VALUE : this.geoDistance.calculate(this.lat, this.lon, this.fieldData.latValue(doc), this.fieldData.lonValue(doc), this.unit);
        double v2 = distance;
        if (this.bottom > v2) {
            return 1;
        }
        if (this.bottom < v2) {
            return -1;
        }
        return 0;
    }

    public void copy(int slot, int doc) {
        double distance = !this.fieldData.hasValue(doc) ? Double.MAX_VALUE : this.geoDistance.calculate(this.lat, this.lon, this.fieldData.latValue(doc), this.fieldData.lonValue(doc), this.unit);
        this.values[slot] = distance;
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Double.valueOf(this.values[slot]);
    }

    private static class InnerSource
    extends FieldComparatorSource {
        protected final String fieldName;
        protected final double lat;
        protected final double lon;
        protected final DistanceUnit unit;
        protected final GeoDistance geoDistance;
        protected final FieldDataCache fieldDataCache;
        private final MapperService mapperService;

        private InnerSource(String fieldName, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, FieldDataCache fieldDataCache, MapperService mapperService) {
            this.fieldName = fieldName;
            this.lat = lat;
            this.lon = lon;
            this.unit = unit;
            this.geoDistance = geoDistance;
            this.fieldDataCache = fieldDataCache;
            this.mapperService = mapperService;
        }

        public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new GeoDistanceDataComparator(numHits, fieldname, this.lat, this.lon, this.unit, this.geoDistance, this.fieldDataCache, this.mapperService);
        }
    }
}

