/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.filter;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHitCountCollector;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.OptimizeGlobalFacetCollector;
import org.elasticsearch.search.facet.filter.InternalFilterFacet;
import org.elasticsearch.search.internal.SearchContext;

public class FilterFacetCollector
extends AbstractFacetCollector
implements OptimizeGlobalFacetCollector {
    private final Filter filter;
    private DocSet docSet;
    private int count = 0;

    public FilterFacetCollector(String facetName, Filter filter, FilterCache filterCache) {
        super(facetName);
        this.filter = filter;
    }

    @Override
    public void optimizedGlobalExecution(SearchContext searchContext) throws IOException {
        DeletionAwareConstantScoreQuery query = new DeletionAwareConstantScoreQuery(this.filter);
        if (((AbstractFacetCollector)this).filter != null) {
            query = new FilteredQuery((Query)query, ((AbstractFacetCollector)this).filter);
        }
        if (searchContext.types().length > 0) {
            query = new FilteredQuery((Query)query, searchContext.filterCache().cache(searchContext.mapperService().typesFilter(searchContext.types())));
        }
        TotalHitCountCollector collector = new TotalHitCountCollector();
        searchContext.searcher().search((Query)query, (Collector)collector);
        this.count = collector.getTotalHits();
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.docSet = DocSets.convert(reader, this.filter.getDocIdSet(reader));
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        if (this.docSet.get(doc)) {
            ++this.count;
        }
    }

    @Override
    public Facet facet() {
        return new InternalFilterFacet(this.facetName, this.count);
    }
}

