/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.ClientSmallReversedScanner;
import org.apache.hadoop.hbase.client.ClientSmallScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnectable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionCoprocessorServiceExec;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.ReversedClientScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCallerWithReadReplicas;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.UnmodifyableHTableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RegionCoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HTable
implements HTableInterface {
    private static final Log LOG = LogFactory.getLog(HTable.class);
    protected ClusterConnection connection;
    private final TableName tableName;
    private volatile Configuration configuration;
    protected List<Row> writeAsyncBuffer = new LinkedList<Row>();
    private long writeBufferSize;
    private boolean clearBufferOnFail;
    private boolean autoFlush;
    protected long currentWriteBufferSize;
    protected int scannerCaching;
    private int maxKeyValueSize;
    private ExecutorService pool;
    private boolean closed;
    private int operationTimeout;
    private int retries;
    private final boolean cleanupPoolOnClose;
    private final boolean cleanupConnectionOnClose;
    private Consistency defaultConsistency = Consistency.STRONG;
    private int primaryCallTimeoutMicroSecond;
    private int replicaCallTimeoutMicroSecondScan;
    protected AsyncProcess ap;
    protected AsyncProcess multiAp;
    private RpcRetryingCallerFactory rpcCallerFactory;
    private RpcControllerFactory rpcControllerFactory;

    public HTable(Configuration conf, String tableName) throws IOException {
        this(conf, TableName.valueOf((String)tableName));
    }

    public HTable(Configuration conf, byte[] tableName) throws IOException {
        this(conf, TableName.valueOf((byte[])tableName));
    }

    public HTable(Configuration conf, TableName tableName) throws IOException {
        this.tableName = tableName;
        this.cleanupConnectionOnClose = true;
        this.cleanupPoolOnClose = true;
        if (conf == null) {
            this.connection = null;
            return;
        }
        this.connection = ConnectionManager.getConnectionInternal(conf);
        this.configuration = conf;
        this.pool = HTable.getDefaultExecutor(conf);
        this.finishSetup();
    }

    @Deprecated
    public HTable(TableName tableName, HConnection connection) throws IOException {
        this.tableName = tableName;
        this.cleanupPoolOnClose = true;
        this.cleanupConnectionOnClose = false;
        this.connection = (ClusterConnection)connection;
        this.configuration = connection.getConfiguration();
        this.pool = HTable.getDefaultExecutor(this.configuration);
        this.finishSetup();
    }

    public static ThreadPoolExecutor getDefaultExecutor(Configuration conf) {
        int maxThreads = conf.getInt("hbase.htable.threads.max", Integer.MAX_VALUE);
        if (maxThreads == 0) {
            maxThreads = 1;
        }
        long keepAliveTime = conf.getLong("hbase.htable.threads.keepalivetime", 60L);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, maxThreads, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"htable"));
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    public HTable(Configuration conf, byte[] tableName, ExecutorService pool) throws IOException {
        this(conf, TableName.valueOf((byte[])tableName), pool);
    }

    public HTable(Configuration conf, TableName tableName, ExecutorService pool) throws IOException {
        this.connection = ConnectionManager.getConnectionInternal(conf);
        this.configuration = conf;
        this.pool = pool;
        if (pool == null) {
            this.pool = HTable.getDefaultExecutor(conf);
            this.cleanupPoolOnClose = true;
        } else {
            this.cleanupPoolOnClose = false;
        }
        this.tableName = tableName;
        this.cleanupConnectionOnClose = true;
        this.finishSetup();
    }

    @Deprecated
    public HTable(byte[] tableName, HConnection connection, ExecutorService pool) throws IOException {
        this(TableName.valueOf((byte[])tableName), connection, pool);
    }

    @Deprecated
    public HTable(TableName tableName, HConnection connection, ExecutorService pool) throws IOException {
        this(tableName, (ClusterConnection)connection, pool);
    }

    @InterfaceAudience.Private
    public HTable(TableName tableName, ClusterConnection connection, ExecutorService pool) throws IOException {
        if (connection == null || connection.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = tableName;
        this.cleanupConnectionOnClose = false;
        this.connection = connection;
        this.configuration = connection.getConfiguration();
        this.pool = pool;
        if (pool == null) {
            this.pool = HTable.getDefaultExecutor(this.configuration);
            this.cleanupPoolOnClose = true;
        } else {
            this.cleanupPoolOnClose = false;
        }
        this.finishSetup();
    }

    protected HTable() {
        this.tableName = null;
        this.cleanupPoolOnClose = false;
        this.cleanupConnectionOnClose = false;
    }

    private void finishSetup() throws IOException {
        this.operationTimeout = this.tableName.isSystemTable() ? this.configuration.getInt("hbase.client.meta.operation.timeout", Integer.MAX_VALUE) : this.configuration.getInt("hbase.client.operation.timeout", Integer.MAX_VALUE);
        this.writeBufferSize = this.configuration.getLong("hbase.client.write.buffer", 0x200000L);
        this.clearBufferOnFail = true;
        this.autoFlush = true;
        this.currentWriteBufferSize = 0L;
        this.scannerCaching = this.configuration.getInt(HConstants.HBASE_CLIENT_SCANNER_CACHING, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_CACHING);
        this.primaryCallTimeoutMicroSecond = this.configuration.getInt("hbase.client.primaryCallTimeout.get", 10000);
        this.replicaCallTimeoutMicroSecondScan = this.configuration.getInt("hbase.client.replicaCallTimeout.scan", 1000000);
        this.retries = this.configuration.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        this.rpcCallerFactory = RpcRetryingCallerFactory.instantiate(this.configuration);
        this.rpcControllerFactory = RpcControllerFactory.instantiate(this.configuration);
        this.ap = new AsyncProcess(this.connection, this.configuration, this.pool, this.rpcCallerFactory, true, this.rpcControllerFactory);
        this.multiAp = this.connection.getAsyncProcess();
        this.maxKeyValueSize = this.configuration.getInt("hbase.client.keyvalue.maxsize", -1);
        this.closed = false;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public static boolean isTableEnabled(String tableName) throws IOException {
        return HTable.isTableEnabled(TableName.valueOf((String)tableName));
    }

    @Deprecated
    public static boolean isTableEnabled(byte[] tableName) throws IOException {
        return HTable.isTableEnabled(TableName.valueOf((byte[])tableName));
    }

    @Deprecated
    public static boolean isTableEnabled(TableName tableName) throws IOException {
        return HTable.isTableEnabled(HBaseConfiguration.create(), tableName);
    }

    @Deprecated
    public static boolean isTableEnabled(Configuration conf, String tableName) throws IOException {
        return HTable.isTableEnabled(conf, TableName.valueOf((String)tableName));
    }

    @Deprecated
    public static boolean isTableEnabled(Configuration conf, byte[] tableName) throws IOException {
        return HTable.isTableEnabled(conf, TableName.valueOf((byte[])tableName));
    }

    @Deprecated
    public static boolean isTableEnabled(Configuration conf, final TableName tableName) throws IOException {
        return HConnectionManager.execute(new HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) throws IOException {
                return connection.isTableEnabled(tableName);
            }
        });
    }

    public HRegionLocation getRegionLocation(String row) throws IOException {
        return this.connection.getRegionLocation(this.tableName, Bytes.toBytes((String)row), false);
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.connection.getRegionLocation(this.tableName, row, false);
    }

    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        return this.connection.getRegionLocation(this.tableName, row, reload);
    }

    @Override
    public byte[] getTableName() {
        return this.tableName.getName();
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Deprecated
    @VisibleForTesting
    public HConnection getConnection() {
        return this.connection;
    }

    @Deprecated
    public int getScannerCaching() {
        return this.scannerCaching;
    }

    @Deprecated
    public List<Row> getWriteBuffer() {
        return this.writeAsyncBuffer;
    }

    @Deprecated
    public void setScannerCaching(int scannerCaching) {
        this.scannerCaching = scannerCaching;
    }

    @Override
    public HTableDescriptor getTableDescriptor() throws IOException {
        return new UnmodifyableHTableDescriptor(this.connection.getHTableDescriptor(this.tableName));
    }

    public byte[][] getStartKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getFirst();
    }

    public byte[][] getEndKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getSecond();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        List<RegionLocations> regions = this.listRegionLocations();
        ArrayList<byte[]> startKeyList = new ArrayList<byte[]>(regions.size());
        ArrayList<byte[]> endKeyList = new ArrayList<byte[]>(regions.size());
        for (RegionLocations locations : regions) {
            HRegionInfo region = locations.getRegionLocation().getRegionInfo();
            startKeyList.add(region.getStartKey());
            endKeyList.add(region.getEndKey());
        }
        return new Pair(startKeyList.toArray((T[])new byte[startKeyList.size()][]), endKeyList.toArray((T[])new byte[endKeyList.size()][]));
    }

    @VisibleForTesting
    List<RegionLocations> listRegionLocations() throws IOException {
        return MetaScanner.listTableRegionLocations(this.getConfiguration(), this.connection, this.getName());
    }

    @Deprecated
    public NavigableMap<HRegionInfo, ServerName> getRegionLocations() throws IOException {
        return MetaScanner.allTableRegions(this.getConfiguration(), this.connection, this.getName(), false);
    }

    @Deprecated
    public List<HRegionLocation> getRegionsInRange(byte[] startKey, byte[] endKey) throws IOException {
        return this.getRegionsInRange(startKey, endKey, false);
    }

    @Deprecated
    public List<HRegionLocation> getRegionsInRange(byte[] startKey, byte[] endKey, boolean reload) throws IOException {
        return (List)this.getKeysAndRegionsInRange(startKey, endKey, false, reload).getSecond();
    }

    @Deprecated
    private Pair<List<byte[]>, List<HRegionLocation>> getKeysAndRegionsInRange(byte[] startKey, byte[] endKey, boolean includeEndKey) throws IOException {
        return this.getKeysAndRegionsInRange(startKey, endKey, includeEndKey, false);
    }

    @Deprecated
    private Pair<List<byte[]>, List<HRegionLocation>> getKeysAndRegionsInRange(byte[] startKey, byte[] endKey, boolean includeEndKey, boolean reload) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
        }
        ArrayList<byte[]> keysInRange = new ArrayList<byte[]>();
        ArrayList<HRegionLocation> regionsInRange = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            regionLocation = this.getRegionLocation(currentKey, reload);
            keysInRange.add(currentKey);
            regionsInRange.add(regionLocation);
        } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0 || includeEndKey && Bytes.compareTo((byte[])currentKey, (byte[])endKey) == 0));
        return new Pair(keysInRange, regionsInRange);
    }

    @Override
    public Result getRowOrBefore(byte[] row, final byte[] family) throws IOException {
        RegionServerCallable<Result> callable = new RegionServerCallable<Result>((HConnection)this.connection, this.tableName, row){

            @Override
            public Result call() throws IOException {
                return ProtobufUtil.getRowOrBefore(this.getStub(), this.getLocation().getRegionInfo().getRegionName(), this.row, family, HTable.this.rpcControllerFactory.newController());
            }
        };
        return this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        if (scan.getCaching() <= 0) {
            scan.setCaching(this.getScannerCaching());
        }
        if (scan.isReversed()) {
            if (scan.isSmall()) {
                return new ClientSmallReversedScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.replicaCallTimeoutMicroSecondScan);
            }
            return new ReversedClientScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.replicaCallTimeoutMicroSecondScan);
        }
        if (scan.isSmall()) {
            return new ClientSmallScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.replicaCallTimeoutMicroSecondScan);
        }
        return new ClientScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.replicaCallTimeoutMicroSecondScan);
    }

    @Override
    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    @Override
    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    @Override
    public Result get(final Get get) throws IOException {
        if (get.getConsistency() == null) {
            get.setConsistency(this.defaultConsistency);
        }
        if (get.getConsistency() == Consistency.STRONG) {
            final PayloadCarryingRpcController controller = this.rpcControllerFactory.newController();
            controller.setPriority(this.tableName);
            RegionServerCallable<Result> callable = new RegionServerCallable<Result>((HConnection)this.connection, this.getName(), get.getRow()){

                @Override
                public Result call() throws IOException {
                    return ProtobufUtil.get(this.getStub(), this.getLocation().getRegionInfo().getRegionName(), get, controller);
                }
            };
            return this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
        }
        RpcRetryingCallerWithReadReplicas callable = new RpcRetryingCallerWithReadReplicas(this.rpcControllerFactory, this.tableName, this.connection, get, this.pool, this.retries, this.operationTimeout, this.primaryCallTimeoutMicroSecond);
        return callable.call();
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        if (gets.size() == 1) {
            return new Result[]{this.get(gets.get(0))};
        }
        try {
            Object[] r1 = this.batch(gets);
            Result[] results = new Result[r1.length];
            int i = 0;
            for (Object o : r1) {
                results[i++] = (Result)o;
            }
            return results;
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }

    @Override
    public void batch(List<? extends Row> actions, Object[] results) throws InterruptedException, IOException {
        AsyncProcess.AsyncRequestFuture ars = this.multiAp.submitAll(this.pool, this.tableName, actions, null, results);
        ars.waitUntilDone();
        if (ars.hasError()) {
            throw ars.getErrors();
        }
    }

    @Override
    @Deprecated
    public Object[] batch(List<? extends Row> actions) throws InterruptedException, IOException {
        Object[] results = new Object[actions.size()];
        this.batch(actions, results);
        return results;
    }

    @Override
    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.connection.processBatchCallback(actions, this.tableName, this.pool, results, callback);
    }

    @Override
    @Deprecated
    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        Object[] results = new Object[actions.size()];
        this.batchCallback(actions, results, callback);
        return results;
    }

    @Override
    public void delete(final Delete delete) throws IOException {
        RegionServerCallable<Boolean> callable = new RegionServerCallable<Boolean>((HConnection)this.connection, this.tableName, delete.getRow()){

            @Override
            public Boolean call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), delete);
                    PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                    controller.setPriority(this.tableName);
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)controller, request);
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        Object[] results = new Object[deletes.size()];
        try {
            this.batch(deletes, results);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        finally {
            for (int i = results.length - 1; i >= 0; --i) {
                if (!(results[i] instanceof Result)) continue;
                deletes.remove(i);
            }
        }
    }

    @Override
    public void put(Put put) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.doPut(put);
        if (this.autoFlush) {
            this.flushCommits();
        }
    }

    @Override
    public void put(List<Put> puts) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        for (Put put : puts) {
            this.doPut(put);
        }
        if (this.autoFlush) {
            this.flushCommits();
        }
    }

    private void doPut(Put put) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        if (this.ap.hasError()) {
            this.writeAsyncBuffer.add(put);
            this.backgroundFlushCommits(true);
        }
        this.validatePut(put);
        this.currentWriteBufferSize += put.heapSize();
        this.writeAsyncBuffer.add(put);
        while (this.currentWriteBufferSize > this.writeBufferSize) {
            this.backgroundFlushCommits(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundFlushCommits(boolean synchronous) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        try {
            if (!synchronous) {
                this.ap.submit(this.tableName, this.writeAsyncBuffer, true, null, false);
                if (this.ap.hasError()) {
                    LOG.debug((Object)(this.tableName + ": One or more of the operations have failed -" + " waiting for all operation in progress to finish (successfully or not)"));
                }
            }
            if (synchronous || this.ap.hasError()) {
                while (!this.writeAsyncBuffer.isEmpty()) {
                    this.ap.submit(this.tableName, this.writeAsyncBuffer, true, null, false);
                }
                List<Row> failedRows = this.clearBufferOnFail ? null : this.writeAsyncBuffer;
                RetriesExhaustedWithDetailsException error = this.ap.waitForAllPreviousOpsAndReset(failedRows);
                if (error != null) {
                    throw error;
                }
            }
        }
        finally {
            this.currentWriteBufferSize = 0L;
            for (Row mut : this.writeAsyncBuffer) {
                if (!(mut instanceof Mutation)) continue;
                this.currentWriteBufferSize += ((Mutation)mut).heapSize();
            }
        }
    }

    @Override
    public void mutateRow(final RowMutations rm) throws IOException {
        RegionServerCallable<Void> callable = new RegionServerCallable<Void>((HConnection)this.connection, this.getName(), rm.getRow()){

            @Override
            public Void call() throws IOException {
                try {
                    ClientProtos.RegionAction.Builder regionMutationBuilder = RequestConverter.buildRegionAction(this.getLocation().getRegionInfo().getRegionName(), rm);
                    regionMutationBuilder.setAtomic(true);
                    ClientProtos.MultiRequest request = ClientProtos.MultiRequest.newBuilder().addRegionAction(regionMutationBuilder.build()).build();
                    PayloadCarryingRpcController pcrc = HTable.this.rpcControllerFactory.newController();
                    pcrc.setPriority(this.tableName);
                    this.getStub().multi((RpcController)pcrc, request);
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
                return null;
            }
        };
        this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public Result append(final Append append) throws IOException {
        if (append.numFamilies() == 0) {
            throw new IOException("Invalid arguments to append, no columns specified");
        }
        NonceGenerator ng = this.connection.getNonceGenerator();
        final long nonceGroup = ng.getNonceGroup();
        final long nonce = ng.newNonce();
        RegionServerCallable<Result> callable = new RegionServerCallable<Result>((HConnection)this.connection, this.getName(), append.getRow()){

            @Override
            public Result call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), append, nonceGroup, nonce);
                    PayloadCarryingRpcController rpcController = HTable.this.rpcControllerFactory.newController();
                    rpcController.setPriority(this.getTableName());
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)rpcController, request);
                    if (!response.hasResult()) {
                        return null;
                    }
                    return ProtobufUtil.toResult(response.getResult(), rpcController.cellScanner());
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public Result increment(final Increment increment) throws IOException {
        if (!increment.hasFamilies()) {
            throw new IOException("Invalid arguments to increment, no columns specified");
        }
        NonceGenerator ng = this.connection.getNonceGenerator();
        final long nonceGroup = ng.getNonceGroup();
        final long nonce = ng.newNonce();
        RegionServerCallable<Result> callable = new RegionServerCallable<Result>((HConnection)this.connection, this.getName(), increment.getRow()){

            @Override
            public Result call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), increment, nonceGroup, nonce);
                    PayloadCarryingRpcController rpcController = HTable.this.rpcControllerFactory.newController();
                    rpcController.setPriority(this.getTableName());
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)rpcController, request);
                    return ProtobufUtil.toResult(response.getResult(), rpcController.cellScanner());
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, Durability.SYNC_WAL);
    }

    @Override
    @Deprecated
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, writeToWAL ? Durability.SKIP_WAL : Durability.USE_DEFAULT);
    }

    @Override
    public long incrementColumnValue(byte[] row, final byte[] family, final byte[] qualifier, final long amount, final Durability durability) throws IOException {
        NullPointerException npe = null;
        if (row == null) {
            npe = new NullPointerException("row is null");
        } else if (family == null) {
            npe = new NullPointerException("family is null");
        } else if (qualifier == null) {
            npe = new NullPointerException("qualifier is null");
        }
        if (npe != null) {
            throw new IOException("Invalid arguments to incrementColumnValue", npe);
        }
        NonceGenerator ng = this.connection.getNonceGenerator();
        final long nonceGroup = ng.getNonceGroup();
        final long nonce = ng.newNonce();
        RegionServerCallable<Long> callable = new RegionServerCallable<Long>((HConnection)this.connection, this.getName(), row){

            @Override
            public Long call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildIncrementRequest(this.getLocation().getRegionInfo().getRegionName(), this.row, family, qualifier, amount, durability, nonceGroup, nonce);
                    PayloadCarryingRpcController rpcController = HTable.this.rpcControllerFactory.newController();
                    rpcController.setPriority(this.getTableName());
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)rpcController, request);
                    Result result = ProtobufUtil.toResult(response.getResult(), rpcController.cellScanner());
                    return Bytes.toLong((byte[])result.getValue(family, qualifier));
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean checkAndPut(byte[] row, final byte[] family, final byte[] qualifier, final byte[] value, final Put put) throws IOException {
        RegionServerCallable<Boolean> callable = new RegionServerCallable<Boolean>((HConnection)this.connection, this.getName(), row){

            @Override
            public Boolean call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), this.row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), HBaseProtos.CompareType.EQUAL, put);
                    PayloadCarryingRpcController rpcController = HTable.this.rpcControllerFactory.newController();
                    rpcController.setPriority(this.getTableName());
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)rpcController, request);
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean checkAndDelete(byte[] row, final byte[] family, final byte[] qualifier, final byte[] value, final Delete delete) throws IOException {
        RegionServerCallable<Boolean> callable = new RegionServerCallable<Boolean>((HConnection)this.connection, this.getName(), row){

            @Override
            public Boolean call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), this.row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), HBaseProtos.CompareType.EQUAL, delete);
                    PayloadCarryingRpcController rpcController = HTable.this.rpcControllerFactory.newController();
                    rpcController.setPriority(this.getTableName());
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)rpcController, request);
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean exists(Get get) throws IOException {
        get.setCheckExistenceOnly(true);
        Result r = this.get(get);
        assert (r.getExists() != null);
        return r.getExists();
    }

    @Override
    public Boolean[] exists(List<Get> gets) throws IOException {
        Object[] r1;
        if (gets.isEmpty()) {
            return new Boolean[0];
        }
        if (gets.size() == 1) {
            return new Boolean[]{this.exists(gets.get(0))};
        }
        for (Get g : gets) {
            g.setCheckExistenceOnly(true);
        }
        try {
            r1 = this.batch(gets);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        Boolean[] results = new Boolean[r1.length];
        int i = 0;
        for (Object o : r1) {
            results[i++] = ((Result)o).getExists();
        }
        return results;
    }

    @Override
    public void flushCommits() throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.backgroundFlushCommits(true);
    }

    public <R> void processBatchCallback(List<? extends Row> list, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.batchCallback(list, results, callback);
    }

    public void processBatch(List<? extends Row> list, Object[] results) throws IOException, InterruptedException {
        this.batch(list, results);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flushCommits();
        if (this.cleanupPoolOnClose) {
            this.pool.shutdown();
            try {
                boolean terminated = false;
                while (!(terminated = this.pool.awaitTermination(60L, TimeUnit.SECONDS))) {
                }
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"waitForTermination interrupted");
            }
        }
        if (this.cleanupConnectionOnClose && this.connection != null) {
            this.connection.close();
        }
        this.closed = true;
    }

    public void validatePut(Put put) throws IllegalArgumentException {
        if (put.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        if (this.maxKeyValueSize > 0) {
            for (List list : put.getFamilyCellMap().values()) {
                for (Cell cell : list) {
                    KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                    if (kv.getLength() <= this.maxKeyValueSize) continue;
                    throw new IllegalArgumentException("KeyValue size too large");
                }
            }
        }
    }

    @Override
    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    @Override
    @Deprecated
    public void setAutoFlush(boolean autoFlush) {
        this.setAutoFlush(autoFlush, autoFlush);
    }

    @Override
    public void setAutoFlushTo(boolean autoFlush) {
        this.setAutoFlush(autoFlush, this.clearBufferOnFail);
    }

    @Override
    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.autoFlush = autoFlush;
        this.clearBufferOnFail = autoFlush || clearBufferOnFail;
    }

    @Override
    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.writeBufferSize = writeBufferSize;
        if (this.currentWriteBufferSize > writeBufferSize) {
            this.flushCommits();
        }
    }

    ExecutorService getPool() {
        return this.pool;
    }

    public static void setRegionCachePrefetch(byte[] tableName, boolean enable) throws IOException {
        HTable.setRegionCachePrefetch(TableName.valueOf((byte[])tableName), enable);
    }

    public static void setRegionCachePrefetch(final TableName tableName, final boolean enable) throws IOException {
        HConnectionManager.execute(new HConnectable<Void>(HBaseConfiguration.create()){

            @Override
            public Void connect(HConnection connection) throws IOException {
                connection.setRegionCachePrefetch(tableName, enable);
                return null;
            }
        });
    }

    public static void setRegionCachePrefetch(Configuration conf, byte[] tableName, boolean enable) throws IOException {
        HTable.setRegionCachePrefetch(conf, TableName.valueOf((byte[])tableName), enable);
    }

    public static void setRegionCachePrefetch(Configuration conf, final TableName tableName, final boolean enable) throws IOException {
        HConnectionManager.execute(new HConnectable<Void>(conf){

            @Override
            public Void connect(HConnection connection) throws IOException {
                connection.setRegionCachePrefetch(tableName, enable);
                return null;
            }
        });
    }

    public static boolean getRegionCachePrefetch(Configuration conf, byte[] tableName) throws IOException {
        return HTable.getRegionCachePrefetch(conf, TableName.valueOf((byte[])tableName));
    }

    public static boolean getRegionCachePrefetch(Configuration conf, final TableName tableName) throws IOException {
        return HConnectionManager.execute(new HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) throws IOException {
                return connection.getRegionCachePrefetch(tableName);
            }
        });
    }

    public static boolean getRegionCachePrefetch(byte[] tableName) throws IOException {
        return HTable.getRegionCachePrefetch(TableName.valueOf((byte[])tableName));
    }

    public static boolean getRegionCachePrefetch(final TableName tableName) throws IOException {
        return HConnectionManager.execute(new HConnectable<Boolean>(HBaseConfiguration.create()){

            @Override
            public Boolean connect(HConnection connection) throws IOException {
                return connection.getRegionCachePrefetch(tableName);
            }
        });
    }

    public void clearRegionCache() {
        this.connection.clearRegionCache();
    }

    @Override
    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return new RegionCoprocessorRpcChannel(this.connection, this.tableName, row, this.rpcCallerFactory, this.rpcControllerFactory);
    }

    @Override
    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        final Map results = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        this.coprocessorService(service, startKey, endKey, callable, new Batch.Callback<R>(){

            @Override
            public void update(byte[] region, byte[] row, R value) {
                if (region != null) {
                    results.put(region, value);
                }
            }
        });
        return results;
    }

    @Override
    public <T extends Service, R> void coprocessorService(final Class<T> service, byte[] startKey, byte[] endKey, final Batch.Call<T, R> callable, final Batch.Callback<R> callback) throws ServiceException, Throwable {
        List<byte[]> keys = this.getStartKeysInRange(startKey, endKey);
        TreeMap futures = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (final byte[] byArray : keys) {
            final RegionCoprocessorRpcChannel channel = new RegionCoprocessorRpcChannel(this.connection, this.tableName, byArray, this.rpcCallerFactory, this.rpcControllerFactory);
            Future future = this.pool.submit(new Callable<R>(){

                @Override
                public R call() throws Exception {
                    Object instance = ProtobufUtil.newServiceStub(service, channel);
                    Object result = callable.call(instance);
                    byte[] region = channel.getLastRegion();
                    if (callback != null) {
                        callback.update(region, byArray, result);
                    }
                    return result;
                }
            });
            futures.put(byArray, future);
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                ((Future)entry.getValue()).get();
            }
            catch (ExecutionException ee) {
                LOG.warn((Object)("Error calling coprocessor service " + service.getName() + " for row " + Bytes.toStringBinary((byte[])((byte[])entry.getKey()))), (Throwable)ee);
                throw ee.getCause();
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted calling coprocessor service " + service.getName() + " for row " + Bytes.toStringBinary((byte[])((byte[])entry.getKey()))).initCause(ie);
            }
        }
    }

    private List<byte[]> getStartKeysInRange(byte[] start, byte[] end) throws IOException {
        if (start == null) {
            start = HConstants.EMPTY_START_ROW;
        }
        if (end == null) {
            end = HConstants.EMPTY_END_ROW;
        }
        return (List)this.getKeysAndRegionsInRange(start, end, true).getFirst();
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public String toString() {
        return this.tableName + ";" + this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        HTable t = new HTable(HBaseConfiguration.create(), args[0]);
        try {
            System.out.println(t.get(new Get(Bytes.toBytes((String)args[1]))));
        }
        finally {
            t.close();
        }
    }

    @Override
    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        final Map results = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        this.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, new Batch.Callback<R>(){

            @Override
            public void update(byte[] region, byte[] row, R result) {
                if (region != null) {
                    results.put(region, result);
                }
            }
        });
        return results;
    }

    @Override
    public <R extends Message> void batchCoprocessorService(final Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, final R responsePrototype, final Batch.Callback<R> callback) throws ServiceException, Throwable {
        Pair<List<byte[]>, List<HRegionLocation>> keysAndRegions = this.getKeysAndRegionsInRange(startKey, endKey, true);
        List keys = (List)keysAndRegions.getFirst();
        List regions = (List)keysAndRegions.getSecond();
        if (keys.isEmpty()) {
            LOG.info((Object)("No regions were selected by key range start=" + Bytes.toStringBinary((byte[])startKey) + ", end=" + Bytes.toStringBinary((byte[])endKey)));
            return;
        }
        ArrayList<RegionCoprocessorServiceExec> execs = new ArrayList<RegionCoprocessorServiceExec>();
        final TreeMap<byte[], RegionCoprocessorServiceExec> execsByRow = new TreeMap<byte[], RegionCoprocessorServiceExec>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < keys.size(); ++i) {
            byte[] rowKey = (byte[])keys.get(i);
            byte[] region = ((HRegionLocation)regions.get(i)).getRegionInfo().getRegionName();
            RegionCoprocessorServiceExec exec = new RegionCoprocessorServiceExec(region, rowKey, methodDescriptor, request);
            execs.add(exec);
            execsByRow.put(rowKey, exec);
        }
        final ArrayList<Throwable> callbackErrorExceptions = new ArrayList<Throwable>();
        final ArrayList<Row> callbackErrorActions = new ArrayList<Row>();
        final ArrayList<String> callbackErrorServers = new ArrayList<String>();
        Object[] results = new Object[execs.size()];
        AsyncProcess asyncProcess = new AsyncProcess(this.connection, this.configuration, this.pool, RpcRetryingCallerFactory.instantiate(this.configuration), true, RpcControllerFactory.instantiate(this.configuration));
        AsyncProcess.AsyncRequestFuture future = asyncProcess.submitAll(this.tableName, execs, new Batch.Callback<ClientProtos.CoprocessorServiceResult>(){

            @Override
            public void update(byte[] region, byte[] row, ClientProtos.CoprocessorServiceResult serviceResult) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Received result for endpoint " + methodDescriptor.getFullName() + ": region=" + Bytes.toStringBinary((byte[])region) + ", row=" + Bytes.toStringBinary((byte[])row) + ", value=" + serviceResult.getValue().getValue()));
                }
                try {
                    callback.update(region, row, responsePrototype.newBuilderForType().mergeFrom(serviceResult.getValue().getValue()).build());
                }
                catch (InvalidProtocolBufferException e) {
                    LOG.error((Object)("Unexpected response type from endpoint " + methodDescriptor.getFullName()), (Throwable)e);
                    callbackErrorExceptions.add(e);
                    callbackErrorActions.add(execsByRow.get(row));
                    callbackErrorServers.add("null");
                }
            }
        }, results);
        future.waitUntilDone();
        if (future.hasError()) {
            throw future.getErrors();
        }
        if (!callbackErrorExceptions.isEmpty()) {
            throw new RetriesExhaustedWithDetailsException(callbackErrorExceptions, callbackErrorActions, callbackErrorServers);
        }
    }
}

