/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.InterruptedIOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultBoundedCompletionService;
import org.apache.hadoop.hbase.client.RpcRetryingCallerWithReadReplicas;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;

@InterfaceAudience.Private
class MetaRpcCallableWithReplicas
extends RpcRetryingCallerWithReadReplicas {
    ExecutorService pool;
    ClusterConnection cConnection;
    RegionLocations metaLocations;
    byte[] metaKey;
    int rpcTimeout;

    public MetaRpcCallableWithReplicas(ExecutorService pool, ClusterConnection cConnection, byte[] metaKey, int rpcTimeout, int retries, int timeBeforeReplicas) {
        super(RpcControllerFactory.instantiate(cConnection.getConfiguration()), TableName.META_TABLE_NAME, cConnection, null, pool, retries, rpcTimeout, timeBeforeReplicas);
        this.metaKey = metaKey;
        this.rpcTimeout = rpcTimeout;
    }

    @Override
    protected byte[] getRowKey() {
        return this.metaKey;
    }

    @Override
    protected void addCallsForReplica(ResultBoundedCompletionService<Result> cs, RegionLocations rl, int min, int max) {
        for (int id = min; id <= max; ++id) {
            HRegionLocation hrl = rl.getRegionLocation(id);
            MetaServerCallable callOnReplica = new MetaServerCallable(id, hrl);
            cs.submit(callOnReplica, this.rpcTimeout, id);
        }
    }

    class MetaServerCallable
    extends RpcRetryingCallerWithReadReplicas.ReplicaRegionServerCallable {
        public MetaServerCallable(int id, HRegionLocation location) {
            super(MetaRpcCallableWithReplicas.this, id, location);
        }

        @Override
        public Result call() throws Exception {
            if (this.controller.isCanceled()) {
                return null;
            }
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            this.controller.setCallTimeout(MetaRpcCallableWithReplicas.this.rpcTimeout);
            return ProtobufUtil.getRowOrBefore(this.getStub(), this.location.getRegionInfo().getRegionName(), MetaRpcCallableWithReplicas.this.metaKey, HConstants.CATALOG_FAMILY, this.controller);
        }
    }
}

