/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.zookeeper.MetaRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.zookeeper.KeeperException;

class ZooKeeperRegistry
implements Registry {
    static final Log LOG = LogFactory.getLog(ZooKeeperRegistry.class);
    ConnectionManager.HConnectionImplementation hci;
    private String clusterId = null;

    ZooKeeperRegistry() {
    }

    @Override
    public void init(HConnection connection) {
        if (!(connection instanceof ConnectionManager.HConnectionImplementation)) {
            throw new RuntimeException("This registry depends on HConnectionImplementation");
        }
        this.hci = (ConnectionManager.HConnectionImplementation)connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionLocations getMetaRegionLocation() throws IOException {
        ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();
        try {
            StringBuffer str;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Looking up meta region location in ZK, connection=" + this));
            }
            List<ServerName> servers = MetaRegionTracker.blockUntilAvailable(zkw, this.hci.rpcTimeout, this.hci.getConfiguration());
            if (LOG.isTraceEnabled()) {
                if (servers == null) {
                    LOG.trace((Object)("Looked up meta region location, connection=" + this + "; servers = null"));
                } else {
                    str = new StringBuffer();
                    for (ServerName s : servers) {
                        str.append(s.toString());
                        str.append(" ");
                    }
                    LOG.trace((Object)("Looked up meta region location, connection=" + this + "; servers = " + str.toString()));
                }
            }
            if (servers == null) {
                str = null;
                return str;
            }
            HRegionLocation[] locs = new HRegionLocation[servers.size()];
            int i = 0;
            for (ServerName server : servers) {
                HRegionInfo h = RegionReplicaUtil.getRegionInfoForReplica(HRegionInfo.FIRST_META_REGIONINFO, i);
                if (server == null) {
                    locs[i++] = null;
                    continue;
                }
                locs[i++] = new HRegionLocation(h, server, 0L);
            }
            RegionLocations regionLocations = new RegionLocations(locs);
            return regionLocations;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            RegionLocations regionLocations = null;
            return regionLocations;
        }
        finally {
            zkw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClusterId() {
        if (this.clusterId != null) {
            return this.clusterId;
        }
        ZooKeeperKeepAliveConnection zkw = null;
        try {
            zkw = this.hci.getKeepAliveZooKeeperWatcher();
            this.clusterId = ZKClusterId.readClusterIdZNode(zkw);
            if (this.clusterId == null) {
                LOG.info((Object)"ClusterId read in ZooKeeper is null");
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Can't retrieve clusterId from Zookeeper", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"Can't retrieve clusterId from Zookeeper", (Throwable)e);
        }
        finally {
            if (zkw != null) {
                zkw.close();
            }
        }
        return this.clusterId;
    }

    @Override
    public boolean isTableOnlineState(TableName tableName, boolean enabled) throws IOException {
        ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();
        try {
            if (enabled) {
                boolean bl = ZKTableReadOnly.isEnabledTable(zkw, tableName);
                return bl;
            }
            boolean bl = ZKTableReadOnly.isDisabledTable(zkw, tableName);
            return bl;
        }
        catch (KeeperException e) {
            throw new IOException("Enable/Disable failed", e);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            zkw.close();
        }
    }

    @Override
    public int getCurrentNrHRS() throws IOException {
        ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();
        try {
            int n = ZKUtil.getNumberOfChildren(zkw, zkw.rsZNode);
            return n;
        }
        catch (KeeperException ke) {
            throw new IOException("Unexpected ZooKeeper exception", ke);
        }
        finally {
            zkw.close();
        }
    }
}

