/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ReplicationAdmin
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ReplicationAdmin.class);
    public static final String TNAME = "tableName";
    public static final String CFNAME = "columnFamlyName";
    public static final String REPLICATIONTYPE = "replicationType";
    public static final String REPLICATIONGLOBAL = Integer.toString(1);
    private final HConnection connection;
    private final ReplicationQueuesClient replicationQueuesClient;
    private final ReplicationPeers replicationPeers;

    public ReplicationAdmin(Configuration conf) throws IOException {
        if (!conf.getBoolean("hbase.replication", true)) {
            throw new RuntimeException("hbase.replication isn't true, please enable it in order to use replication");
        }
        this.connection = HConnectionManager.getConnection(conf);
        ZooKeeperWatcher zkw = this.createZooKeeperWatcher();
        try {
            this.replicationPeers = ReplicationFactory.getReplicationPeers(zkw, conf, this.connection);
            this.replicationPeers.init();
            this.replicationQueuesClient = ReplicationFactory.getReplicationQueuesClient(zkw, conf, this.connection);
            this.replicationQueuesClient.init();
        }
        catch (ReplicationException e) {
            throw new IOException("Error initializing the replication admin client.", e);
        }
    }

    private ZooKeeperWatcher createZooKeeperWatcher() throws IOException {
        return new ZooKeeperWatcher(this.connection.getConfiguration(), "Replication Admin", new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                LOG.error((Object)why, e);
                System.exit(1);
            }

            @Override
            public boolean isAborted() {
                return false;
            }
        });
    }

    @Deprecated
    public void addPeer(String id, String clusterKey) throws ReplicationException {
        this.addPeer(id, new ReplicationPeerConfig().setClusterKey(clusterKey), null);
    }

    @Deprecated
    public void addPeer(String id, String clusterKey, String tableCFs) throws ReplicationException {
        this.replicationPeers.addPeer(id, new ReplicationPeerConfig().setClusterKey(clusterKey), tableCFs);
    }

    public void addPeer(String id, ReplicationPeerConfig peerConfig, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException {
        this.replicationPeers.addPeer(id, peerConfig, ReplicationAdmin.getTableCfsStr(tableCfs));
    }

    @VisibleForTesting
    static String getTableCfsStr(Map<TableName, ? extends Collection<String>> tableCfs) {
        String tableCfsStr = null;
        if (tableCfs != null) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
                if (builder.length() > 0) {
                    builder.append(";");
                }
                builder.append(entry.getKey());
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                builder.append(":");
                builder.append(StringUtils.join(entry.getValue(), (String)","));
            }
            tableCfsStr = builder.toString();
        }
        return tableCfsStr;
    }

    public void removePeer(String id) throws ReplicationException {
        this.replicationPeers.removePeer(id);
    }

    public void enablePeer(String id) throws ReplicationException {
        this.replicationPeers.enablePeer(id);
    }

    public void disablePeer(String id) throws ReplicationException {
        this.replicationPeers.disablePeer(id);
    }

    public int getPeersCount() {
        return this.replicationPeers.getAllPeerIds().size();
    }

    @Deprecated
    public Map<String, String> listPeers() {
        Map<String, ReplicationPeerConfig> peers = this.listPeerConfigs();
        HashMap<String, String> ret = new HashMap<String, String>(peers.size());
        for (Map.Entry<String, ReplicationPeerConfig> entry : peers.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().getClusterKey());
        }
        return ret;
    }

    public Map<String, ReplicationPeerConfig> listPeerConfigs() {
        return this.replicationPeers.getAllPeerConfigs();
    }

    public ReplicationPeerConfig getPeerConfig(String id) throws ReplicationException {
        return this.replicationPeers.getReplicationPeerConfig(id);
    }

    public String getPeerTableCFs(String id) throws ReplicationException {
        return this.replicationPeers.getPeerTableCFsConfig(id);
    }

    @Deprecated
    public void setPeerTableCFs(String id, String tableCFs) throws ReplicationException {
        this.replicationPeers.setPeerTableCFsConfig(id, tableCFs);
    }

    public void setPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException {
        this.replicationPeers.setPeerTableCFsConfig(id, ReplicationAdmin.getTableCfsStr(tableCfs));
    }

    public boolean getPeerState(String id) throws ReplicationException {
        return this.replicationPeers.getStatusOfPeerFromBackingStore(id);
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public List<HashMap<String, String>> listReplicated() throws IOException {
        HTableDescriptor[] tables;
        ArrayList<HashMap<String, String>> replicationColFams = new ArrayList<HashMap<String, String>>();
        for (HTableDescriptor table : tables = this.connection.listTables()) {
            HColumnDescriptor[] columns = table.getColumnFamilies();
            String tableName = table.getNameAsString();
            for (HColumnDescriptor column : columns) {
                if (column.getScope() == 0) continue;
                HashMap<String, String> replicationEntry = new HashMap<String, String>();
                replicationEntry.put(TNAME, tableName);
                replicationEntry.put(CFNAME, column.getNameAsString());
                replicationEntry.put(REPLICATIONTYPE, REPLICATIONGLOBAL);
                replicationColFams.add(replicationEntry);
            }
        }
        return replicationColFams;
    }
}

