/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.ipc.StoppedRpcClientException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.protobuf.generated.TracingProtos;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.HBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SocketInputWrapper;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.cloudera.htrace.Span;
import org.cloudera.htrace.Trace;
import org.cloudera.htrace.TraceScope;

@InterfaceAudience.Private
public class RpcClient {
    public static final Log LOG = LogFactory.getLog(RpcClient.class);
    protected final PoolMap<ConnectionId, Connection> connections;
    protected final AtomicInteger callIdCnt = new AtomicInteger();
    protected final AtomicBoolean running = new AtomicBoolean(true);
    protected final Configuration conf;
    protected final int minIdleTimeBeforeClose;
    protected final int maxRetries;
    protected final long failureSleep;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected final FailedServers failedServers;
    private final Codec codec;
    private final CompressionCodec compressor;
    private final IPCUtil ipcUtil;
    protected final SocketFactory socketFactory;
    protected String clusterId;
    protected final SocketAddress localAddr;
    private final boolean fallbackAllowed;
    private UserProvider userProvider;
    private static final String SOCKET_TIMEOUT = "ipc.socket.timeout";
    static final int DEFAULT_SOCKET_TIMEOUT = 20000;
    static final int PING_CALL_ID = -1;
    public static final String FAILED_SERVER_EXPIRY_KEY = "hbase.ipc.client.failed.servers.expiry";
    public static final int FAILED_SERVER_EXPIRY_DEFAULT = 2000;
    public static final String IDLE_TIME = "hbase.ipc.client.connection.minIdleTimeBeforeClose";
    public static final String IPC_CLIENT_FALLBACK_TO_SIMPLE_AUTH_ALLOWED_KEY = "hbase.ipc.client.fallback-to-simple-auth-allowed";
    public static final boolean IPC_CLIENT_FALLBACK_TO_SIMPLE_AUTH_ALLOWED_DEFAULT = false;
    public static final String SPECIFIC_WRITE_THREAD = "hbase.ipc.client.specificThreadForWriting";
    private static ThreadLocal<Integer> rpcTimeout = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return Integer.MAX_VALUE;
        }
    };
    protected static final Map<AuthenticationProtos.TokenIdentifier.Kind, TokenSelector<? extends TokenIdentifier>> tokenHandlers = new HashMap<AuthenticationProtos.TokenIdentifier.Kind, TokenSelector<? extends TokenIdentifier>>();

    static int getSocketTimeout(Configuration conf) {
        return conf.getInt(SOCKET_TIMEOUT, 20000);
    }

    protected Connection createConnection(ConnectionId remoteId, Codec codec, CompressionCodec compressor) throws IOException {
        return new Connection(remoteId, codec, compressor);
    }

    RpcClient(Configuration conf, String clusterId, SocketFactory factory) {
        this(conf, clusterId, factory, null);
    }

    RpcClient(Configuration conf, String clusterId, SocketFactory factory, SocketAddress localAddr) {
        this.minIdleTimeBeforeClose = conf.getInt(IDLE_TIME, 120000);
        this.maxRetries = conf.getInt("hbase.ipc.client.connect.max.retries", 0);
        this.failureSleep = conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
        this.tcpNoDelay = conf.getBoolean("hbase.ipc.client.tcpnodelay", true);
        this.tcpKeepAlive = conf.getBoolean("hbase.ipc.client.tcpkeepalive", true);
        this.ipcUtil = new IPCUtil(conf);
        this.conf = conf;
        this.codec = this.getCodec();
        this.compressor = RpcClient.getCompressor(conf);
        this.socketFactory = factory;
        this.clusterId = clusterId != null ? clusterId : "default-cluster";
        this.connections = new PoolMap(RpcClient.getPoolType(conf), RpcClient.getPoolSize(conf));
        this.failedServers = new FailedServers(conf);
        this.fallbackAllowed = conf.getBoolean(IPC_CLIENT_FALLBACK_TO_SIMPLE_AUTH_ALLOWED_KEY, false);
        this.localAddr = localAddr;
        this.userProvider = UserProvider.instantiate((Configuration)conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Codec=" + this.codec + ", compressor=" + this.compressor + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpNoDelay=" + this.tcpNoDelay + ", minIdleTimeBeforeClose=" + this.minIdleTimeBeforeClose + ", maxRetries=" + this.maxRetries + ", fallbackAllowed=" + this.fallbackAllowed + ", bind address=" + (this.localAddr != null ? this.localAddr : "null")));
        }
    }

    public RpcClient(Configuration conf, String clusterId) {
        this(conf, clusterId, NetUtils.getDefaultSocketFactory((Configuration)conf), null);
    }

    public RpcClient(Configuration conf, String clusterId, SocketAddress localAddr) {
        this(conf, clusterId, NetUtils.getDefaultSocketFactory((Configuration)conf), localAddr);
    }

    Codec getCodec() {
        String className = this.conf.get("hbase.client.rpc.codec", RpcClient.getDefaultCodec(this.conf));
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            return (Codec)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting codec " + className, e);
        }
    }

    @VisibleForTesting
    public static String getDefaultCodec(Configuration c) {
        return c.get("hbase.client.default.rpc.codec", KeyValueCodec.class.getCanonicalName());
    }

    private static CompressionCodec getCompressor(Configuration conf) {
        String className = conf.get("hbase.client.rpc.compressor", null);
        if (className == null || className.isEmpty()) {
            return null;
        }
        try {
            return (CompressionCodec)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting compressor " + className, e);
        }
    }

    protected static PoolMap.PoolType getPoolType(Configuration config) {
        return PoolMap.PoolType.valueOf(config.get("hbase.client.ipc.pool.type"), PoolMap.PoolType.RoundRobin, PoolMap.PoolType.ThreadLocal);
    }

    protected static int getPoolSize(Configuration config) {
        return config.getInt("hbase.client.ipc.pool.size", 1);
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping rpc client");
        }
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            for (Connection conn : this.connections.values()) {
                conn.interrupt();
            }
        }
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Interrupted while stopping the client. We still have " + this.connections.size() + " connections."));
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    Pair<Message, CellScanner> call(PayloadCarryingRpcController pcrc, Descriptors.MethodDescriptor md, Message param, CellScanner cells, Message returnType, User ticket, InetSocketAddress addr, int rpcTimeout) throws InterruptedException, IOException {
        return this.call(pcrc, md, param, cells, returnType, ticket, addr, rpcTimeout, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<Message, CellScanner> call(PayloadCarryingRpcController pcrc, Descriptors.MethodDescriptor md, Message param, CellScanner cells, Message returnType, User ticket, InetSocketAddress addr, int rpcTimeout, int priority) throws IOException, InterruptedException {
        CallFuture cts;
        Call call = new Call(md, param, cells, returnType);
        final Connection connection = this.getConnection(ticket, call, addr, rpcTimeout, this.codec, this.compressor);
        if (connection.callSender != null) {
            cts = connection.callSender.sendCall(call, priority, Trace.currentSpan());
            if (pcrc != null) {
                pcrc.notifyOnCancel(new RpcCallback<Object>(){

                    public void run(Object parameter) {
                        connection.callSender.remove(cts);
                    }
                });
                if (pcrc.isCanceled()) {
                    call.callComplete();
                    return new Pair((Object)call.response, (Object)call.cells);
                }
            }
        } else {
            cts = null;
            connection.tracedWriteRequest(call, priority, Trace.currentSpan());
        }
        while (!call.done) {
            if (connection.shouldCloseConnection.get()) {
                throw new IOException("Call id=" + call.id + " on server " + addr + " aborted: connection is closing");
            }
            try {
                Call call2 = call;
                synchronized (call2) {
                    if (call.done) {
                        break;
                    }
                    call.wait(1000L);
                }
            }
            catch (InterruptedException e) {
                call.setException(new InterruptedIOException());
                if (cts != null) {
                    connection.callSender.remove(cts);
                }
                throw e;
            }
        }
        if (call.error != null) {
            if (call.error instanceof RemoteException) {
                call.error.fillInStackTrace();
                throw call.error;
            }
            throw this.wrapException(addr, call.error);
        }
        return new Pair((Object)call.response, (Object)call.cells);
    }

    protected IOException wrapException(InetSocketAddress addr, IOException exception) {
        if (exception instanceof ConnectException) {
            return (ConnectException)new ConnectException("Call to " + addr + " failed on connection exception: " + exception).initCause(exception);
        }
        if (exception instanceof SocketTimeoutException) {
            return (SocketTimeoutException)new SocketTimeoutException("Call to " + addr + " failed because " + exception).initCause(exception);
        }
        return (IOException)new IOException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelConnections(String hostname, int port, IOException ioe) {
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            for (Connection connection : this.connections.values()) {
                if (!connection.isAlive() || connection.getRemoteAddress().getPort() != port || !connection.getRemoteAddress().getHostName().equals(hostname)) continue;
                LOG.info((Object)("The server on " + hostname + ":" + port + " is dead - stopping the connection " + connection.remoteId));
                connection.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(User ticket, Call call, InetSocketAddress addr, int rpcTimeout, Codec codec, CompressionCodec compressor) throws IOException {
        Connection connection;
        if (!this.running.get()) {
            throw new StoppedRpcClientException();
        }
        ConnectionId remoteId = new ConnectionId(ticket, call.md.getService().getName(), addr, rpcTimeout);
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            connection = this.connections.get(remoteId);
            if (connection == null) {
                connection = this.createConnection(remoteId, this.codec, this.compressor);
                this.connections.put(remoteId, connection);
            }
        }
        return connection;
    }

    public static void setRpcTimeout(int t) {
        rpcTimeout.set(t);
    }

    public static int getRpcTimeout(int defaultTimeout) {
        return Math.min(defaultTimeout, rpcTimeout.get());
    }

    public static void resetRpcTimeout() {
        rpcTimeout.remove();
    }

    Message callBlockingMethod(Descriptors.MethodDescriptor md, RpcController controller, Message param, Message returnType, User ticket, InetSocketAddress isa, int rpcTimeout) throws ServiceException {
        long startTime = 0L;
        if (LOG.isTraceEnabled()) {
            startTime = EnvironmentEdgeManager.currentTimeMillis();
        }
        PayloadCarryingRpcController pcrc = (PayloadCarryingRpcController)controller;
        CellScanner cells = null;
        if (pcrc != null) {
            cells = pcrc.cellScanner();
            pcrc.setCellScanner(null);
        }
        try {
            Pair<Message, CellScanner> val = this.call(pcrc, md, param, cells, returnType, ticket, isa, rpcTimeout, pcrc != null ? pcrc.getPriority() : 0);
            if (pcrc != null) {
                if (val.getSecond() != null) {
                    pcrc.setCellScanner((CellScanner)val.getSecond());
                }
            } else if (val.getSecond() != null) {
                throw new ServiceException("Client dropping data on the floor!");
            }
            if (LOG.isTraceEnabled()) {
                long callTime = EnvironmentEdgeManager.currentTimeMillis() - startTime;
                LOG.trace((Object)("Call: " + md.getName() + ", callTime: " + callTime + "ms"));
            }
            return (Message)val.getFirst();
        }
        catch (Throwable e) {
            throw new ServiceException(e);
        }
    }

    public BlockingRpcChannel createBlockingRpcChannel(ServerName sn, User ticket, int rpcTimeout) {
        return new BlockingRpcChannelImplementation(this, sn, ticket, rpcTimeout);
    }

    static {
        tokenHandlers.put(AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN, new AuthenticationTokenSelector());
    }

    @VisibleForTesting
    public static class BlockingRpcChannelImplementation
    implements BlockingRpcChannel {
        private final InetSocketAddress isa;
        private final RpcClient rpcClient;
        private final int rpcTimeout;
        private final User ticket;

        protected BlockingRpcChannelImplementation(RpcClient rpcClient, ServerName sn, User ticket, int rpcTimeout) {
            this.isa = new InetSocketAddress(sn.getHostname(), sn.getPort());
            this.rpcClient = rpcClient;
            this.rpcTimeout = RpcClient.getRpcTimeout(rpcTimeout);
            this.ticket = ticket;
        }

        public Message callBlockingMethod(Descriptors.MethodDescriptor md, RpcController controller, Message param, Message returnType) throws ServiceException {
            return this.rpcClient.callBlockingMethod(md, controller, param, returnType, this.ticket, this.isa, this.rpcTimeout);
        }
    }

    protected static class ConnectionId {
        final InetSocketAddress address;
        final User ticket;
        final int rpcTimeout;
        private static final int PRIME = 16777619;
        final String serviceName;

        ConnectionId(User ticket, String serviceName, InetSocketAddress address, int rpcTimeout) {
            this.address = address;
            this.ticket = ticket;
            this.rpcTimeout = rpcTimeout;
            this.serviceName = serviceName;
        }

        String getServiceName() {
            return this.serviceName;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        User getTicket() {
            return this.ticket;
        }

        public String toString() {
            return this.address.toString() + "/" + this.serviceName + "/" + this.ticket + "/" + this.rpcTimeout;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionId) {
                ConnectionId id = (ConnectionId)obj;
                return this.address.equals(id.address) && (this.ticket != null && this.ticket.equals((Object)id.ticket) || this.ticket == id.ticket) && this.rpcTimeout == id.rpcTimeout && this.serviceName == id.serviceName;
            }
            return false;
        }

        public int hashCode() {
            int hashcode = this.address.hashCode() + 16777619 * (16777619 * this.serviceName.hashCode() ^ (this.ticket == null ? 0 : this.ticket.hashCode())) ^ this.rpcTimeout;
            return hashcode;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class CallTimeoutException
    extends IOException {
        public CallTimeoutException(String msg) {
            super(msg);
        }
    }

    protected class Connection
    extends Thread {
        private RPCProtos.ConnectionHeader header;
        protected ConnectionId remoteId;
        protected Socket socket = null;
        protected DataInputStream in;
        protected DataOutputStream out;
        private Object outLock = new Object();
        private InetSocketAddress server;
        private String serverPrincipal;
        private AuthMethod authMethod;
        private boolean useSasl;
        private Token<? extends TokenIdentifier> token;
        private HBaseSaslRpcClient saslRpcClient;
        private int reloginMaxBackoff;
        private final Codec codec;
        private final CompressionCodec compressor;
        protected final ConcurrentSkipListMap<Integer, Call> calls = new ConcurrentSkipListMap();
        protected final AtomicBoolean shouldCloseConnection = new AtomicBoolean();
        protected final CallSender callSender;

        Connection(ConnectionId remoteId, Codec codec, CompressionCodec compressor) throws IOException {
            if (remoteId.getAddress().isUnresolved()) {
                throw new UnknownHostException("unknown host: " + remoteId.getAddress().getHostName());
            }
            this.server = remoteId.getAddress();
            this.codec = codec;
            this.compressor = compressor;
            UserGroupInformation ticket = remoteId.getTicket().getUGI();
            SecurityInfo securityInfo = SecurityInfo.getInfo(remoteId.getServiceName());
            this.useSasl = RpcClient.this.userProvider.isHBaseSecurityEnabled();
            if (this.useSasl && securityInfo != null) {
                String serverKey;
                AuthenticationProtos.TokenIdentifier.Kind tokenKind = securityInfo.getTokenKind();
                if (tokenKind != null) {
                    TokenSelector<? extends TokenIdentifier> tokenSelector = tokenHandlers.get(tokenKind);
                    if (tokenSelector != null) {
                        this.token = tokenSelector.selectToken(new Text(RpcClient.this.clusterId), ticket.getTokens());
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No token selector found for type " + tokenKind));
                    }
                }
                if ((serverKey = securityInfo.getServerPrincipal()) == null) {
                    throw new IOException("Can't obtain server Kerberos config key from SecurityInfo");
                }
                this.serverPrincipal = SecurityUtil.getServerPrincipal((String)RpcClient.this.conf.get(serverKey), (String)this.server.getAddress().getCanonicalHostName().toLowerCase());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RPC Server Kerberos principal name for service=" + remoteId.getServiceName() + " is " + this.serverPrincipal));
                }
            }
            this.authMethod = !this.useSasl ? AuthMethod.SIMPLE : (this.token != null ? AuthMethod.DIGEST : AuthMethod.KERBEROS);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Use " + (Object)((Object)this.authMethod) + " authentication for service " + remoteId.serviceName + ", sasl=" + this.useSasl));
            }
            this.reloginMaxBackoff = RpcClient.this.conf.getInt("hbase.security.relogin.maxbackoff", 5000);
            this.remoteId = remoteId;
            RPCProtos.ConnectionHeader.Builder builder = RPCProtos.ConnectionHeader.newBuilder();
            builder.setServiceName(remoteId.getServiceName());
            RPCProtos.UserInformation userInfoPB = this.getUserInfo(ticket);
            if (userInfoPB != null) {
                builder.setUserInfo(userInfoPB);
            }
            if (this.codec != null) {
                builder.setCellBlockCodecClass(this.codec.getClass().getCanonicalName());
            }
            if (this.compressor != null) {
                builder.setCellBlockCompressorClass(this.compressor.getClass().getCanonicalName());
            }
            this.header = builder.build();
            this.setName("IPC Client (" + RpcClient.this.socketFactory.hashCode() + ") connection to " + remoteId.getAddress().toString() + (ticket == null ? " from an unknown user" : " from " + ticket.getUserName()));
            Threads.setLoggingUncaughtExceptionHandler((Thread)this);
            this.setDaemon(true);
            if (RpcClient.this.conf.getBoolean(RpcClient.SPECIFIC_WRITE_THREAD, false)) {
                this.callSender = new CallSender(this.getName(), RpcClient.this.conf);
                this.callSender.start();
            } else {
                this.callSender = null;
            }
        }

        private RPCProtos.UserInformation getUserInfo(UserGroupInformation ugi) {
            if (ugi == null || this.authMethod == AuthMethod.DIGEST) {
                return null;
            }
            RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
            if (this.authMethod == AuthMethod.KERBEROS) {
                userInfoPB.setEffectiveUser(ugi.getUserName());
            } else if (this.authMethod == AuthMethod.SIMPLE) {
                userInfoPB.setEffectiveUser(ugi.getUserName());
                if (ugi.getRealUser() != null) {
                    userInfoPB.setRealUser(ugi.getRealUser().getUserName());
                }
            }
            return userInfoPB.build();
        }

        protected synchronized void setupConnection() throws IOException {
            int ioFailures = 0;
            int timeoutFailures = 0;
            while (true) {
                try {
                    this.socket = RpcClient.this.socketFactory.createSocket();
                    this.socket.setTcpNoDelay(RpcClient.this.tcpNoDelay);
                    this.socket.setKeepAlive(RpcClient.this.tcpKeepAlive);
                    if (RpcClient.this.localAddr != null) {
                        this.socket.bind(RpcClient.this.localAddr);
                    }
                    NetUtils.connect((Socket)this.socket, (SocketAddress)this.remoteId.getAddress(), (int)RpcClient.getSocketTimeout(RpcClient.this.conf));
                    this.socket.setSoTimeout(this.remoteId.rpcTimeout);
                    return;
                }
                catch (SocketTimeoutException toe) {
                    int n = timeoutFailures;
                    timeoutFailures = (short)(timeoutFailures + 1);
                    this.handleConnectionFailure(n, RpcClient.this.maxRetries, toe);
                    continue;
                }
                catch (IOException ie) {
                    int n = ioFailures;
                    ioFailures = (short)(ioFailures + 1);
                    this.handleConnectionFailure(n, RpcClient.this.maxRetries, ie);
                    continue;
                }
                break;
            }
        }

        protected synchronized void closeConnection() {
            if (this.socket == null) {
                return;
            }
            try {
                if (this.socket.getOutputStream() != null) {
                    this.socket.getOutputStream().close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                if (this.socket.getInputStream() != null) {
                    this.socket.getInputStream().close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                if (this.socket.getChannel() != null) {
                    this.socket.getChannel().close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Not able to close a socket", (Throwable)e);
            }
            this.socket = null;
        }

        private void handleConnectionFailure(int curRetries, int maxRetries, IOException ioe) throws IOException {
            this.closeConnection();
            if (curRetries >= maxRetries || ExceptionUtil.isInterrupt((Throwable)ioe)) {
                throw ioe;
            }
            try {
                Thread.sleep(RpcClient.this.failureSleep);
            }
            catch (InterruptedException ie) {
                ExceptionUtil.rethrowIfInterrupt((Throwable)ie);
            }
            LOG.info((Object)("Retrying connect to server: " + this.remoteId.getAddress() + " after sleeping " + RpcClient.this.failureSleep + "ms. Already tried " + curRetries + " time(s)."));
        }

        private void checkIsOpen() throws IOException {
            if (this.shouldCloseConnection.get()) {
                throw new IOException(this.getName() + " is closing");
            }
        }

        protected synchronized boolean waitForWork() throws InterruptedException {
            long waitUntil = EnvironmentEdgeManager.currentTimeMillis() + (long)RpcClient.this.minIdleTimeBeforeClose;
            while (!this.shouldCloseConnection.get() && RpcClient.this.running.get() && EnvironmentEdgeManager.currentTimeMillis() < waitUntil && this.calls.isEmpty()) {
                this.wait(Math.min(RpcClient.this.minIdleTimeBeforeClose, 1000));
            }
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            if (!RpcClient.this.running.get()) {
                this.markClosed(new IOException("stopped with " + this.calls.size() + " pending request(s)"));
                return false;
            }
            if (!this.calls.isEmpty()) {
                return true;
            }
            if (EnvironmentEdgeManager.currentTimeMillis() >= waitUntil) {
                this.markClosed(new IOException("idle connection closed with " + this.calls.size() + " pending request(s)"));
                return false;
            }
            return true;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteId.getAddress();
        }

        @Override
        public void run() {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.getName() + ": starting, connections " + RpcClient.this.connections.size()));
            }
            try {
                while (this.waitForWork()) {
                    this.readResponse();
                }
            }
            catch (InterruptedException t) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(this.getName() + ": interrupted while waiting for call responses"));
                }
                this.markClosed(ExceptionUtil.asInterrupt((Throwable)t));
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": unexpected throwable while waiting for call responses"), t);
                }
                this.markClosed(new IOException("Unexpected throwable while waiting call responses", t));
            }
            this.close();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.getName() + ": stopped, connections " + RpcClient.this.connections.size()));
            }
        }

        private synchronized void disposeSasl() {
            if (this.saslRpcClient != null) {
                try {
                    this.saslRpcClient.dispose();
                    this.saslRpcClient = null;
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error disposing of SASL client", (Throwable)ioe);
                }
            }
        }

        private synchronized boolean shouldAuthenticateOverKrb() throws IOException {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            UserGroupInformation realUser = currentUser.getRealUser();
            return this.authMethod == AuthMethod.KERBEROS && loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals((Object)currentUser) || loginUser.equals((Object)realUser));
        }

        private synchronized boolean setupSaslConnection(InputStream in2, OutputStream out2) throws IOException {
            this.saslRpcClient = new HBaseSaslRpcClient(this.authMethod, this.token, this.serverPrincipal, RpcClient.this.fallbackAllowed, RpcClient.this.conf.get("hbase.rpc.protection", SaslUtil.QualityOfProtection.AUTHENTICATION.name().toLowerCase()));
            return this.saslRpcClient.saslConnect(in2, out2);
        }

        private synchronized void handleSaslConnectionFailure(final int currRetries, final int maxRetries, final Exception ex, final Random rand, UserGroupInformation user) throws IOException, InterruptedException {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, InterruptedException {
                    Connection.this.closeConnection();
                    if (Connection.this.shouldAuthenticateOverKrb()) {
                        if (currRetries < maxRetries) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Exception encountered while connecting to the server : " + ex));
                            }
                            if (UserGroupInformation.isLoginKeytabBased()) {
                                UserGroupInformation.getLoginUser().reloginFromKeytab();
                            } else {
                                UserGroupInformation.getLoginUser().reloginFromTicketCache();
                            }
                            Connection.this.disposeSasl();
                            Thread.sleep(rand.nextInt(Connection.this.reloginMaxBackoff) + 1);
                            return null;
                        }
                        String msg = "Couldn't setup connection for " + UserGroupInformation.getLoginUser().getUserName() + " to " + Connection.this.serverPrincipal;
                        LOG.warn((Object)msg);
                        throw (IOException)new IOException(msg).initCause(ex);
                    }
                    LOG.warn((Object)("Exception encountered while connecting to the server : " + ex));
                    if (ex instanceof RemoteException) {
                        throw (RemoteException)((Object)ex);
                    }
                    if (ex instanceof SaslException) {
                        String msg = "SASL authentication failed. The most likely cause is missing or invalid credentials. Consider 'kinit'.";
                        LOG.fatal((Object)msg, (Throwable)ex);
                        throw new RuntimeException(msg, ex);
                    }
                    throw new IOException(ex);
                }
            });
        }

        protected synchronized void setupIOstreams() throws IOException {
            if (this.socket != null) {
                return;
            }
            if (this.shouldCloseConnection.get()) {
                throw new IOException("This connection is closing");
            }
            if (RpcClient.this.failedServers.isFailedServer(this.remoteId.getAddress())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Not trying to connect to " + this.server + " this server is in the failed servers list"));
                }
                FailedServerException e = new FailedServerException("This server is in the failed servers list: " + this.server);
                this.markClosed((IOException)((Object)e));
                this.close();
                throw e;
            }
            try {
                OutputStream outStream;
                Object inStream;
                block16: {
                    boolean continueSasl;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Connecting to " + this.server));
                    }
                    int numRetries = 0;
                    int MAX_RETRIES = 5;
                    Random rand = null;
                    while (true) {
                        this.setupConnection();
                        inStream = NetUtils.getInputStream((Socket)this.socket);
                        outStream = NetUtils.getOutputStream((Socket)this.socket, (long)this.remoteId.rpcTimeout);
                        this.writeConnectionHeaderPreamble(outStream);
                        if (!this.useSasl) break block16;
                        SocketInputWrapper in2 = inStream;
                        OutputStream out2 = outStream;
                        UserGroupInformation ticket = this.remoteId.getTicket().getUGI();
                        if (this.authMethod == AuthMethod.KERBEROS && ticket != null && ticket.getRealUser() != null) {
                            ticket = ticket.getRealUser();
                        }
                        if (ticket == null) {
                            throw new FatalConnectionException("ticket/user is null");
                        }
                        try {
                            continueSasl = (Boolean)ticket.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>((InputStream)in2, out2){
                                final /* synthetic */ InputStream val$in2;
                                final /* synthetic */ OutputStream val$out2;
                                {
                                    this.val$in2 = inputStream;
                                    this.val$out2 = outputStream;
                                }

                                @Override
                                public Boolean run() throws IOException {
                                    return Connection.this.setupSaslConnection(this.val$in2, this.val$out2);
                                }
                            });
                        }
                        catch (Exception ex) {
                            ExceptionUtil.rethrowIfInterrupt((Throwable)ex);
                            if (rand == null) {
                                rand = new Random();
                            }
                            int n = numRetries;
                            numRetries = (short)(numRetries + 1);
                            this.handleSaslConnectionFailure(n, 5, ex, rand, ticket);
                            continue;
                        }
                        break;
                    }
                    if (continueSasl) {
                        inStream = this.saslRpcClient.getInputStream((InputStream)inStream);
                        outStream = this.saslRpcClient.getOutputStream(outStream);
                    } else {
                        this.authMethod = AuthMethod.SIMPLE;
                        this.useSasl = false;
                    }
                }
                this.in = new DataInputStream(new BufferedInputStream((InputStream)inStream));
                this.out = new DataOutputStream(new BufferedOutputStream(outStream));
                this.writeConnectionHeader();
                this.start();
                return;
            }
            catch (Throwable t) {
                Object e = ExceptionUtil.asInterrupt((Throwable)t);
                if (e == null) {
                    RpcClient.this.failedServers.addToFailedServers(this.remoteId.address);
                    e = t instanceof LinkageError ? new DoNotRetryIOException(t) : (t instanceof IOException ? (IOException)t : new IOException("Could not set up IO Streams to " + this.server, t));
                }
                this.markClosed((IOException)e);
                this.close();
                throw e;
            }
        }

        private void writeConnectionHeaderPreamble(OutputStream outStream) throws IOException {
            int rpcHeaderLen = HConstants.RPC_HEADER.array().length;
            byte[] preamble = new byte[rpcHeaderLen + 2];
            System.arraycopy(HConstants.RPC_HEADER.array(), 0, preamble, 0, rpcHeaderLen);
            preamble[rpcHeaderLen] = 0;
            preamble[rpcHeaderLen + 1] = this.authMethod.code;
            outStream.write(preamble);
            outStream.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void writeConnectionHeader() throws IOException {
            Object object = this.outLock;
            synchronized (object) {
                this.out.writeInt(this.header.getSerializedSize());
                this.header.writeTo((OutputStream)this.out);
                this.out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                LOG.error((Object)(this.getName() + ": the connection is not in the closed state"));
                return;
            }
            Object object = RpcClient.this.connections;
            synchronized (object) {
                RpcClient.this.connections.removeValue(this.remoteId, this);
            }
            object = this.outLock;
            synchronized (object) {
                if (this.out != null) {
                    IOUtils.closeStream((Closeable)this.out);
                    this.out = null;
                }
            }
            IOUtils.closeStream((Closeable)this.in);
            this.in = null;
            this.disposeSasl();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.getName() + ": closing ipc connection to " + this.server));
            }
            this.cleanupCalls();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.getName() + ": ipc connection to " + this.server + " closed"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void tracedWriteRequest(Call call, int priority, Span span) throws IOException {
            TraceScope ts = Trace.continueSpan((Span)span);
            try {
                this.writeRequest(call, priority, span);
            }
            finally {
                ts.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeRequest(Call call, int priority, Span span) throws IOException {
            RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
            builder.setCallId(call.id);
            if (span != null) {
                builder.setTraceInfo(TracingProtos.RPCTInfo.newBuilder().setParentId(span.getSpanId()).setTraceId(span.getTraceId()));
            }
            builder.setMethodName(call.md.getName());
            builder.setRequestParam(call.param != null);
            ByteBuffer cellBlock = RpcClient.this.ipcUtil.buildCellBlock(this.codec, this.compressor, call.cells);
            if (cellBlock != null) {
                RPCProtos.CellBlockMeta.Builder cellBlockBuilder = RPCProtos.CellBlockMeta.newBuilder();
                cellBlockBuilder.setLength(cellBlock.limit());
                builder.setCellBlockMeta(cellBlockBuilder.build());
            }
            if (priority != 0) {
                builder.setPriority(priority);
            }
            RPCProtos.RequestHeader header = builder.build();
            this.setupIOstreams();
            this.checkIsOpen();
            IOException writeException = null;
            Object object = this.outLock;
            synchronized (object) {
                if (Thread.interrupted()) {
                    throw new InterruptedIOException();
                }
                this.calls.put(call.id, call);
                this.checkIsOpen();
                try {
                    IPCUtil.write(this.out, (Message)header, call.param, cellBlock);
                }
                catch (IOException e) {
                    this.shouldCloseConnection.set(true);
                    writeException = e;
                }
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            if (writeException != null) {
                throw writeException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readResponse() {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            Call call = null;
            boolean expectedCall = false;
            try {
                int totalSize = this.in.readInt();
                RPCProtos.ResponseHeader responseHeader = RPCProtos.ResponseHeader.parseDelimitedFrom((InputStream)this.in);
                int id = responseHeader.getCallId();
                call = this.calls.remove(id);
                boolean bl = expectedCall = call != null && !call.done;
                if (!expectedCall) {
                    int readSoFar = IPCUtil.getTotalSizeWhenWrittenDelimited(new Message[]{responseHeader});
                    int whatIsLeftToRead = totalSize - readSoFar;
                    IOUtils.skipFully((InputStream)this.in, (long)whatIsLeftToRead);
                    return;
                }
                if (responseHeader.hasException()) {
                    RPCProtos.ExceptionResponse exceptionResponse = responseHeader.getException();
                    RemoteException re = this.createRemoteException(exceptionResponse);
                    call.setException((IOException)((Object)re));
                    if (this.isFatalConnectionException(exceptionResponse)) {
                        this.markClosed((IOException)((Object)re));
                    }
                } else {
                    Message value = null;
                    if (call.responseDefaultType != null) {
                        Message.Builder builder = call.responseDefaultType.newBuilderForType();
                        builder.mergeDelimitedFrom((InputStream)this.in);
                        value = builder.build();
                    }
                    CellScanner cellBlockScanner = null;
                    if (responseHeader.hasCellBlockMeta()) {
                        int size = responseHeader.getCellBlockMeta().getLength();
                        byte[] cellBlock = new byte[size];
                        IOUtils.readFully((InputStream)this.in, (byte[])cellBlock, (int)0, (int)cellBlock.length);
                        cellBlockScanner = RpcClient.this.ipcUtil.createCellScanner(this.codec, this.compressor, cellBlock);
                    }
                    call.setResponse(value, cellBlockScanner);
                }
            }
            catch (IOException e) {
                if (expectedCall) {
                    call.setException(e);
                }
                if (e instanceof SocketTimeoutException && this.remoteId.rpcTimeout > 0) {
                } else {
                    this.markClosed(e);
                }
            }
            finally {
                this.cleanupCalls(this.remoteId.rpcTimeout);
                if (expectedCall && !call.done) {
                    LOG.warn((Object)("Coding error: code should be true for callId=" + call.id + ", server=" + this.getRemoteAddress() + ", shouldCloseConnection=" + this.shouldCloseConnection.get()));
                }
            }
        }

        private boolean isFatalConnectionException(RPCProtos.ExceptionResponse e) {
            return e.getExceptionClassName().equals(FatalConnectionException.class.getName());
        }

        private RemoteException createRemoteException(RPCProtos.ExceptionResponse e) {
            String innerExceptionClassName = e.getExceptionClassName();
            boolean doNotRetry = e.getDoNotRetry();
            return e.hasHostname() ? new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), e.getHostname(), e.getPort(), doNotRetry) : new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), doNotRetry);
        }

        protected synchronized void markClosed(IOException e) {
            if (e == null) {
                throw new NullPointerException();
            }
            if (this.shouldCloseConnection.compareAndSet(false, true)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(this.getName() + ": marking at should close, reason: " + e.getMessage()), (Throwable)e);
                }
                if (this.callSender != null) {
                    this.callSender.close();
                }
                this.notifyAll();
            }
        }

        protected void cleanupCalls() {
            this.cleanupCalls(-1L);
        }

        protected synchronized void cleanupCalls(long rpcTimeout) {
            if (rpcTimeout == 0L) {
                return;
            }
            Iterator<Map.Entry<Integer, Call>> itor = this.calls.entrySet().iterator();
            while (itor.hasNext()) {
                IOException ie;
                Call c = itor.next().getValue();
                long waitTime = EnvironmentEdgeManager.currentTimeMillis() - c.getStartTime();
                if (rpcTimeout < 0L) {
                    ie = new IOException("Call id=" + c.id + ", waitTime=" + waitTime);
                    c.setException(ie);
                    itor.remove();
                    continue;
                }
                if (waitTime >= rpcTimeout) {
                    ie = new CallTimeoutException("Call id=" + c.id + ", waitTime=" + waitTime + ", rpcTimeout=" + rpcTimeout);
                    c.setException(ie);
                    itor.remove();
                    continue;
                }
                rpcTimeout -= waitTime;
                break;
            }
            if (!this.shouldCloseConnection.get() && this.socket != null && rpcTimeout > 0L) {
                try {
                    this.socket.setSoTimeout((int)rpcTimeout);
                }
                catch (SocketException e) {
                    LOG.warn((Object)"Couldn't change timeout, which may result in longer than expected calls");
                }
            }
        }

        private class CallSender
        extends Thread
        implements Closeable {
            protected final BlockingQueue<CallFuture> callsToWrite;

            public CallFuture sendCall(Call call, int priority, Span span) throws InterruptedException, IOException {
                CallFuture cts = new CallFuture(call, priority, span);
                if (!this.callsToWrite.offer(cts)) {
                    throw new IOException("Can't add the call " + call.id + " to the write queue. callsToWrite.size()=" + this.callsToWrite.size());
                }
                Connection.this.checkIsOpen();
                return cts;
            }

            @Override
            public void close() {
                assert (Connection.this.shouldCloseConnection.get());
                this.callsToWrite.offer(CallFuture.DEATH_PILL);
            }

            CallSender(String name, Configuration conf) {
                int queueSize = conf.getInt("hbase.ipc.client.write.queueSize", 1000);
                this.callsToWrite = new ArrayBlockingQueue<CallFuture>(queueSize);
                this.setDaemon(true);
                this.setName(name + " - writer");
            }

            public void remove(CallFuture cts) {
                this.callsToWrite.remove(cts);
                Connection.this.calls.remove(cts.call.id);
                cts.call.callComplete();
            }

            @Override
            public void run() {
                while (!Connection.this.shouldCloseConnection.get()) {
                    long waitTime;
                    CallFuture cts = null;
                    try {
                        cts = this.callsToWrite.take();
                    }
                    catch (InterruptedException e) {
                        Connection.this.markClosed(new InterruptedIOException());
                    }
                    if (cts == null || cts == CallFuture.DEATH_PILL) {
                        assert (Connection.this.shouldCloseConnection.get());
                        break;
                    }
                    if (cts.call.done) continue;
                    if (Connection.this.remoteId.rpcTimeout > 0 && (waitTime = EnvironmentEdgeManager.currentTimeMillis() - cts.call.getStartTime()) >= (long)Connection.this.remoteId.rpcTimeout) {
                        CallTimeoutException ie = new CallTimeoutException("Call id=" + cts.call.id + ", waitTime=" + waitTime + ", rpcTimetout=" + Connection.this.remoteId.rpcTimeout + ", expired before being sent to the server.");
                        cts.call.setException(ie);
                        continue;
                    }
                    try {
                        Connection.this.tracedWriteRequest(cts.call, cts.priority, cts.span);
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("call write error for call #" + cts.call.id + ", message =" + e.getMessage()));
                        }
                        cts.call.setException(e);
                        Connection.this.markClosed(e);
                    }
                }
                this.cleanup();
            }

            private void cleanup() {
                CallFuture cts;
                assert (Connection.this.shouldCloseConnection.get());
                IOException ie = new IOException("Connection to " + Connection.this.server + " is closing.");
                while ((cts = (CallFuture)this.callsToWrite.poll()) != null) {
                    if (cts.call == null || cts.call.done) continue;
                    cts.call.setException(ie);
                }
            }
        }
    }

    private static class CallFuture {
        final Call call;
        final int priority;
        final Span span;
        static final CallFuture DEATH_PILL = new CallFuture(null, -1, null);

        CallFuture(Call call, int priority, Span span) {
            this.call = call;
            this.priority = priority;
            this.span = span;
        }
    }

    protected class Call {
        final int id;
        final Message param;
        CellScanner cells;
        Message response;
        Message responseDefaultType;
        IOException error;
        volatile boolean done;
        long startTime;
        final Descriptors.MethodDescriptor md;

        protected Call(Descriptors.MethodDescriptor md, Message param, CellScanner cells, Message responseDefaultType) {
            this.param = param;
            this.md = md;
            this.cells = cells;
            this.startTime = EnvironmentEdgeManager.currentTimeMillis();
            this.responseDefaultType = responseDefaultType;
            this.id = RpcClient.this.callIdCnt.getAndIncrement();
        }

        public String toString() {
            return "callId: " + this.id + " methodName: " + this.md.getName() + " param {" + (this.param != null ? ProtobufUtil.getShortTextFormat(this.param) : "") + "}";
        }

        protected synchronized void callComplete() {
            this.done = true;
            this.notify();
        }

        public void setException(IOException error) {
            this.error = error;
            this.callComplete();
        }

        public void setResponse(Message response, CellScanner cells) {
            this.response = response;
            this.cells = cells;
            this.callComplete();
        }

        public long getStartTime() {
            return this.startTime;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class FailedServerException
    extends HBaseIOException {
        public FailedServerException(String s) {
            super(s);
        }
    }

    static class FailedServers {
        private final LinkedList<Pair<Long, String>> failedServers = new LinkedList();
        private final int recheckServersTimeout;

        FailedServers(Configuration conf) {
            this.recheckServersTimeout = conf.getInt(RpcClient.FAILED_SERVER_EXPIRY_KEY, 2000);
        }

        public synchronized void addToFailedServers(InetSocketAddress address) {
            long expiry = EnvironmentEdgeManager.currentTimeMillis() + (long)this.recheckServersTimeout;
            this.failedServers.addFirst((Pair<Long, String>)new Pair((Object)expiry, (Object)address.toString()));
        }

        public synchronized boolean isFailedServer(InetSocketAddress address) {
            if (this.failedServers.isEmpty()) {
                return false;
            }
            String lookup = address.toString();
            long now = EnvironmentEdgeManager.currentTimeMillis();
            Iterator it = this.failedServers.iterator();
            while (it.hasNext()) {
                Pair cur = (Pair)it.next();
                if ((Long)cur.getFirst() < now) {
                    it.remove();
                    continue;
                }
                if (!lookup.equals(cur.getSecond())) continue;
                return true;
            }
            return false;
        }
    }
}

