/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class MetaRegionTracker
extends ZooKeeperNodeTracker {
    final String metaServerZNode;
    final int replicaId;

    public MetaRegionTracker(ZooKeeperWatcher watcher, Abortable abortable, String metaServerZNode, int replicaId) {
        super(watcher, metaServerZNode, abortable);
        this.metaServerZNode = metaServerZNode;
        this.replicaId = replicaId;
    }

    public boolean isLocationAvailable() {
        return super.getData(true) != null;
    }

    public ServerName getMetaRegionLocation() throws InterruptedException {
        try {
            return ServerName.parseFrom(super.getData(true));
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse", (Throwable)e);
            return null;
        }
    }

    public static ServerName getMetaRegionLocation(ZooKeeperWatcher zkw) throws KeeperException {
        return MetaRegionTracker.getMetaRegionLocation(zkw, 0);
    }

    public static ServerName getMetaRegionLocation(ZooKeeperWatcher zkw, int replicaId) throws KeeperException {
        try {
            return ServerName.parseFrom(ZKUtil.getData(zkw, zkw.getZNodeForReplica(replicaId)));
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public ServerName waitMetaRegionLocation(long timeout) throws InterruptedException {
        if (!this.checkIfBaseNodeAvailable()) {
            String errorMsg = "Check the value configured in 'zookeeper.znode.parent'. There could be a mismatch with the one configured in the master.";
            LOG.error((Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        try {
            return ServerName.parseFrom(super.blockUntilAvailable(timeout, true));
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse", (Throwable)e);
            return null;
        }
    }

    public static void setMetaLocation(ZooKeeperWatcher zookeeper, ServerName location) throws KeeperException {
        MetaRegionTracker.setMetaLocation(zookeeper, 0, location);
    }

    public static void setMetaLocation(ZooKeeperWatcher zookeeper, int replicaId, ServerName location) throws KeeperException {
        LOG.info((Object)("Setting replica location for replicaId " + replicaId + " for hbase:meta region location in ZooKeeper as " + location));
        byte[] data = MetaRegionTracker.toByteArray(location);
        try {
            ZKUtil.createAndWatch(zookeeper, zookeeper.getZNodeForReplica(replicaId), data);
        }
        catch (KeeperException.NodeExistsException nee) {
            LOG.debug((Object)("META region location already existed for " + replicaId + ", updated location"));
            ZKUtil.setData(zookeeper, zookeeper.getZNodeForReplica(replicaId), data);
        }
    }

    static byte[] toByteArray(ServerName sn) {
        HBaseProtos.ServerName pbsn = HBaseProtos.ServerName.newBuilder().setHostName(sn.getHostname()).setPort(sn.getPort()).setStartCode(sn.getStartcode()).build();
        ZooKeeperProtos.MetaRegionServer pbrsr = ZooKeeperProtos.MetaRegionServer.newBuilder().setServer(pbsn).setRpcVersion(0).build();
        return ProtobufUtil.prependPBMagic(pbrsr.toByteArray());
    }

    public static void deleteMetaLocation(ZooKeeperWatcher zookeeper) throws KeeperException {
        MetaRegionTracker.deleteMetaLocation(zookeeper, 0);
    }

    public static void deleteMetaLocation(ZooKeeperWatcher zookeeper, int replicaId) throws KeeperException {
        LOG.info((Object)"Unsetting hbase:meta region location in ZooKeeper");
        try {
            ZKUtil.deleteNode(zookeeper, zookeeper.getZNodeForReplica(replicaId));
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public static List<ServerName> blockUntilAvailable(ZooKeeperWatcher zkw, long timeout, Configuration conf) throws InterruptedException {
        int numReplicasConfigured = 1;
        try {
            List<String> metaReplicaNodes = zkw.getMetaReplicaNodes();
            numReplicasConfigured = metaReplicaNodes.size();
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Got ZK exception " + (Object)((Object)e)));
        }
        ArrayList<ServerName> servers = new ArrayList<ServerName>(numReplicasConfigured);
        ServerName server = MetaRegionTracker.blockUntilAvailable(zkw, timeout);
        if (server == null) {
            return null;
        }
        servers.add(server);
        for (int replicaId = 1; replicaId < numReplicasConfigured; ++replicaId) {
            try {
                byte[] data = ZKUtil.getData(zkw, zkw.getZNodeForReplica(replicaId));
                try {
                    servers.add(ServerName.parseFrom(data));
                }
                catch (DeserializationException d) {
                    LOG.warn((Object)"Failed parse", (Throwable)d);
                }
                continue;
            }
            catch (KeeperException e) {
                LOG.warn((Object)("Got ZK exception " + (Object)((Object)e)));
            }
        }
        int serversSize = servers.size();
        if (serversSize != numReplicasConfigured) {
            for (int i = serversSize; i < numReplicasConfigured; ++i) {
                servers.set(i, null);
            }
        }
        return servers;
    }

    public static ServerName blockUntilAvailable(ZooKeeperWatcher zkw, long timeout) throws InterruptedException {
        byte[] data = ZKUtil.blockUntilAvailable(zkw, zkw.getZNodeForReplica(0), timeout);
        if (data == null) {
            return null;
        }
        try {
            return ServerName.parseFrom(data);
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse", (Throwable)e);
            return null;
        }
    }
}

