/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.hdp22.authorization;

import java.net.URLClassLoader;
import java.util.Properties;
import org.pentaho.di.core.auth.AuthenticationConsumerPluginType;
import org.pentaho.di.core.auth.AuthenticationPersistenceManager;
import org.pentaho.di.core.auth.core.AuthenticationManager;
import org.pentaho.di.core.auth.core.AuthenticationPerformer;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.HadoopConfigurationFileSystemManager;
import org.pentaho.hadoop.shim.hdp22.authentication.HadoopNoAuthConsumer;
import org.pentaho.hadoop.shim.hdp22.authentication.PropertyAuthenticationProviderParser;
import org.pentaho.hadoop.shim.hdp22.authorization.HadoopAuthorizationService;
import org.pentaho.hadoop.shim.hdp22.authorization.HasHadoopAuthorizationService;
import org.pentaho.hadoop.shim.hdp22.delegating.DelegatingHadoopShim;
import org.pentaho.hadoop.shim.spi.PentahoHadoopShim;

public class AuthenticatingHadoopShim
extends DelegatingHadoopShim {
    @Override
    public void onLoad(HadoopConfiguration config, HadoopConfigurationFileSystemManager fsm) throws Exception {
        AuthenticationConsumerPluginType.getInstance().registerPlugin((URLClassLoader)this.getClass().getClassLoader(), HadoopNoAuthConsumer.HadoopNoAuthConsumerType.class);
        String activators = config.getConfigProperties().getProperty("activator.classes");
        if (activators != null) {
            activators = activators.trim();
            for (String className : activators.split(",")) {
                if ((className = className.trim()).length() <= 0) continue;
                try {
                    Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    LogChannel.GENERAL.logError(e.getMessage(), (Throwable)e);
                }
            }
        }
        String provider = "NO_AUTH";
        if (config.getConfigProperties().containsKey("authentication.superuser.provider")) {
            provider = config.getConfigProperties().getProperty("authentication.superuser.provider");
        }
        AuthenticationManager manager = AuthenticationPersistenceManager.getAuthenticationManager();
        new PropertyAuthenticationProviderParser(config.getConfigProperties(), manager).process("authentication.provider.list");
        AuthenticationPerformer performer = manager.getAuthenticationPerformer(HadoopAuthorizationService.class, Properties.class, provider);
        if (performer == null) {
            throw new RuntimeException("Unable to find relevant provider for chosen authentication method (id of " + config.getConfigProperties().getProperty("authentication.superuser.provider"));
        }
        HadoopAuthorizationService hadoopAuthorizationService = (HadoopAuthorizationService)performer.perform((Object)config.getConfigProperties());
        if (hadoopAuthorizationService == null) {
            throw new RuntimeException("Unable to get HadoopAuthorizationService for provider " + config.getConfigProperties().getProperty("authentication.superuser.provider"));
        }
        for (PentahoHadoopShim shim : config.getAvailableShims()) {
            if (HasHadoopAuthorizationService.class.isInstance(shim)) {
                ((HasHadoopAuthorizationService)shim).setHadoopAuthorizationService(hadoopAuthorizationService);
                continue;
            }
            throw new Exception("Found shim: " + shim + " that didn't implement " + HasHadoopAuthorizationService.class.getCanonicalName());
        }
        super.onLoad(config, fsm);
    }
}

