/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Image;
import java.net.URL;
import org.pentaho.reporting.engine.classic.core.LocalImageContainer;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class ChartImageContainer
implements URLImageContainer,
LocalImageContainer {
    private String target;
    private Image image;
    private int width;
    private int height;
    private ChartImageKey key;

    public ChartImageContainer(String target, Image image, int width, int height, int row, String keyName) {
        if (target == null) {
            throw new NullPointerException();
        }
        if (image == null) {
            throw new NullPointerException();
        }
        if (keyName == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.image = image;
        this.width = width;
        this.height = height;
        this.key = new ChartImageKey(row, keyName);
    }

    public Object getIdentity() {
        return this.key;
    }

    public Image getImage() {
        return this.image;
    }

    public String getName() {
        return this.getSourceURLString();
    }

    public boolean isIdentifiable() {
        return true;
    }

    public int getImageHeight() {
        return this.height;
    }

    public int getImageWidth() {
        return this.width;
    }

    public float getScaleX() {
        return 1.0f;
    }

    public float getScaleY() {
        return 1.0f;
    }

    public URL getSourceURL() {
        return null;
    }

    public String getSourceURLString() {
        return this.target;
    }

    public boolean isLoadable() {
        return false;
    }

    public ResourceKey getResourceKey() {
        return null;
    }

    private static class ChartImageKey {
        private int row;
        private String expressionName;

        private ChartImageKey(int row, String expressionName) {
            this.row = row;
            this.expressionName = expressionName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChartImageKey that = (ChartImageKey)o;
            if (this.row != that.row) {
                return false;
            }
            return this.expressionName.equals(that.expressionName);
        }

        public int hashCode() {
            int result = this.row;
            result = 29 * result + this.expressionName.hashCode();
            return result;
        }
    }
}

