/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.util.ObjectUtilities;
import org.pentaho.plugin.jfreereport.reportcharts.CategorySetCollectorFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class PivotCategorySetCollectorFunction
extends CategorySetCollectorFunction {
    private static final long serialVersionUID = -1661805548096343053L;
    private ArrayList categoryNames = new ArrayList();
    private String seriesColumnHeader;

    public String getSeriesColumnHeader() {
        return this.seriesColumnHeader;
    }

    public void setSeriesColumnHeader(String seriesColumnHeader) {
        this.seriesColumnHeader = seriesColumnHeader;
    }

    public void setCategoryName(int index, String field) {
        if (this.categoryNames.size() == index) {
            this.categoryNames.add(field);
        } else {
            this.categoryNames.set(index, field);
        }
    }

    public String getCategoryName(int index) {
        return (String)this.categoryNames.get(index);
    }

    public int getCategoryNameCount() {
        return this.categoryNames.size();
    }

    public String[] getCategoryName() {
        return this.categoryNames.toArray(new String[this.categoryNames.size()]);
    }

    public void setCategoryName(String[] fields) {
        this.categoryNames.clear();
        this.categoryNames.addAll(Arrays.asList(fields));
    }

    @Override
    protected void buildDataset() {
        DefaultCategoryDataset dataset = (DefaultCategoryDataset)this.getDatasourceValue();
        Object currentRowHeader = this.getDataRow().get(this.seriesColumnHeader);
        int catCount = this.getCategoryNameCount();
        int seriesNameCount = this.getSeriesNameCount();
        for (int i = 0; i < seriesNameCount; ++i) {
            String seriesName = this.getSeriesName(i);
            if (!ObjectUtilities.equal((Object)seriesName, (Object)currentRowHeader)) continue;
            for (int j = 0; j < catCount; ++j) {
                String newRowHeader = this.getCategoryName(j);
                if (ObjectUtilities.equal((Object)newRowHeader, (Object)this.seriesColumnHeader)) continue;
                Object valueObject = this.getDataRow().get(newRowHeader);
                Number value = valueObject instanceof Number ? (Number)((Number)valueObject) : (Number)null;
                Number existingValue = this.queryExistingValueFromDataSet((CategoryDataset)dataset, (Comparable)((Object)seriesName), (Comparable)((Object)newRowHeader));
                if (existingValue != null) {
                    double val = value != null ? value.doubleValue() : 0.0;
                    value = new Double(val + existingValue.doubleValue());
                    dataset.setValue(value, (Comparable)((Object)seriesName), (Comparable)((Object)newRowHeader));
                    continue;
                }
                dataset.addValue(value, (Comparable)((Object)seriesName), (Comparable)((Object)newRowHeader));
            }
        }
    }

    @Override
    public Expression getInstance() {
        PivotCategorySetCollectorFunction fn = (PivotCategorySetCollectorFunction)super.getInstance();
        fn.categoryNames = (ArrayList)this.categoryNames.clone();
        return fn;
    }
}

