/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileProvider;

public abstract class AbstractOriginatingFileProvider
extends AbstractFileProvider {
    public FileObject findFile(FileObject fileObject, String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName fileName;
        try {
            fileName = this.parseUri(fileObject != null ? fileObject.getName() : null, string);
        }
        catch (FileSystemException fileSystemException) {
            throw new FileSystemException("vfs.provider/invalid-absolute-uri.error", string, (Throwable)fileSystemException);
        }
        return this.findFile(fileName, fileSystemOptions);
    }

    protected FileObject findFile(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName fileName2 = this.getContext().getFileSystemManager().resolveName(fileName, "/");
        FileSystem fileSystem = this.getFileSystem(fileName2, fileSystemOptions);
        return fileSystem.resolveFile(fileName);
    }

    protected synchronized FileSystem getFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileSystem fileSystem = this.findFileSystem(fileName, fileSystemOptions);
        if (fileSystem == null) {
            fileSystem = this.doCreateFileSystem(fileName, fileSystemOptions);
            this.addFileSystem(fileName, fileSystem);
        }
        return fileSystem;
    }

    protected abstract FileSystem doCreateFileSystem(FileName var1, FileSystemOptions var2) throws FileSystemException;
}

