/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ram;

import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.ram.RamFileSystem;

public class RamFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String MAX_SIZE_KEY = "maxsize";
    private static RamFileSystemConfigBuilder singleton = new RamFileSystemConfigBuilder();

    private RamFileSystemConfigBuilder() {
        super("ram.");
    }

    public static RamFileSystemConfigBuilder getInstance() {
        return singleton;
    }

    protected Class getConfigClass() {
        return RamFileSystem.class;
    }

    public int getMaxSize(FileSystemOptions fileSystemOptions) {
        return this.getInteger(fileSystemOptions, MAX_SIZE_KEY, Integer.MAX_VALUE);
    }

    public void setMaxSize(FileSystemOptions fileSystemOptions, int n) {
        this.setParam(fileSystemOptions, MAX_SIZE_KEY, new Integer(n));
    }
}

