/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.util;

import java.lang.ref.WeakReference;
import org.apache.commons.vfs.FileChangeEvent;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;

public class WeakRefFileListener
implements FileListener {
    private final FileSystem fs;
    private final FileName name;
    private final WeakReference listener;

    protected WeakRefFileListener(FileObject fileObject, FileListener fileListener) {
        this.fs = fileObject.getFileSystem();
        this.name = fileObject.getName();
        this.listener = new WeakReference<FileListener>(fileListener);
    }

    public static void installListener(FileObject fileObject, FileListener fileListener) {
        WeakRefFileListener weakRefFileListener = new WeakRefFileListener(fileObject, fileListener);
        fileObject.getFileSystem().addListener(fileObject, new WeakRefFileListener(fileObject, weakRefFileListener));
    }

    protected FileListener getListener() throws Exception {
        FileListener fileListener = (FileListener)this.listener.get();
        if (fileListener == null) {
            FileObject fileObject = this.fs.resolveFile(this.name);
            fileObject.getFileSystem().removeListener(fileObject, this);
        }
        return fileListener;
    }

    public void fileCreated(FileChangeEvent fileChangeEvent) throws Exception {
        FileListener fileListener = this.getListener();
        if (fileListener == null) {
            return;
        }
        fileListener.fileCreated(fileChangeEvent);
    }

    public void fileDeleted(FileChangeEvent fileChangeEvent) throws Exception {
        FileListener fileListener = this.getListener();
        if (fileListener == null) {
            return;
        }
        fileListener.fileDeleted(fileChangeEvent);
    }

    public void fileChanged(FileChangeEvent fileChangeEvent) throws Exception {
        FileListener fileListener = this.getListener();
        if (fileListener == null) {
            return;
        }
        fileListener.fileChanged(fileChangeEvent);
    }
}

