/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.vfs.test;

import java.io.File;
import java.io.IOException;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.vfs.messages.Messages;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class FileChooserTest {
    public static void main(String[] args) {
        FileSystemManager fsManager = null;
        FileObject maybeRootFile = null;
        try {
            fsManager = VFS.getManager();
            if (fsManager instanceof DefaultFileSystemManager) {
                File f = new File(".");
                try {
                    ((DefaultFileSystemManager)fsManager).setBaseFile(f.getCanonicalFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            maybeRootFile = fsManager.resolveFile("file:///c:/");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final FileObject rootFile = maybeRootFile;
        final Shell applicationShell = new Shell(1264);
        applicationShell.setLayout((Layout)new FillLayout());
        applicationShell.setText(Messages.getString("FileChooserTest.application"));
        applicationShell.setSize(640, 400);
        Menu bar = new Menu((Decorations)applicationShell, 2);
        applicationShell.setMenuBar(bar);
        MenuItem fileItem = new MenuItem(bar, 64);
        fileItem.setText(Messages.getString("FileChooserTest.file"));
        fileItem.setAccelerator(262214);
        Menu fileSubMenu = new Menu((Decorations)applicationShell, 4);
        fileItem.setMenu(fileSubMenu);
        MenuItem fileOpenItem = new MenuItem(fileSubMenu, 64);
        fileOpenItem.setText(Messages.getString("FileChooserTest.open"));
        fileOpenItem.setAccelerator(262223);
        final String[] filters = new String[]{"*.*", "*.xml;*.XML;", "*.class", "*.map"};
        final String[] filterNames = new String[]{Messages.getString("FileChooserTest.allFiles"), Messages.getString("FileChooserTest.xmlFiles"), Messages.getString("FileChooserTest.javaFiles"), Messages.getString("FileChooserTest.mapFiles")};
        fileOpenItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                FileObject initialFile = rootFile;
                try {
                    VfsFileChooserDialog fileOpenDialog = new VfsFileChooserDialog(applicationShell, VFS.getManager(), rootFile, initialFile);
                    fileOpenDialog.addVFSUIPanel(FileChooserTest.buildHDFSPanel("HDFS", fileOpenDialog));
                    fileOpenDialog.addVFSUIPanel(FileChooserTest.buildHDFSPanel("S3", fileOpenDialog));
                    fileOpenDialog.addVFSUIPanel(FileChooserTest.buildHDFSPanel("file", fileOpenDialog));
                    FileObject selectedFile = fileOpenDialog.open(applicationShell, null, filters, filterNames, 0);
                    if (selectedFile != null) {
                        System.out.println(Messages.getString("FileChooserTest.selectedFileEquals") + selectedFile.getName());
                    } else {
                        System.out.println(Messages.getString("FileChooserTest.noFileSelected"));
                    }
                }
                catch (FileSystemException ex) {
                    ex.printStackTrace();
                }
            }
        });
        MenuItem saveAsOpenItem = new MenuItem(fileSubMenu, 64);
        saveAsOpenItem.setText(Messages.getString("FileChooserTest.saveAs"));
        saveAsOpenItem.setAccelerator(262209);
        saveAsOpenItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                FileObject initialFile = null;
                try {
                    initialFile = rootFile.resolveFile("/home/mdamour");
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
                try {
                    VfsFileChooserDialog fileOpenDialog = new VfsFileChooserDialog(applicationShell, VFS.getManager(), rootFile, initialFile);
                    FileObject selectedFile = fileOpenDialog.open(applicationShell, Messages.getString("FileChooserTest.untitled"), filters, filterNames, 3);
                    if (selectedFile != null) {
                        System.out.println(Messages.getString("FileChooserTest.selectedFileEquals") + selectedFile.getName());
                    } else {
                        System.out.println(Messages.getString("FileChooserTest.noFileSelected"));
                    }
                }
                catch (FileSystemException ex) {
                    ex.printStackTrace();
                }
            }
        });
        applicationShell.open();
        while (!applicationShell.isDisposed()) {
            if (applicationShell.getDisplay().readAndDispatch()) continue;
            applicationShell.getDisplay().sleep();
        }
    }

    public static CustomVfsUiPanel buildHDFSPanel(String scheme, final VfsFileChooserDialog parent) {
        CustomVfsUiPanel hdfsPanel = new CustomVfsUiPanel(scheme, scheme, parent, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        hdfsPanel.setLayoutData(gridData);
        hdfsPanel.setLayout((Layout)new GridLayout(1, false));
        Label fileNameLabel = new Label((Composite)hdfsPanel, 0);
        fileNameLabel.setText("Some label: " + scheme);
        gridData = new GridData(4, 0x1000000, true, false);
        fileNameLabel.setLayoutData((Object)gridData);
        final Text fileName = new Text((Composite)hdfsPanel, 18436);
        fileName.setText(scheme + "://");
        gridData = new GridData(4, 0x1000000, true, false);
        fileName.setLayoutData((Object)gridData);
        Button connectButton = new Button((Composite)hdfsPanel, 8);
        connectButton.setText("Connect");
        gridData = new GridData(16384, 0x1000000, false, false);
        gridData.widthHint = 90;
        connectButton.setLayoutData((Object)gridData);
        connectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                parent.openFileCombo.setText(fileName.getText());
                parent.resolveVfsBrowser();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return hdfsPanel;
    }
}

