/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.hadoop;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.hadoop.PopupMenuFactory;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TreeSelection;

@ExtensionPoint(id="HadoopPopupMenuExtension", description="Creates popup menus for named clusters", extensionPointId="SpoonPopupMenuExtension")
public class HadoopPopupMenuExtension
implements ExtensionPointInterface {
    private Spoon spoon = Spoon.getInstance();

    public void callExtensionPoint(LogChannelInterface log, Object extension) throws KettleException {
        Tree selectionTree = (Tree)extension;
        this.createNewPopupMenu(selectionTree);
    }

    private void createNewPopupMenu(Tree selectionTree) {
        Menu popupMenu = null;
        PopupMenuFactory factory = PopupMenuFactory.newInstance();
        TreeSelection[] objects = this.spoon.getTreeObjects(selectionTree);
        if (objects.length != 1) {
            return;
        }
        TreeSelection object = objects[0];
        Object selection = object.getSelection();
        if (selection instanceof Class && selection.equals(NamedCluster.class)) {
            popupMenu = factory.createNewPopupMenu(selectionTree);
        } else if (selection instanceof NamedCluster) {
            popupMenu = factory.createMaintPopupMenu(selectionTree, (NamedCluster)selection);
        }
        if (popupMenu != null) {
            ConstUI.displayMenu((Menu)popupMenu, (Control)selectionTree);
        } else {
            selectionTree.setMenu(null);
        }
    }
}

