/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.namedcluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.provider.url.UrlFileName;
import org.apache.commons.vfs.provider.url.UrlFileNameParser;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;

public class NamedClusterManager {
    private static NamedClusterManager instance = new NamedClusterManager();
    private Map<IMetaStore, MetaStoreFactory<NamedCluster>> factoryMap = new HashMap<IMetaStore, MetaStoreFactory<NamedCluster>>();
    private NamedCluster clusterTemplate;

    private NamedClusterManager() {
    }

    public static NamedClusterManager getInstance() {
        return instance;
    }

    private MetaStoreFactory<NamedCluster> getMetaStoreFactory(IMetaStore metastore) {
        if (this.factoryMap.get(metastore) == null) {
            this.factoryMap.put(metastore, (MetaStoreFactory<NamedCluster>)new MetaStoreFactory(NamedCluster.class, metastore, "pentaho"));
        }
        return this.factoryMap.get(metastore);
    }

    public NamedCluster getClusterTemplate() {
        if (this.clusterTemplate == null) {
            this.clusterTemplate = new NamedCluster();
            this.clusterTemplate.setName("");
            this.clusterTemplate.setHdfsHost("localhost");
            this.clusterTemplate.setHdfsPort("8020");
            this.clusterTemplate.setHdfsUsername("user");
            this.clusterTemplate.setHdfsPassword("password");
            this.clusterTemplate.setJobTrackerHost("localhost");
            this.clusterTemplate.setJobTrackerPort("8032");
            this.clusterTemplate.setZooKeeperHost("localhost");
            this.clusterTemplate.setZooKeeperPort("2181");
            this.clusterTemplate.setOozieUrl("http://localhost:8080/oozie");
        }
        return this.clusterTemplate.clone();
    }

    public void setClusterTemplate(NamedCluster clusterTemplate) {
        this.clusterTemplate = clusterTemplate;
    }

    public void create(NamedCluster namedCluster, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        factory.saveElement((Object)namedCluster);
    }

    public NamedCluster read(String clusterName, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        return (NamedCluster)factory.loadElement(clusterName);
    }

    public void update(NamedCluster namedCluster, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        factory.deleteElement(namedCluster.getName());
        factory.saveElement((Object)namedCluster);
    }

    public void delete(String clusterName, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        factory.deleteElement(clusterName);
    }

    public List<NamedCluster> list(IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        return factory.getElements();
    }

    public List<String> listNames(IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        return factory.getElementNames();
    }

    public boolean contains(String clusterName, IMetaStore metastore) throws MetaStoreException {
        if (metastore == null) {
            return false;
        }
        for (String name : this.listNames(metastore)) {
            if (!name.equals(clusterName)) continue;
            return true;
        }
        return false;
    }

    private String generateURL(String scheme, String clusterName, IMetaStore metastore, VariableSpace variableSpace) {
        String clusterURL = null;
        try {
            NamedCluster namedCluster;
            if (!Const.isEmpty((String)scheme) && !Const.isEmpty((String)clusterName) && metastore != null && (namedCluster = this.read(clusterName, metastore)) != null) {
                String ncHostname = null;
                String ncPort = null;
                String ncUsername = null;
                String ncPassword = null;
                if (scheme.equals("hdfs")) {
                    ncHostname = namedCluster.getHdfsHost() != null ? namedCluster.getHdfsHost() : "";
                    ncPort = namedCluster.getHdfsPort() != null ? namedCluster.getHdfsPort() : "";
                    ncUsername = namedCluster.getHdfsUsername() != null ? namedCluster.getHdfsUsername() : "";
                    String string = ncPassword = namedCluster.getHdfsPassword() != null ? namedCluster.getHdfsPassword() : "";
                }
                if (variableSpace != null) {
                    variableSpace.initializeVariablesFrom(namedCluster.getParentVariableSpace());
                    if (StringUtil.isVariable((String)ncHostname)) {
                        String string = ncHostname = variableSpace.getVariable(StringUtil.getVariableName((String)ncHostname)) != null ? variableSpace.environmentSubstitute(ncHostname) : null;
                    }
                    if (StringUtil.isVariable((String)ncPort)) {
                        String string = ncPort = variableSpace.getVariable(StringUtil.getVariableName((String)ncPort)) != null ? variableSpace.environmentSubstitute(ncPort) : null;
                    }
                    if (StringUtil.isVariable(ncUsername)) {
                        String string = ncUsername = variableSpace.getVariable(StringUtil.getVariableName((String)ncUsername)) != null ? variableSpace.environmentSubstitute(ncUsername) : null;
                    }
                    if (StringUtil.isVariable(ncPassword)) {
                        ncPassword = variableSpace.getVariable(StringUtil.getVariableName((String)ncPassword)) != null ? variableSpace.environmentSubstitute(ncPassword) : null;
                    }
                }
                ncHostname = ncHostname != null ? ncHostname.trim() : "";
                ncPort = ncPort != null ? ncPort.trim() : "";
                ncUsername = ncUsername != null ? ncUsername.trim() : "";
                ncPassword = ncPassword != null ? ncPassword.trim() : "";
                UrlFileName file = new UrlFileName(scheme, ncHostname, Integer.parseInt(ncPort), -1, ncUsername, ncPassword, null, null, null);
                clusterURL = file.getURI();
                if (clusterURL.endsWith("/")) {
                    clusterURL = clusterURL.substring(0, clusterURL.lastIndexOf("/"));
                }
            }
        }
        catch (Exception e) {
            clusterURL = null;
        }
        return clusterURL;
    }

    public String processURLsubstitution(String clusterName, String incomingURL, String scheme, IMetaStore metastore, VariableSpace variableSpace) {
        String outgoingURL = null;
        try {
            String clusterURL = this.generateURL(scheme, clusterName, metastore, variableSpace);
            if (clusterURL == null) {
                outgoingURL = incomingURL;
            } else if (incomingURL.equals("/")) {
                outgoingURL = clusterURL;
            } else if (clusterURL != null) {
                String noVariablesURL = incomingURL.replaceAll("[${}]", "/");
                String fullyQualifiedIncomingURL = incomingURL;
                if (!incomingURL.startsWith(scheme)) {
                    fullyQualifiedIncomingURL = clusterURL + incomingURL;
                    noVariablesURL = clusterURL + incomingURL.replaceAll("[${}]", "/");
                }
                UrlFileNameParser parser = new UrlFileNameParser();
                FileName fileName = parser.parseUri(null, null, noVariablesURL);
                String root = fileName.getRootURI();
                String path = fullyQualifiedIncomingURL.substring(root.length() - 1);
                StringBuffer buffer = new StringBuffer();
                buffer.append(clusterURL);
                buffer.append(path);
                outgoingURL = buffer.toString();
            }
        }
        catch (Exception e) {
            outgoingURL = null;
        }
        return outgoingURL;
    }

    public NamedCluster getNamedClusterByName(String namedCluster, IMetaStore metastore) {
        if (metastore == null) {
            return null;
        }
        try {
            List<NamedCluster> namedClusters = this.list(metastore);
            for (NamedCluster nc : namedClusters) {
                if (!nc.getName().equals(namedCluster)) continue;
                return nc;
            }
        }
        catch (MetaStoreException e) {
            return null;
        }
        return null;
    }
}

