/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.hadoopcopyfiles;

import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.job.entries.copyfiles.JobEntryCopyFiles;
import org.pentaho.metastore.api.IMetaStore;

@JobEntry(id="HadoopCopyFilesPlugin", image="HDM.svg", name="HadoopCopyFilesPlugin.Name", description="HadoopCopyFilesPlugin.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", i18nPackageName="org.pentaho.di.job.entries.hadoopcopyfiles", documentationUrl="http://wiki.pentaho.com/display/EAI/Hadoop+Copy+Files")
public class JobEntryHadoopCopyFiles
extends JobEntryCopyFiles {
    public static final String S3_SOURCE_FILE = "S3-SOURCE-FILE-";
    public static final String S3_DEST_FILE = "S3-DEST-FILE-";

    public JobEntryHadoopCopyFiles() {
        this("");
    }

    public JobEntryHadoopCopyFiles(String name) {
        super(name);
    }

    public String loadURL(String url, String ncName, IMetaStore metastore, Map mappings) {
        NamedClusterManager namedClusterManager = NamedClusterManager.getInstance();
        NamedCluster c = namedClusterManager.getNamedClusterByName(ncName, metastore);
        if (c != null && c.isMapr()) {
            if ((url = namedClusterManager.processURLsubstitution(ncName, url, "maprfs", metastore, this.getVariables())) != null && !url.startsWith("maprfs")) {
                url = "maprfs://" + url;
            }
        } else {
            url = namedClusterManager.processURLsubstitution(ncName, url, "hdfs", metastore, this.getVariables());
        }
        if (!Const.isEmpty((String)ncName) && !Const.isEmpty((String)url)) {
            mappings.put(url, ncName);
        }
        return url;
    }
}

