/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.hadoopjobexecutor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.hadoopjobexecutor.JarUtility;
import org.pentaho.di.job.entries.hadoopjobexecutor.NoExitSecurityManager;
import org.pentaho.di.job.entries.hadoopjobexecutor.SecurityManagerStack;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.job.entries.hadoopjobexecutor.UserDefinedItem;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.api.fs.FileSystem;
import org.pentaho.hadoop.shim.api.fs.Path;
import org.pentaho.hadoop.shim.api.mapred.RunningJob;
import org.pentaho.hadoop.shim.api.mapred.TaskCompletionEvent;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.w3c.dom.Node;

@JobEntry(id="HadoopJobExecutorPlugin", image="HDE.svg", name="HadoopJobExecutorPlugin.Name", description="HadoopJobExecutorPlugin.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", i18nPackageName="org.pentaho.di.job.entries.hadoopjobexecutor", documentationUrl="http://wiki.pentaho.com/display/EAI/Hadoop+Job+Executor")
public class JobEntryHadoopJobExecutor
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static SecurityManagerStack smStack = new SecurityManagerStack();
    private static final String DEFAULT_LOGGING_INTERVAL = "60";
    private static Class<?> PKG = JobEntryHadoopJobExecutor.class;
    private JarUtility util = new JarUtility();
    private String hadoopJobName;
    private String jarUrl = "";
    private String driverClass = "";
    private boolean isSimple = true;
    private String cmdLineArgs;
    private String outputKeyClass;
    private String outputValueClass;
    private String mapperClass;
    private String combinerClass;
    private String reducerClass;
    private String inputFormatClass;
    private String outputFormatClass;
    private String clusterName;
    private String hdfsHostname;
    private String hdfsPort;
    private String jobTrackerHostname;
    private String jobTrackerPort;
    private String inputPath;
    private String outputPath;
    private boolean blocking;
    private String loggingInterval;
    private boolean simpleBlocking;
    private String simpleLoggingInterval = this.loggingInterval = "60";
    private String numMapTasks = "1";
    private String numReduceTasks = "1";
    private List<UserDefinedItem> userDefined = new ArrayList<UserDefinedItem>();

    public String getHadoopJobName() {
        return this.hadoopJobName;
    }

    public void setHadoopJobName(String hadoopJobName) {
        this.hadoopJobName = hadoopJobName;
    }

    public String getJarUrl() {
        return this.jarUrl;
    }

    public void setJarUrl(String jarUrl) {
        this.jarUrl = jarUrl;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean isSimple) {
        this.isSimple = isSimple;
    }

    public String getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    public void setCmdLineArgs(String cmdLineArgs) {
        this.cmdLineArgs = cmdLineArgs;
    }

    public String getOutputKeyClass() {
        return this.outputKeyClass;
    }

    public void setOutputKeyClass(String outputKeyClass) {
        this.outputKeyClass = outputKeyClass;
    }

    public String getOutputValueClass() {
        return this.outputValueClass;
    }

    public void setOutputValueClass(String outputValueClass) {
        this.outputValueClass = outputValueClass;
    }

    public String getMapperClass() {
        return this.mapperClass;
    }

    public void setMapperClass(String mapperClass) {
        this.mapperClass = mapperClass;
    }

    public String getCombinerClass() {
        return this.combinerClass;
    }

    public void setCombinerClass(String combinerClass) {
        this.combinerClass = combinerClass;
    }

    public String getReducerClass() {
        return this.reducerClass;
    }

    public void setReducerClass(String reducerClass) {
        this.reducerClass = reducerClass;
    }

    public String getInputFormatClass() {
        return this.inputFormatClass;
    }

    public void setInputFormatClass(String inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
    }

    public String getOutputFormatClass() {
        return this.outputFormatClass;
    }

    public void setOutputFormatClass(String outputFormatClass) {
        this.outputFormatClass = outputFormatClass;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getHdfsHostname() {
        return this.hdfsHostname;
    }

    public void setHdfsHostname(String hdfsHostname) {
        this.hdfsHostname = hdfsHostname;
    }

    public String getHdfsPort() {
        return this.hdfsPort;
    }

    public void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public String getJobTrackerHostname() {
        return this.jobTrackerHostname;
    }

    public void setJobTrackerHostname(String jobTrackerHostname) {
        this.jobTrackerHostname = jobTrackerHostname;
    }

    public String getJobTrackerPort() {
        return this.jobTrackerPort;
    }

    public void setJobTrackerPort(String jobTrackerPort) {
        this.jobTrackerPort = jobTrackerPort;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public String getLoggingInterval() {
        return this.loggingInterval == null ? DEFAULT_LOGGING_INTERVAL : this.loggingInterval;
    }

    public void setLoggingInterval(String loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public List<UserDefinedItem> getUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(List<UserDefinedItem> userDefined) {
        this.userDefined = userDefined;
    }

    public String getNumMapTasks() {
        return this.numMapTasks;
    }

    public void setNumMapTasks(String numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    public String getNumReduceTasks() {
        return this.numReduceTasks;
    }

    public void setNumReduceTasks(String numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    private void restoreSecurityManager(AtomicInteger counter, NoExitSecurityManager nesm) {
        if (counter.decrementAndGet() == 0) {
            smStack.removeSecurityManager(nesm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result execute(final Result result, int arg1) throws KettleException {
        Log4jFileAppender appender;
        block36: {
            result.setNrErrors(0L);
            appender = null;
            String logFileName = "pdi-" + this.getName();
            try {
                appender = LogWriter.createFileAppender((String)logFileName, (boolean)true, (boolean)false);
                LogWriter.getInstance().addAppender((Appender)appender);
                this.log.setLogLevel(this.parentJob.getLogLevel());
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.FailedToOpenLogFile", (String[])new String[]{logFileName, e.toString()}));
                this.logError(Const.getStackTracker((Throwable)e));
            }
            try {
                URL resolvedJarUrl = this.resolveJarUrl(this.jarUrl);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.ResolvedJar", (String[])new String[]{resolvedJarUrl.toExternalForm()}));
                }
                HadoopShim shim = this.getHadoopConfiguration().getHadoopShim();
                if (this.isSimple) {
                    String simpleLoggingIntervalS = this.environmentSubstitute(this.getSimpleLoggingInterval());
                    int simpleLogInt = 60;
                    try {
                        simpleLogInt = Integer.parseInt(simpleLoggingIntervalS, 10);
                    }
                    catch (NumberFormatException e) {
                        this.logError(BaseMessages.getString(PKG, (String)"ErrorParsingLogInterval", (Object[])new Object[]{simpleLoggingIntervalS, simpleLogInt}));
                    }
                    final Class<?> mainClass = this.locateDriverClass(resolvedJarUrl, shim);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.UsingDriverClass", (String[])new String[]{mainClass == null ? "null" : mainClass.getName()}));
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.SimpleMode", (String[])new String[0]));
                    }
                    final AtomicInteger threads = new AtomicInteger(1);
                    final NoExitSecurityManager nesm = new NoExitSecurityManager(System.getSecurityManager());
                    smStack.setSecurityManager(nesm);
                    try {
                        Runnable r = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    try {
                                        JobEntryHadoopJobExecutor.this.executeMainMethod(mainClass);
                                    }
                                    finally {
                                        JobEntryHadoopJobExecutor.this.restoreSecurityManager(threads, nesm);
                                    }
                                }
                                catch (NoExitSecurityManager.NoExitSecurityException ex) {
                                    if (JobEntryHadoopJobExecutor.this.simpleBlocking) {
                                        JobEntryHadoopJobExecutor.this.logExitStatus(result, mainClass, ex);
                                    }
                                }
                                catch (InvocationTargetException ex) {
                                    if (ex.getTargetException() instanceof NoExitSecurityManager.NoExitSecurityException) {
                                        if (JobEntryHadoopJobExecutor.this.simpleBlocking) {
                                            JobEntryHadoopJobExecutor.this.logExitStatus(result, mainClass, (NoExitSecurityManager.NoExitSecurityException)ex.getTargetException());
                                        }
                                    }
                                    throw new RuntimeException(ex);
                                }
                                catch (Exception ex) {
                                    throw new RuntimeException(ex);
                                }
                            }
                        };
                        Thread t = new Thread(r);
                        t.setDaemon(true);
                        t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                            @Override
                            public void uncaughtException(Thread t, Throwable e) {
                                JobEntryHadoopJobExecutor.this.restoreSecurityManager(threads, nesm);
                                if (JobEntryHadoopJobExecutor.this.simpleBlocking) {
                                    JobEntryHadoopJobExecutor.this.logError(BaseMessages.getString(JobEntryHadoopJobExecutor.class, (String)"JobEntryHadoopJobExecutor.ErrorExecutingClass", (String[])new String[]{mainClass.getName()}), e);
                                    result.setResult(false);
                                }
                            }
                        });
                        nesm.addBlockedThread(t);
                        t.start();
                        if (this.simpleBlocking) {
                            do {
                                this.logDetailed(BaseMessages.getString(JobEntryHadoopJobExecutor.class, (String)"JobEntryHadoopJobExecutor.Blocking", (String[])new String[]{mainClass.getName()}));
                                t.join(simpleLogInt * 1000);
                            } while (!this.parentJob.isStopped() && t.isAlive());
                            if (t.isAlive()) {
                                t.interrupt();
                            }
                        }
                        if (this.simpleBlocking) break block36;
                    }
                    catch (Throwable throwable) {
                        if (!this.simpleBlocking) {
                            Runnable threadWatchdog = new Runnable(threads, nesm){
                                final /* synthetic */ AtomicInteger val$threads;
                                final /* synthetic */ NoExitSecurityManager val$nesm;
                                {
                                    this.val$threads = atomicInteger;
                                    this.val$nesm = noExitSecurityManager;
                                }

                                @Override
                                public void run() {
                                    while (this.val$threads.get() > 0) {
                                        try {
                                            Thread.sleep(100L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    JobEntryHadoopJobExecutor.this.restoreSecurityManager(this.val$threads, this.val$nesm);
                                }
                            };
                            Thread watchdog = new Thread(threadWatchdog);
                            watchdog.setDaemon(true);
                            watchdog.start();
                        }
                        throw throwable;
                    }
                    Runnable threadWatchdog = new /* invalid duplicate definition of identical inner class */;
                    Thread watchdog = new Thread(threadWatchdog);
                    watchdog.setDaemon(true);
                    watchdog.start();
                    break block36;
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.AdvancedMode", (String[])new String[0]));
                }
                Configuration conf = shim.createConfiguration();
                FileSystem fs = shim.getFileSystem(conf);
                URL[] urls = new URL[]{resolvedJarUrl};
                URLClassLoader loader = new URLClassLoader(urls, shim.getClass().getClassLoader());
                String hadoopJobNameS = this.environmentSubstitute(this.hadoopJobName);
                conf.setJobName(hadoopJobNameS);
                String outputKeyClassS = this.environmentSubstitute(this.outputKeyClass);
                conf.setOutputKeyClass(loader.loadClass(outputKeyClassS));
                String outputValueClassS = this.environmentSubstitute(this.outputValueClass);
                conf.setOutputValueClass(loader.loadClass(outputValueClassS));
                if (this.mapperClass != null) {
                    String mapperClassS = this.environmentSubstitute(this.mapperClass);
                    Class<?> mapper = loader.loadClass(mapperClassS);
                    conf.setMapperClass(mapper);
                }
                if (this.combinerClass != null) {
                    String combinerClassS = this.environmentSubstitute(this.combinerClass);
                    Class<?> combiner = loader.loadClass(combinerClassS);
                    conf.setCombinerClass(combiner);
                }
                if (this.reducerClass != null) {
                    String reducerClassS = this.environmentSubstitute(this.reducerClass);
                    Class<?> reducer = loader.loadClass(reducerClassS);
                    conf.setReducerClass(reducer);
                }
                if (this.inputFormatClass != null) {
                    String inputFormatClassS = this.environmentSubstitute(this.inputFormatClass);
                    Class<?> inputFormat = loader.loadClass(inputFormatClassS);
                    conf.setInputFormat(inputFormat);
                }
                if (this.outputFormatClass != null) {
                    String outputFormatClassS = this.environmentSubstitute(this.outputFormatClass);
                    Class<?> outputFormat = loader.loadClass(outputFormatClassS);
                    conf.setOutputFormat(outputFormat);
                }
                String hdfsHostnameS = this.environmentSubstitute(this.hdfsHostname);
                String hdfsPortS = this.environmentSubstitute(this.hdfsPort);
                String jobTrackerHostnameS = this.environmentSubstitute(this.jobTrackerHostname);
                String jobTrackerPortS = this.environmentSubstitute(this.jobTrackerPort);
                ArrayList configMessages = new ArrayList();
                shim.configureConnectionInformation(hdfsHostnameS, hdfsPortS, jobTrackerHostnameS, jobTrackerPortS, conf, configMessages);
                for (String m : configMessages) {
                    this.logBasic(m);
                }
                String inputPathS = this.environmentSubstitute(this.inputPath);
                String[] inputPathParts = inputPathS.split(",");
                ArrayList<Path> paths = new ArrayList<Path>();
                for (String path : inputPathParts) {
                    paths.add(fs.asPath(conf.getDefaultFileSystemURL(), path));
                }
                Path[] finalPaths = paths.toArray(new Path[paths.size()]);
                conf.setInputPaths(finalPaths);
                String outputPathS = this.environmentSubstitute(this.outputPath);
                conf.setOutputPath(fs.asPath(conf.getDefaultFileSystemURL(), outputPathS));
                for (UserDefinedItem item : this.userDefined) {
                    if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                    String nameS = this.environmentSubstitute(item.getName());
                    String valueS = this.environmentSubstitute(item.getValue());
                    conf.set(nameS, valueS);
                }
                conf.setJar(this.environmentSubstitute(this.jarUrl));
                String numMapTasksS = this.environmentSubstitute(this.numMapTasks);
                String numReduceTasksS = this.environmentSubstitute(this.numReduceTasks);
                int numM = 1;
                try {
                    numM = Integer.parseInt(numMapTasksS);
                }
                catch (NumberFormatException e) {
                    this.logError("Can't parse number of map tasks '" + numMapTasksS + "'. Setting num" + "map tasks to 1");
                }
                int numR = 1;
                try {
                    numR = Integer.parseInt(numReduceTasksS);
                }
                catch (NumberFormatException e) {
                    this.logError("Can't parse number of reduce tasks '" + numReduceTasksS + "'. Setting num" + "reduce tasks to 1");
                }
                conf.setNumMapTasks(numM);
                conf.setNumReduceTasks(numR);
                RunningJob runningJob = shim.submitJob(conf);
                String loggingIntervalS = this.environmentSubstitute(this.getLoggingInterval());
                int logIntv = 60;
                try {
                    logIntv = Integer.parseInt(loggingIntervalS);
                }
                catch (NumberFormatException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ErrorParsingLogInterval", (Object[])new Object[]{loggingIntervalS, logIntv}));
                }
                if (!this.blocking) break block36;
                try {
                    int taskCompletionEventIndex = 0;
                    while (!this.parentJob.isStopped() && !runningJob.isComplete()) {
                        if (logIntv >= 1) {
                            this.printJobStatus(runningJob);
                            taskCompletionEventIndex = this.logTaskMessages(runningJob, taskCompletionEventIndex);
                            Thread.sleep(logIntv * 1000);
                            continue;
                        }
                        Thread.sleep(60000L);
                    }
                    if (this.parentJob.isStopped() && !runningJob.isComplete()) {
                        runningJob.killJob();
                        result.setResult(false);
                    }
                    this.printJobStatus(runningJob);
                    this.logTaskMessages(runningJob, taskCompletionEventIndex);
                }
                catch (InterruptedException ie) {
                    this.logError(ie.getMessage(), ie);
                }
                result.setResult(runningJob.isSuccessful());
            }
            catch (Throwable t) {
                t.printStackTrace();
                result.setStopped(true);
                result.setNrErrors(1L);
                result.setResult(false);
                this.logError(t.getMessage(), t);
            }
        }
        if (appender != null) {
            LogWriter.getInstance().removeAppender((Appender)appender);
            appender.close();
            ResultFile resultFile = new ResultFile(1, appender.getFile(), this.parentJob.getJobname(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
        }
        return result;
    }

    private Class<?> locateDriverClass(URL resolvedJarUrl, HadoopShim shim) throws IOException, ClassNotFoundException {
        if (Const.isEmpty((String)this.driverClass)) {
            Class<?> mainClass = this.util.getMainClassFromManifest(resolvedJarUrl, shim.getClass().getClassLoader());
            if (mainClass == null) {
                List<Class<?>> mainClasses = this.util.getClassesInJarWithMain(resolvedJarUrl.toExternalForm(), shim.getClass().getClassLoader());
                if (mainClasses.size() == 1) {
                    return mainClasses.get(0);
                }
                if (mainClasses.isEmpty()) {
                    throw new RuntimeException(BaseMessages.getString(PKG, (String)"ErrorDriverClassNotSpecified", (String[])new String[0]));
                }
                throw new RuntimeException(BaseMessages.getString(PKG, (String)"ErrorMultipleDriverClasses", (String[])new String[0]));
            }
            return mainClass;
        }
        return this.util.getClassByName(this.environmentSubstitute(this.getDriverClass()), resolvedJarUrl, shim.getClass().getClassLoader());
    }

    public URL resolveJarUrl(String jarUrl) throws MalformedURLException {
        String jarUrlS = this.environmentSubstitute(jarUrl);
        if (jarUrlS.indexOf("://") == -1) {
            File jarFile = new File(jarUrlS);
            return jarFile.toURI().toURL();
        }
        return new URL(jarUrlS);
    }

    private int logTaskMessages(RunningJob runningJob, int startIndex) throws IOException {
        TaskCompletionEvent[] tcEvents = runningJob.getTaskCompletionEvents(startIndex);
        block5: for (int i = 0; i < tcEvents.length; ++i) {
            String[] diags = runningJob.getTaskDiagnostics(tcEvents[i].getTaskAttemptId());
            StringBuilder diagsOutput = new StringBuilder();
            if (diags != null && diags.length > 0) {
                diagsOutput.append(Const.CR);
                for (String s : diags) {
                    diagsOutput.append(s);
                    diagsOutput.append(Const.CR);
                }
            }
            switch (tcEvents[i].getTaskStatus()) {
                case KILLED: {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.TaskDetails", (Object[])new Object[]{TaskCompletionEvent.Status.KILLED, tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                    continue block5;
                }
                case FAILED: {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.TaskDetails", (Object[])new Object[]{TaskCompletionEvent.Status.FAILED, tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                    continue block5;
                }
                case SUCCEEDED: {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.TaskDetails", (Object[])new Object[]{TaskCompletionEvent.Status.SUCCEEDED, tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                }
            }
        }
        return tcEvents.length;
    }

    private void logExitStatus(Result result, Class<?> mainClass, NoExitSecurityManager.NoExitSecurityException ex) {
        if (ex.getStatus() != 0) {
            result.setStopped(true);
            result.setNrErrors(1L);
            result.setResult(false);
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.FailedToExecuteClass", (Object[])new Object[]{mainClass.getName(), ex.getStatus()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMainMethod(Class<?> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Object[] objectArray;
            Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
            Method mainMethod = clazz.getMethod("main", String[].class);
            String commandLineArgs = this.environmentSubstitute(this.cmdLineArgs);
            if (commandLineArgs != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = commandLineArgs.split(" ");
            } else {
                objectArray = new Object[]{};
            }
            Object[] args = objectArray;
            mainMethod.invoke(null, args);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void printJobStatus(RunningJob runningJob) throws IOException {
        if (this.log.isBasic()) {
            float setupPercent = runningJob.setupProgress() * 100.0f;
            float mapPercent = runningJob.mapProgress() * 100.0f;
            float reducePercent = runningJob.reduceProgress() * 100.0f;
            this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.RunningPercent", (Object[])new Object[]{Float.valueOf(setupPercent), Float.valueOf(mapPercent), Float.valueOf(reducePercent)}));
        }
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        super.loadXML(entrynode, databases, slaveServers);
        this.hadoopJobName = XMLHandler.getTagValue((Node)entrynode, (String)"hadoop_job_name");
        this.isSimple = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"simple"));
        this.jarUrl = XMLHandler.getTagValue((Node)entrynode, (String)"jar_url");
        this.driverClass = XMLHandler.getTagValue((Node)entrynode, (String)"driver_class");
        this.cmdLineArgs = XMLHandler.getTagValue((Node)entrynode, (String)"command_line_args");
        this.simpleBlocking = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"simple_blocking"));
        this.blocking = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"blocking"));
        this.simpleLoggingInterval = XMLHandler.getTagValue((Node)entrynode, (String)"simple_logging_interval");
        this.loggingInterval = XMLHandler.getTagValue((Node)entrynode, (String)"logging_interval");
        this.mapperClass = XMLHandler.getTagValue((Node)entrynode, (String)"mapper_class");
        this.combinerClass = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_class");
        this.reducerClass = XMLHandler.getTagValue((Node)entrynode, (String)"reducer_class");
        this.inputPath = XMLHandler.getTagValue((Node)entrynode, (String)"input_path");
        this.inputFormatClass = XMLHandler.getTagValue((Node)entrynode, (String)"input_format_class");
        this.outputPath = XMLHandler.getTagValue((Node)entrynode, (String)"output_path");
        this.outputKeyClass = XMLHandler.getTagValue((Node)entrynode, (String)"output_key_class");
        this.outputValueClass = XMLHandler.getTagValue((Node)entrynode, (String)"output_value_class");
        this.outputFormatClass = XMLHandler.getTagValue((Node)entrynode, (String)"output_format_class");
        this.loadClusterConfig(null, rep, entrynode);
        this.setRepository(rep);
        this.numMapTasks = XMLHandler.getTagValue((Node)entrynode, (String)"num_map_tasks");
        this.numReduceTasks = XMLHandler.getTagValue((Node)entrynode, (String)"num_reduce_tasks");
        this.userDefined = new ArrayList<UserDefinedItem>();
        Node userDefinedList = XMLHandler.getSubNode((Node)entrynode, (String)"user_defined_list");
        int nrUserDefined = XMLHandler.countNodes((Node)userDefinedList, (String)"user_defined");
        for (int i = 0; i < nrUserDefined; ++i) {
            Node userDefinedNode = XMLHandler.getSubNodeByNr((Node)userDefinedList, (String)"user_defined", (int)i);
            String name = XMLHandler.getTagValue((Node)userDefinedNode, (String)"name");
            String value = XMLHandler.getTagValue((Node)userDefinedNode, (String)"value");
            UserDefinedItem item = new UserDefinedItem();
            item.setName(name);
            item.setValue(value);
            this.userDefined.add(item);
        }
    }

    private void loadClusterConfig(ObjectId id_jobentry, Repository rep, Node entrynode) {
        boolean configLoaded = false;
        try {
            if (entrynode != null) {
                this.setClusterName(XMLHandler.getTagValue((Node)entrynode, (String)"cluster_name"));
            } else if (rep != null) {
                this.setClusterName(rep.getJobEntryAttributeString(id_jobentry, "cluster_name"));
            }
            NamedCluster nc = null;
            if (rep != null && !StringUtils.isEmpty((String)this.getClusterName()) && NamedClusterManager.getInstance().contains(this.getClusterName(), rep.getMetaStore())) {
                nc = NamedClusterManager.getInstance().read(this.getClusterName(), rep.getMetaStore());
            }
            if (nc != null) {
                this.setJobTrackerHostname(nc.getJobTrackerHost());
                this.setJobTrackerPort(nc.getJobTrackerPort());
                this.setHdfsHostname(nc.getHdfsHost());
                this.setHdfsPort(nc.getHdfsPort());
                configLoaded = true;
            }
        }
        catch (Throwable t) {
            this.logDebug(t.getMessage(), new Object[]{t});
        }
        if (!configLoaded) {
            if (entrynode != null) {
                this.setHdfsHostname(XMLHandler.getTagValue((Node)entrynode, (String)"hdfs_hostname"));
                this.setHdfsPort(XMLHandler.getTagValue((Node)entrynode, (String)"hdfs_port"));
                this.setJobTrackerHostname(XMLHandler.getTagValue((Node)entrynode, (String)"job_tracker_hostname"));
                this.setJobTrackerPort(XMLHandler.getTagValue((Node)entrynode, (String)"job_tracker_port"));
            } else if (rep != null) {
                try {
                    this.setHdfsHostname(rep.getJobEntryAttributeString(id_jobentry, "hdfs_hostname"));
                    this.setHdfsPort(rep.getJobEntryAttributeString(id_jobentry, "hdfs_port"));
                    this.setJobTrackerHostname(rep.getJobEntryAttributeString(id_jobentry, "job_tracker_hostname"));
                    this.setJobTrackerPort(rep.getJobEntryAttributeString(id_jobentry, "job_tracker_port"));
                }
                catch (KettleException ke) {
                    this.logError(ke.getMessage(), ke);
                }
            }
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(1024);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_name", (String)this.hadoopJobName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"simple", (boolean)this.isSimple));
        retval.append("      ").append(XMLHandler.addTagValue((String)"jar_url", (String)this.jarUrl));
        retval.append("      ").append(XMLHandler.addTagValue((String)"driver_class", (String)this.driverClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"command_line_args", (String)this.cmdLineArgs));
        retval.append("      ").append(XMLHandler.addTagValue((String)"simple_blocking", (boolean)this.simpleBlocking));
        retval.append("      ").append(XMLHandler.addTagValue((String)"blocking", (boolean)this.blocking));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logging_interval", (String)this.loggingInterval));
        retval.append("      ").append(XMLHandler.addTagValue((String)"simple_logging_interval", (String)this.simpleLoggingInterval));
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_name", (String)this.hadoopJobName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"mapper_class", (String)this.mapperClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_class", (String)this.combinerClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reducer_class", (String)this.reducerClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"input_path", (String)this.inputPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"input_format_class", (String)this.inputFormatClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_path", (String)this.outputPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_key_class", (String)this.outputKeyClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_value_class", (String)this.outputValueClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_format_class", (String)this.outputFormatClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cluster_name", (String)this.clusterName));
        try {
            if (this.rep != null && !StringUtils.isEmpty((String)this.getClusterName()) && NamedClusterManager.getInstance().contains(this.getClusterName(), this.rep.getMetaStore())) {
                NamedCluster nc = NamedClusterManager.getInstance().read(this.getClusterName(), this.rep.getMetaStore());
                this.setJobTrackerHostname(nc.getJobTrackerHost());
                this.setJobTrackerPort(nc.getJobTrackerPort());
                this.setHdfsHostname(nc.getHdfsHost());
                this.setHdfsPort(nc.getHdfsPort());
            }
        }
        catch (MetaStoreException e) {
            this.logDebug(e.getMessage(), new Object[]{e});
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"hdfs_hostname", (String)this.hdfsHostname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"hdfs_port", (String)this.hdfsPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"job_tracker_hostname", (String)this.jobTrackerHostname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"job_tracker_port", (String)this.jobTrackerPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"num_map_tasks", (String)this.numMapTasks));
        retval.append("      ").append(XMLHandler.addTagValue((String)"num_reduce_tasks", (String)this.numReduceTasks));
        retval.append("      <user_defined_list>").append(Const.CR);
        if (this.userDefined != null) {
            for (UserDefinedItem item : this.userDefined) {
                if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                retval.append("        <user_defined>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)item.getName()));
                retval.append("          ").append(XMLHandler.addTagValue((String)"value", (String)item.getValue()));
                retval.append("        </user_defined>").append(Const.CR);
            }
        }
        retval.append("      </user_defined_list>").append(Const.CR);
        return retval.toString();
    }

    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        if (rep != null) {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.setHadoopJobName(rep.getJobEntryAttributeString(id_jobentry, "hadoop_job_name"));
            this.setSimple(rep.getJobEntryAttributeBoolean(id_jobentry, "simple"));
            this.setJarUrl(rep.getJobEntryAttributeString(id_jobentry, "jar_url"));
            this.setDriverClass(rep.getJobEntryAttributeString(id_jobentry, "driver_class"));
            this.setCmdLineArgs(rep.getJobEntryAttributeString(id_jobentry, "command_line_args"));
            this.setSimpleBlocking(rep.getJobEntryAttributeBoolean(id_jobentry, "simple_blocking"));
            this.setBlocking(rep.getJobEntryAttributeBoolean(id_jobentry, "blocking"));
            this.setSimpleLoggingInterval(rep.getJobEntryAttributeString(id_jobentry, "simple_logging_interval"));
            this.setLoggingInterval(rep.getJobEntryAttributeString(id_jobentry, "logging_interval"));
            this.setMapperClass(rep.getJobEntryAttributeString(id_jobentry, "mapper_class"));
            this.setCombinerClass(rep.getJobEntryAttributeString(id_jobentry, "combiner_class"));
            this.setReducerClass(rep.getJobEntryAttributeString(id_jobentry, "reducer_class"));
            this.setInputPath(rep.getJobEntryAttributeString(id_jobentry, "input_path"));
            this.setInputFormatClass(rep.getJobEntryAttributeString(id_jobentry, "input_format_class"));
            this.setOutputPath(rep.getJobEntryAttributeString(id_jobentry, "output_path"));
            this.setOutputKeyClass(rep.getJobEntryAttributeString(id_jobentry, "output_key_class"));
            this.setOutputValueClass(rep.getJobEntryAttributeString(id_jobentry, "output_value_class"));
            this.setOutputFormatClass(rep.getJobEntryAttributeString(id_jobentry, "output_format_class"));
            this.loadClusterConfig(id_jobentry, rep, null);
            this.setRepository(rep);
            this.setNumMapTasks(rep.getJobEntryAttributeString(id_jobentry, "num_map_tasks"));
            this.setNumReduceTasks(rep.getJobEntryAttributeString(id_jobentry, "num_reduce_tasks"));
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "user_defined_name");
            if (argnr > 0) {
                this.userDefined = new ArrayList<UserDefinedItem>();
                UserDefinedItem item = null;
                for (int i = 0; i < argnr; ++i) {
                    item = new UserDefinedItem();
                    item.setName(rep.getJobEntryAttributeString(id_jobentry, i, "user_defined_name"));
                    item.setValue(rep.getJobEntryAttributeString(id_jobentry, i, "user_defined_value"));
                    this.userDefined.add(item);
                }
            }
        } else {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
    }

    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        if (rep != null) {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_name", this.hadoopJobName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "simple", this.isSimple);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "jar_url", this.jarUrl);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "driver_class", this.driverClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "command_line_args", this.cmdLineArgs);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "simple_blocking", this.simpleBlocking);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "blocking", this.blocking);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "simple_logging_interval", this.simpleLoggingInterval);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logging_interval", this.loggingInterval);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_name", this.hadoopJobName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "mapper_class", this.mapperClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_class", this.combinerClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reducer_class", this.reducerClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "input_path", this.inputPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "input_format_class", this.inputFormatClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_path", this.outputPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_key_class", this.outputKeyClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_value_class", this.outputValueClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_format_class", this.outputFormatClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "cluster_name", this.clusterName);
            try {
                if (!StringUtils.isEmpty((String)this.getClusterName()) && NamedClusterManager.getInstance().contains(this.getClusterName(), rep.getMetaStore())) {
                    NamedCluster nc = NamedClusterManager.getInstance().read(this.getClusterName(), rep.getMetaStore());
                    this.setJobTrackerHostname(nc.getJobTrackerHost());
                    this.setJobTrackerPort(nc.getJobTrackerPort());
                    this.setHdfsHostname(nc.getHdfsHost());
                    this.setHdfsPort(nc.getHdfsPort());
                }
            }
            catch (MetaStoreException e) {
                this.logDebug(e.getMessage(), new Object[]{e});
            }
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hdfs_hostname", this.hdfsHostname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hdfs_port", this.hdfsPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "job_tracker_hostname", this.jobTrackerHostname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "job_tracker_port", this.jobTrackerPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "num_map_tasks", this.numMapTasks);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "num_reduce_tasks", this.numReduceTasks);
            if (this.userDefined != null) {
                for (int i = 0; i < this.userDefined.size(); ++i) {
                    UserDefinedItem item = this.userDefined.get(i);
                    if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "user_defined_name", item.getName());
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "user_defined_value", item.getValue());
                }
            }
        } else {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public String getSimpleLoggingInterval() {
        return this.simpleLoggingInterval == null ? DEFAULT_LOGGING_INTERVAL : this.simpleLoggingInterval;
    }

    public void setSimpleLoggingInterval(String simpleLoggingInterval) {
        this.simpleLoggingInterval = simpleLoggingInterval;
    }

    public boolean isSimpleBlocking() {
        return this.simpleBlocking;
    }

    public void setSimpleBlocking(boolean simpleBlocking) {
        this.simpleBlocking = simpleBlocking;
    }

    protected HadoopConfiguration getHadoopConfiguration() throws ConfigurationException {
        return HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration();
    }
}

