/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.oozie;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.AbstractJobEntry;
import org.pentaho.di.job.JobEntryMode;
import org.pentaho.di.job.JobEntryUtils;
import org.pentaho.di.job.PropertyEntry;
import org.pentaho.di.job.entries.oozie.OozieClientFactoryImpl;
import org.pentaho.di.job.entries.oozie.OozieJobExecutorConfig;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.oozie.shim.api.OozieClient;
import org.pentaho.oozie.shim.api.OozieClientException;
import org.pentaho.oozie.shim.api.OozieClientFactory;
import org.pentaho.oozie.shim.api.OozieJob;

@JobEntry(id="OozieJobExecutor", name="Oozie.JobExecutor.PluginName", description="Oozie.JobExecutor.PluginDescription", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", image="oozie-job-executor.svg", i18nPackageName="org.pentaho.di.job.entries.oozie", version="1")
public class OozieJobExecutorJobEntry
extends AbstractJobEntry<OozieJobExecutorConfig>
implements Cloneable,
JobEntryInterface {
    public static final String HTTP_ERROR_CODE_404 = "HTTP error code: 404";
    public static final String USER_NAME = "user.name";
    private OozieClientFactory oozieClientFactory = new OozieClientFactoryImpl();
    private OozieClient oozieClient = null;

    public OozieJobExecutorJobEntry() {
        try {
            this.oozieClientFactory = (OozieClientFactory)HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration().getShim(OozieClientFactory.class);
        }
        catch (ConfigurationException e) {
            this.oozieClientFactory = new OozieClientFactoryImpl();
        }
    }

    @Override
    protected OozieJobExecutorConfig createJobConfig() {
        return new OozieJobExecutorConfig();
    }

    public List<String> getValidationWarnings(OozieJobExecutorConfig config, boolean checkOozieConnection) {
        ArrayList<String> messages = new ArrayList<String>();
        if (StringUtil.isEmpty((String)config.getJobEntryName())) {
            messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Missing.JobName", (String[])new String[0]));
        }
        if (StringUtils.isEmpty((String)this.getEffectiveOozieUrl(config))) {
            messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Missing.Configuration", (String[])new String[0]));
        } else {
            try {
                NamedCluster nc = null;
                if (this.rep != null && !StringUtils.isEmpty((String)((OozieJobExecutorConfig)this.jobConfig).getClusterName()) && NamedClusterManager.getInstance().contains(((OozieJobExecutorConfig)this.jobConfig).getClusterName(), this.rep.getMetaStore())) {
                    nc = NamedClusterManager.getInstance().read(((OozieJobExecutorConfig)this.jobConfig).getClusterName(), this.rep.getMetaStore());
                }
                if (nc == null) {
                    nc = config.getNamedCluster();
                }
                if (!checkOozieConnection) {
                    if (nc == null) {
                        messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Missing.Configuration", (String[])new String[0]));
                    } else if (StringUtils.isEmpty((String)nc.getOozieUrl())) {
                        messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Missing.Oozie.URL", (String[])new String[0]));
                    }
                }
            }
            catch (Throwable t) {
                messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Missing.Oozie.URL", (String[])new String[0]));
            }
        }
        if (checkOozieConnection && !StringUtils.isEmpty((String)this.getEffectiveOozieUrl(config))) {
            try {
                this.oozieClient = this.getOozieClient(config);
                this.oozieClient.getProtocolUrl();
                this.oozieClient.validateWSVersion();
            }
            catch (OozieClientException e) {
                if (e.getErrorCode().equals(HTTP_ERROR_CODE_404) || e.getCause() != null && (e.getCause() instanceof MalformedURLException || e.getCause() instanceof ConnectException)) {
                    messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Invalid.Oozie.URL", (String[])new String[0]));
                }
                messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Incompatible.Oozie.Versions", (String[])new String[]{this.oozieClient.getClientBuildVersion()}));
            }
        }
        if (config.getModeAsEnum() == JobEntryMode.QUICK_SETUP && StringUtil.isEmpty((String)config.getOozieWorkflowConfig())) {
            messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Missing.Workflow.Properties", (String[])new String[0]));
        } else {
            try {
                Properties props = this.getProperties(config);
                if (checkOozieConnection && !this.oozieClient.hasAppPath(props)) {
                    messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.App.Path.Property.Missing", (String[])new String[0]));
                }
            }
            catch (KettleFileException e) {
                messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Workflow.Properties.FileNotFound", (String[])new String[0]));
            }
            catch (IOException e) {
                messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Workflow.Properties.ReadError", (String[])new String[0]));
            }
        }
        boolean pollingIntervalValid = false;
        try {
            long pollingInterval = JobEntryUtils.asLong(config.getBlockingPollingInterval(), this.variables);
            pollingIntervalValid = pollingInterval > 0L;
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!pollingIntervalValid) {
            messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Invalid.PollingInterval", (String[])new String[0]));
        }
        return messages;
    }

    @Override
    public List<String> getValidationWarnings(OozieJobExecutorConfig config) {
        return this.getValidationWarnings(config, true);
    }

    public Properties getPropertiesFromFile(OozieJobExecutorConfig config) throws IOException, KettleFileException {
        return OozieJobExecutorJobEntry.getPropertiesFromFile(config, this.getVariableSpace());
    }

    public static Properties getPropertiesFromFile(OozieJobExecutorConfig config, VariableSpace variableSpace) throws IOException, KettleFileException {
        InputStreamReader reader = new InputStreamReader(KettleVFS.getInputStream((String)variableSpace.environmentSubstitute(config.getOozieWorkflowConfig())));
        Properties jobProps = new Properties();
        jobProps.load(reader);
        return jobProps;
    }

    public Properties getProperties(OozieJobExecutorConfig config) throws KettleFileException, IOException {
        return OozieJobExecutorJobEntry.getProperties(config, this.getVariableSpace());
    }

    public static Properties getProperties(OozieJobExecutorConfig config, VariableSpace variableSpace) throws KettleFileException, IOException {
        Properties jobProps = null;
        if (config.getModeAsEnum() == JobEntryMode.ADVANCED_LIST && config.getWorkflowProperties() != null) {
            jobProps = new Properties();
            for (PropertyEntry propertyEntry : config.getWorkflowProperties()) {
                if (propertyEntry.getKey() == null) continue;
                String value = propertyEntry.getValue() == null ? "" : propertyEntry.getValue();
                jobProps.setProperty(propertyEntry.getKey(), variableSpace.environmentSubstitute(value));
            }
        } else {
            jobProps = OozieJobExecutorJobEntry.getPropertiesFromFile(config, variableSpace);
        }
        return jobProps;
    }

    @Override
    protected Runnable getExecutionRunnable(final Result jobResult) {
        return new Runnable(){

            @Override
            public void run() {
                OozieClient oozieClient = OozieJobExecutorJobEntry.this.getOozieClient();
                try {
                    oozieClient.validateWSVersion();
                }
                catch (OozieClientException e) {
                    OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                    if (e.getErrorCode().equals(OozieJobExecutorJobEntry.HTTP_ERROR_CODE_404) || e.getCause() != null && (e.getCause() instanceof MalformedURLException || e.getCause() instanceof ConnectException)) {
                        OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Invalid.Oozie.URL", (String[])new String[0]), e);
                    }
                    OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Incompatible.Oozie.Versions", (String[])new String[]{oozieClient.getClientBuildVersion()}), e);
                }
                try {
                    Properties jobProps = OozieJobExecutorJobEntry.this.getProperties((OozieJobExecutorConfig)OozieJobExecutorJobEntry.this.jobConfig);
                    if (!jobProps.containsKey(OozieJobExecutorJobEntry.USER_NAME)) {
                        jobProps.setProperty(OozieJobExecutorJobEntry.USER_NAME, OozieJobExecutorJobEntry.this.getVariableSpace().environmentSubstitute("${user.name}"));
                    }
                    OozieJob job = oozieClient.run(jobProps);
                    if (JobEntryUtils.asBoolean(((OozieJobExecutorConfig)OozieJobExecutorJobEntry.this.getJobConfig()).getBlockingExecution(), OozieJobExecutorJobEntry.this.variables)) {
                        while (job.isRunning()) {
                            long interval = JobEntryUtils.asLong(((OozieJobExecutorConfig)OozieJobExecutorJobEntry.this.jobConfig).getBlockingPollingInterval(), OozieJobExecutorJobEntry.this.variables);
                            Thread.sleep(interval);
                        }
                        String logDetail = job.getJobLog();
                        if (job.didSucceed()) {
                            jobResult.setResult(true);
                            OozieJobExecutorJobEntry.this.logDetailed(logDetail);
                        } else {
                            OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                            OozieJobExecutorJobEntry.this.logError(logDetail);
                        }
                    }
                }
                catch (KettleFileException e) {
                    OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                    OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.JobExecutor.ERROR.File.Resolution", (String[])new String[0]), e);
                }
                catch (IOException e) {
                    OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                    OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.JobExecutor.ERROR.Props.Loading", (String[])new String[0]), e);
                }
                catch (OozieClientException e) {
                    OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                    OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.JobExecutor.ERROR.OozieClient", (String[])new String[0]), e);
                }
                catch (InterruptedException e) {
                    OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                    OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.JobExecutor.ERROR.Threading", (String[])new String[0]), e);
                }
            }
        };
    }

    @Override
    protected void handleUncaughtThreadException(Thread t, Throwable e, Result jobResult) {
        this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.JobExecutor.ERROR.Generic", (String[])new String[0]), e);
        this.setJobResultFailed(jobResult);
    }

    public String getEffectiveOozieUrl(OozieJobExecutorConfig config) {
        String oozieUrl = config.getOozieUrl();
        try {
            NamedCluster nc = null;
            nc = this.rep != null && !StringUtils.isEmpty((String)((OozieJobExecutorConfig)this.jobConfig).getClusterName()) && NamedClusterManager.getInstance().contains(((OozieJobExecutorConfig)this.jobConfig).getClusterName(), this.rep.getMetaStore()) ? NamedClusterManager.getInstance().read(((OozieJobExecutorConfig)this.jobConfig).getClusterName(), this.rep.getMetaStore()) : config.getNamedCluster();
            if (nc != null && !StringUtils.isEmpty((String)nc.getOozieUrl())) {
                oozieUrl = nc.getOozieUrl();
            }
        }
        catch (Throwable t) {
            this.logDebug(t.getMessage(), new Object[]{t});
        }
        return oozieUrl;
    }

    public OozieClient getOozieClient() {
        return this.getOozieClient((OozieJobExecutorConfig)this.jobConfig);
    }

    public OozieClient getOozieClient(OozieJobExecutorConfig config) {
        String oozieUrl = this.getEffectiveOozieUrl(config);
        return this.oozieClientFactory.create(this.getVariableSpace().environmentSubstitute(oozieUrl));
    }
}

