/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.sqoop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.logging.KettleLogChannelAppender;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.AbstractJobEntry;
import org.pentaho.di.job.JobEntryMode;
import org.pentaho.di.job.JobEntryUtils;
import org.pentaho.di.job.LoggingProxy;
import org.pentaho.di.job.entries.sqoop.SqoopConfig;
import org.pentaho.di.job.entries.sqoop.SqoopUtils;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.hadoop.shim.spi.SqoopShim;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.w3c.dom.Node;

public abstract class AbstractSqoopJobEntry<S extends SqoopConfig>
extends AbstractJobEntry<S>
implements Cloneable,
JobEntryInterface {
    private Appender sqoopToKettleAppender;
    private LoggingProxy stdErrProxy;
    private String[] LOGS_TO_MONITOR = new String[]{"org.apache.sqoop", "org.apache.hadoop"};
    private Map<String, Level> logLevelCache = new HashMap<String, Level>();

    protected abstract S buildSqoopConfig();

    protected abstract String getToolName();

    public AbstractSqoopJobEntry() {
    }

    protected AbstractSqoopJobEntry(LogChannelInterface logChannelInterface) {
        super(logChannelInterface);
    }

    @Override
    protected final S createJobConfig() {
        S config = this.buildSqoopConfig();
        try {
            HadoopShim shim = this.getActiveHadoopConfiguration().getHadoopShim();
            Configuration hadoopConfig = shim.createConfiguration();
            this.loadNamedCluster(config);
            SqoopUtils.configureConnectionInformation(config, shim, hadoopConfig);
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorLoadingHadoopConnectionInformation", (String[])new String[0]), ex);
        }
        return config;
    }

    @Override
    public void loadXML(Node node, List<DatabaseMeta> databaseMetas, List<SlaveServer> slaveServers, Repository repository) throws KettleXMLException {
        super.loadXML(node, databaseMetas, slaveServers, repository);
        if (((SqoopConfig)this.getJobConfig()).getDatabase() == null) {
            ((SqoopConfig)this.getJobConfig()).copyConnectionInfoToAdvanced();
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        super.loadRep(rep, id_jobentry, databases, slaveServers);
        if (((SqoopConfig)this.getJobConfig()).getDatabase() == null) {
            ((SqoopConfig)this.getJobConfig()).copyConnectionInfoToAdvanced();
        }
    }

    public void attachLoggingAppenders() {
        this.sqoopToKettleAppender = new KettleLogChannelAppender(this.log);
        try {
            Logger sqoopLogger = JobEntryUtils.findLogger(this.LOGS_TO_MONITOR[0]);
            if (sqoopLogger != null) {
                this.stdErrProxy = new LoggingProxy(System.err, sqoopLogger, Level.ERROR);
                System.setErr(this.stdErrProxy);
            }
            JobEntryUtils.attachAppenderTo(this.sqoopToKettleAppender, this.getLogLevel(), this.logLevelCache, this.LOGS_TO_MONITOR);
        }
        catch (Exception ex) {
            this.logMinimal(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorAttachingLogging", (String[])new String[0]));
            this.logDebug(Const.getStackTracker((Throwable)ex));
            try {
                JobEntryUtils.removeAppenderFrom(this.sqoopToKettleAppender, this.logLevelCache, this.LOGS_TO_MONITOR);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sqoopToKettleAppender = null;
        }
    }

    public void removeLoggingAppenders() {
        try {
            if (this.sqoopToKettleAppender != null) {
                JobEntryUtils.removeAppenderFrom(this.sqoopToKettleAppender, this.logLevelCache, this.LOGS_TO_MONITOR);
                this.sqoopToKettleAppender = null;
            }
            if (this.stdErrProxy != null) {
                System.setErr(this.stdErrProxy.getWrappedStream());
                this.stdErrProxy = null;
            }
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorDetachingLogging", (String[])new String[0]));
            this.logError(Const.getStackTracker((Throwable)ex));
        }
    }

    @Override
    public List<String> getValidationWarnings(SqoopConfig config) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (StringUtil.isEmpty((String)config.getConnect())) {
            warnings.add(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ValidationError.Connect.Message", (String[])new String[]{config.getConnect()}));
        }
        try {
            JobEntryUtils.asLong(config.getBlockingPollingInterval(), this.variables);
        }
        catch (NumberFormatException ex) {
            warnings.add(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ValidationError.BlockingPollingInterval.Message", (String[])new String[]{config.getBlockingPollingInterval()}));
        }
        return warnings;
    }

    @Override
    protected void handleUncaughtThreadException(Thread t, Throwable e, Result jobResult) {
        this.logError(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorRunningSqoopTool", (String[])new String[0]), e);
        this.removeLoggingAppenders();
        this.setJobResultFailed(jobResult);
    }

    protected Configuration getHadoopConfiguration(HadoopShim shim) {
        return shim.createConfiguration();
    }

    @Override
    protected Runnable getExecutionRunnable(final Result jobResult) throws KettleException {
        try {
            HadoopConfiguration activeConfig = this.getActiveHadoopConfiguration();
            final HadoopShim hadoopShim = activeConfig.getHadoopShim();
            final SqoopShim sqoopShim = activeConfig.getSqoopShim();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AbstractSqoopJobEntry.this.executeSqoop(hadoopShim, sqoopShim, (SqoopConfig)AbstractSqoopJobEntry.this.getJobConfig(), AbstractSqoopJobEntry.this.getHadoopConfiguration(hadoopShim), jobResult);
                }
            };
            return runnable;
        }
        catch (ConfigurationException ex) {
            throw new KettleException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSqoop(HadoopShim hadoopShim, SqoopShim shim, S config, Configuration hadoopConfig, Result jobResult) {
        System.setProperty("sqoop.throwOnError", "true");
        this.attachLoggingAppenders();
        try {
            this.configure(hadoopShim, config, hadoopConfig);
            List<String> args = SqoopUtils.getCommandLineArgs(config, this.getVariables());
            args.add(0, this.getToolName());
            int result = shim.runTool(args.toArray(new String[args.size()]), hadoopConfig);
            if (result != 0) {
                this.setJobResultFailed(jobResult);
            }
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorRunningSqoopTool", (String[])new String[0]), ex);
            this.setJobResultFailed(jobResult);
        }
        finally {
            this.removeLoggingAppenders();
        }
    }

    public void configure(HadoopShim shim, S sqoopConfig, Configuration conf) throws KettleException {
        this.configureDatabase(sqoopConfig);
        this.configureShim(shim, sqoopConfig, conf);
    }

    public void configureDatabase(S sqoopConfig) throws KettleException {
        DatabaseMeta databaseMeta = this.getParentJob().getJobMeta().findDatabase(((SqoopConfig)sqoopConfig).getDatabase());
        if (((SqoopConfig)sqoopConfig).getModeAsEnum() == JobEntryMode.QUICK_SETUP && databaseMeta != null) {
            ((SqoopConfig)sqoopConfig).setConnectionInfo(databaseMeta.getName(), databaseMeta.getURL(), databaseMeta.getUsername(), databaseMeta.getPassword());
        }
    }

    public void configureShim(HadoopShim shim, S sqoopConfig, Configuration conf) throws KettleException {
        try {
            ArrayList messages = new ArrayList();
            NamedCluster nc = this.loadNamedCluster(sqoopConfig);
            if (nc != null) {
                if (nc.isMapr()) {
                    shim.configureConnectionInformation("", "", "", "", conf, messages);
                } else {
                    shim.configureConnectionInformation(this.environmentSubstitute(nc.getHdfsHost()), this.environmentSubstitute(nc.getHdfsPort()), this.environmentSubstitute(nc.getJobTrackerHost()), this.environmentSubstitute(nc.getJobTrackerPort()), conf, messages);
                }
            } else {
                shim.configureConnectionInformation(this.environmentSubstitute(((SqoopConfig)sqoopConfig).getNamenodeHost()), this.environmentSubstitute(((SqoopConfig)sqoopConfig).getNamenodePort()), this.environmentSubstitute(((SqoopConfig)sqoopConfig).getJobtrackerHost()), this.environmentSubstitute(((SqoopConfig)sqoopConfig).getJobtrackerPort()), conf, messages);
            }
            for (String m : messages) {
                this.logBasic(m);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorConfiguringHadoopEnvironment", (String[])new String[0]), (Throwable)e);
        }
    }

    public boolean isDatabaseSupported(Class<? extends DatabaseInterface> databaseType) {
        return true;
    }

    NamedCluster loadNamedCluster(S config) {
        if (this.rep != null && !Const.isEmpty((String)((SqoopConfig)config).getClusterName())) {
            try {
                ((SqoopConfig)config).setNamedCluster(NamedClusterManager.getInstance().read(((SqoopConfig)config).getClusterName(), this.rep.getMetaStore()));
            }
            catch (MetaStoreException e) {
                this.logError(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorLoadNamedCluster", (String[])new String[]{((SqoopConfig)config).getClusterName()}), e);
            }
        }
        return ((SqoopConfig)config).getNamedCluster();
    }

    protected HadoopConfiguration getActiveHadoopConfiguration() throws ConfigurationException {
        return HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration();
    }
}

