/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.couchdbinput;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.couchdbinput.CouchDbInput;
import org.pentaho.di.trans.steps.couchdbinput.CouchDbInputData;
import org.w3c.dom.Node;

@Step(id="CouchDbInput", image="couchdb-input.svg", name="CouchDbInput.Name", description="CouchDbInput.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", i18nPackageName="org.pentaho.di.trans.steps.couchdbinput")
public class CouchDbInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = CouchDbInputMeta.class;
    private String hostname;
    private String port;
    private String dbName;
    private String designDocument;
    private String viewName;
    private String authenticationUser;
    private String authenticationPassword;

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Object clone() {
        CouchDbInputMeta retval = (CouchDbInputMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.hostname = XMLHandler.getTagValue((Node)stepnode, (String)"hostname");
            this.port = XMLHandler.getTagValue((Node)stepnode, (String)"port");
            this.dbName = XMLHandler.getTagValue((Node)stepnode, (String)"db_name");
            this.designDocument = XMLHandler.getTagValue((Node)stepnode, (String)"design_document");
            this.viewName = XMLHandler.getTagValue((Node)stepnode, (String)"view_name");
            this.authenticationUser = XMLHandler.getTagValue((Node)stepnode, (String)"auth_user");
            this.authenticationPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"auth_password"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"CouchDbInputMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.hostname = "localhost";
        this.port = "5984";
        this.dbName = "db";
        this.viewName = "design-document/view-name";
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta idValueMeta = new ValueMeta("json", 2);
        idValueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)idValueMeta);
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"hostname", (String)this.hostname));
        retval.append("    ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    ").append(XMLHandler.addTagValue((String)"db_name", (String)this.dbName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"design_document", (String)this.designDocument));
        retval.append("    ").append(XMLHandler.addTagValue((String)"view_name", (String)this.viewName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_user", (String)this.authenticationUser));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword)));
        return retval.toString();
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.hostname = rep.getStepAttributeString(id_step, "hostname");
            this.port = rep.getStepAttributeString(id_step, "port");
            this.dbName = rep.getStepAttributeString(id_step, "db_name");
            this.designDocument = rep.getStepAttributeString(id_step, "design_document");
            this.viewName = rep.getStepAttributeString(id_step, "view_name");
            this.authenticationUser = rep.getStepAttributeString(id_step, "auth_user");
            this.authenticationPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "auth_password"));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CouchDbInputMeta.Exception.UnexpectedErrorWhileReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "hostname", this.hostname);
            rep.saveStepAttribute(id_transformation, id_step, "port", this.port);
            rep.saveStepAttribute(id_transformation, id_step, "db_name", this.dbName);
            rep.saveStepAttribute(id_transformation, id_step, "design_document", this.designDocument);
            rep.saveStepAttribute(id_transformation, id_step, "view_name", this.viewName);
            rep.saveStepAttribute(id_transformation, id_step, "auth_user", this.authenticationUser);
            rep.saveStepAttribute(id_transformation, id_step, "auth_password", Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword));
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CouchDbInputMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new CouchDbInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new CouchDbInputData();
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getDesignDocument() {
        return this.designDocument;
    }

    public void setDesignDocument(String designDocument) {
        this.designDocument = designDocument;
    }
}

