/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hadoopfileoutput;

import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="HadoopFileOutputPlugin", image="HDO.svg", name="HadoopFileOutputPlugin.Name", description="HadoopFileOutputPlugin.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", i18nPackageName="org.pentaho.di.trans.steps.hadoopfileoutput")
public class HadoopFileOutputMeta
extends TextFileOutputMeta {
    private static Class<?> PKG = HadoopFileOutputMeta.class;
    private String sourceConfigurationName;
    private static final String SOURCE_CONFIGURATION_NAME = "source_configuration_name";
    private NamedClusterManager namedClusterManager = NamedClusterManager.getInstance();

    public void setDefault() {
        super.setDefault();
        this.setFileName("");
        super.setFileAsCommand(false);
    }

    public void setFileAsCommand(boolean fileAsCommand) {
        throw new RuntimeException(new RuntimeException(BaseMessages.getString(PKG, (String)"HadoopFileOutput.MethodNotSupportedException.Message", (String[])new String[0])));
    }

    public String getSourceConfigurationName() {
        return this.sourceConfigurationName;
    }

    public void setSourceConfigurationName(String ncName) {
        this.sourceConfigurationName = ncName;
    }

    protected String loadSource(Node stepnode, IMetaStore metastore) {
        NamedCluster c;
        String url = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
        this.sourceConfigurationName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)SOURCE_CONFIGURATION_NAME);
        NamedCluster namedCluster = c = metastore == null ? null : this.namedClusterManager.getNamedClusterByName(this.sourceConfigurationName, metastore);
        if (c != null && c.isMapr()) {
            if ((url = this.namedClusterManager.processURLsubstitution(this.sourceConfigurationName, url, "maprfs", metastore, (VariableSpace)new Variables())) != null && !url.startsWith("maprfs")) {
                url = "maprfs://" + url;
            }
        } else if (!url.startsWith("maprfs")) {
            return this.namedClusterManager.processURLsubstitution(this.sourceConfigurationName, url, "hdfs", metastore, (VariableSpace)new Variables());
        }
        return url;
    }

    protected void saveSource(StringBuffer retVal, String fileName) {
        retVal.append("      ").append(XMLHandler.addTagValue((String)"name", (String)fileName));
        retVal.append("      ").append(XMLHandler.addTagValue((String)SOURCE_CONFIGURATION_NAME, (String)this.sourceConfigurationName));
    }

    protected String loadSourceRep(Repository rep, ObjectId id_step) throws KettleException {
        NamedCluster c;
        String url = rep.getStepAttributeString(id_step, "file_name");
        this.sourceConfigurationName = rep.getStepAttributeString(id_step, SOURCE_CONFIGURATION_NAME);
        NamedCluster namedCluster = c = rep.getMetaStore() == null ? null : this.namedClusterManager.getNamedClusterByName(this.sourceConfigurationName, rep.getMetaStore());
        if (c != null && c.isMapr()) {
            if ((url = this.namedClusterManager.processURLsubstitution(this.sourceConfigurationName, url, "maprfs", rep.getMetaStore(), (VariableSpace)new Variables())) != null && !url.startsWith("maprfs")) {
                url = "maprfs://" + url;
            }
        } else if (!url.startsWith("maprfs")) {
            return this.namedClusterManager.processURLsubstitution(this.sourceConfigurationName, url, "hdfs", rep.getMetaStore(), (VariableSpace)new Variables());
        }
        return url;
    }

    protected void saveSourceRep(Repository rep, ObjectId id_transformation, ObjectId id_step, String fileName) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "file_name", fileName);
        rep.saveStepAttribute(id_transformation, id_step, SOURCE_CONFIGURATION_NAME, this.sourceConfigurationName);
    }
}

