/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hbaseoutput;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.hbaseoutput.HBaseOutput;
import org.pentaho.di.trans.steps.hbaseoutput.HBaseOutputData;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.w3c.dom.Node;

@Step(id="HBaseOutput", image="HBO.svg", name="HBaseOutput.Name", description="HBaseOutput.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", i18nPackageName="org.pentaho.di.trans.steps.hbaseoutput")
public class HBaseOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static Class<?> PKG = HBaseOutputMeta.class;
    protected String clusterName;
    protected String m_zookeeperHosts;
    protected String m_zookeeperPort;
    protected String m_coreConfigURL;
    protected String m_defaultConfigURL;
    protected String m_targetTableName;
    protected String m_targetMappingName;
    protected boolean m_disableWriteToWAL;
    protected String m_writeBufferSize;
    protected Mapping m_mapping;

    public void setMapping(Mapping m) {
        this.m_mapping = m;
    }

    public Mapping getMapping() {
        return this.m_mapping;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setZookeeperHosts(String z) {
        this.m_zookeeperHosts = z;
    }

    public String getZookeeperHosts() {
        return this.m_zookeeperHosts;
    }

    public void setZookeeperPort(String port) {
        this.m_zookeeperPort = port;
    }

    public String getZookeeperPort() {
        return this.m_zookeeperPort;
    }

    public void setCoreConfigURL(String coreConfig) {
        this.m_coreConfigURL = coreConfig;
    }

    public String getCoreConfigURL() {
        return this.m_coreConfigURL;
    }

    public void setDefaulConfigURL(String defaultConfig) {
        this.m_defaultConfigURL = defaultConfig;
    }

    public String getDefaultConfigURL() {
        return this.m_defaultConfigURL;
    }

    public void setTargetTableName(String targetTable) {
        this.m_targetTableName = targetTable;
    }

    public String getTargetTableName() {
        return this.m_targetTableName;
    }

    public void setTargetMappingName(String targetMapping) {
        this.m_targetMappingName = targetMapping;
    }

    public String getTargetMappingName() {
        return this.m_targetMappingName;
    }

    public void setDisableWriteToWAL(boolean d) {
        this.m_disableWriteToWAL = d;
    }

    public boolean getDisableWriteToWAL() {
        return this.m_disableWriteToWAL;
    }

    public void setWriteBufferSize(String size) {
        this.m_writeBufferSize = size;
    }

    public String getWriteBufferSize() {
        return this.m_writeBufferSize;
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    private void loadClusterConfig(ObjectId id_jobentry, Repository rep, Node entrynode) {
        boolean configLoaded = false;
        try {
            if (entrynode != null) {
                this.setClusterName(XMLHandler.getTagValue((Node)entrynode, (String)"cluster_name"));
            } else if (rep != null) {
                this.setClusterName(rep.getJobEntryAttributeString(id_jobentry, "cluster_name"));
            }
            NamedCluster nc = null;
            if (rep != null && !StringUtils.isEmpty((String)this.getClusterName()) && NamedClusterManager.getInstance().contains(this.getClusterName(), rep.getMetaStore())) {
                nc = NamedClusterManager.getInstance().read(this.getClusterName(), rep.getMetaStore());
            }
            if (nc != null) {
                this.setZookeeperHosts(nc.getZooKeeperHost());
                this.setZookeeperPort(nc.getZooKeeperPort());
                configLoaded = true;
            }
        }
        catch (Throwable t) {
            this.logDebug(t.getMessage(), new Object[]{t});
        }
        if (!configLoaded) {
            if (entrynode != null) {
                this.setZookeeperHosts(XMLHandler.getTagValue((Node)entrynode, (String)"zookeeper_hosts"));
                this.setZookeeperPort(XMLHandler.getTagValue((Node)entrynode, (String)"zookeeper_port"));
            } else if (rep != null) {
                try {
                    this.setZookeeperHosts(rep.getJobEntryAttributeString(id_jobentry, "zookeeper_hosts"));
                    this.setZookeeperPort(rep.getJobEntryAttributeString(id_jobentry, "zookeeper_port"));
                }
                catch (KettleException ke) {
                    this.logError(ke.getMessage(), ke);
                }
            }
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"cluster_name", (String)this.clusterName));
        try {
            if (this.repository != null && !StringUtils.isEmpty((String)this.getClusterName()) && NamedClusterManager.getInstance().contains(this.getClusterName(), this.repository.getMetaStore())) {
                NamedCluster nc = NamedClusterManager.getInstance().read(this.getClusterName(), this.repository.getMetaStore());
                this.setZookeeperHosts(nc.getZooKeeperHost());
                this.setZookeeperPort(nc.getZooKeeperPort());
            }
        }
        catch (MetaStoreException e) {
            this.logDebug(e.getMessage(), new Object[]{e});
        }
        if (!Const.isEmpty((String)this.m_zookeeperHosts)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"zookeeper_hosts", (String)this.m_zookeeperHosts));
        }
        if (!Const.isEmpty((String)this.m_zookeeperPort)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"zookeeper_port", (String)this.m_zookeeperPort));
        }
        if (!Const.isEmpty((String)this.m_coreConfigURL)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"core_config_url", (String)this.m_coreConfigURL));
        }
        if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"default_config_url", (String)this.m_defaultConfigURL));
        }
        if (!Const.isEmpty((String)this.m_targetTableName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"target_table_name", (String)this.m_targetTableName));
        }
        if (!Const.isEmpty((String)this.m_targetMappingName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"target_mapping_name", (String)this.m_targetMappingName));
        }
        if (!Const.isEmpty((String)this.m_writeBufferSize)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"write_buffer_size", (String)this.m_writeBufferSize));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"disable_wal", (boolean)this.m_disableWriteToWAL));
        if (this.m_mapping != null) {
            retval.append(this.m_mapping.getXML());
        }
        return retval.toString();
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new HBaseOutput(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new HBaseOutputData();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.loadClusterConfig(null, this.repository, stepnode);
        this.m_coreConfigURL = XMLHandler.getTagValue((Node)stepnode, (String)"core_config_url");
        this.m_defaultConfigURL = XMLHandler.getTagValue((Node)stepnode, (String)"default_config_url");
        this.m_targetTableName = XMLHandler.getTagValue((Node)stepnode, (String)"target_table_name");
        this.m_targetMappingName = XMLHandler.getTagValue((Node)stepnode, (String)"target_mapping_name");
        this.m_writeBufferSize = XMLHandler.getTagValue((Node)stepnode, (String)"write_buffer_size");
        String disableWAL = XMLHandler.getTagValue((Node)stepnode, (String)"disable_wal");
        this.m_disableWriteToWAL = disableWAL.equalsIgnoreCase("Y");
        Mapping tempMapping = new Mapping();
        this.m_mapping = tempMapping.loadXML(stepnode) ? tempMapping : null;
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        this.loadClusterConfig(id_step, rep, null);
        this.m_coreConfigURL = rep.getStepAttributeString(id_step, 0, "core_config_url");
        this.m_defaultConfigURL = rep.getStepAttributeString(id_step, 0, "default_config_url");
        this.m_targetTableName = rep.getStepAttributeString(id_step, 0, "target_table_name");
        this.m_targetMappingName = rep.getStepAttributeString(id_step, 0, "target_mapping_name");
        this.m_writeBufferSize = rep.getStepAttributeString(id_step, 0, "write_buffer_size");
        this.m_disableWriteToWAL = rep.getStepAttributeBoolean(id_step, 0, "disable_wal");
        Mapping tempMapping = new Mapping();
        this.m_mapping = tempMapping.readRep(rep, id_step) ? tempMapping : null;
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, this.getObjectId(), "cluster_name", this.clusterName);
        try {
            if (!StringUtils.isEmpty((String)this.getClusterName()) && NamedClusterManager.getInstance().contains(this.getClusterName(), rep.getMetaStore())) {
                NamedCluster nc = NamedClusterManager.getInstance().read(this.getClusterName(), rep.getMetaStore());
                this.setZookeeperHosts(nc.getZooKeeperHost());
                this.setZookeeperPort(nc.getZooKeeperPort());
            }
        }
        catch (MetaStoreException e) {
            this.logDebug(e.getMessage(), new Object[]{e});
        }
        if (!Const.isEmpty((String)this.m_zookeeperHosts)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "zookeeper_hosts", this.m_zookeeperHosts);
        }
        if (!Const.isEmpty((String)this.m_zookeeperPort)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "zookeeper_port", this.m_zookeeperPort);
        }
        if (!Const.isEmpty((String)this.m_coreConfigURL)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "core_config_url", this.m_coreConfigURL);
        }
        if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "default_config_url", this.m_defaultConfigURL);
        }
        if (!Const.isEmpty((String)this.m_targetTableName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "target_table_name", this.m_targetTableName);
        }
        if (!Const.isEmpty((String)this.m_targetMappingName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "target_mapping_name", this.m_targetMappingName);
        }
        if (!Const.isEmpty((String)this.m_writeBufferSize)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "write_buffer_size", this.m_writeBufferSize);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "disable_wal", this.m_disableWriteToWAL);
        if (this.m_mapping != null) {
            this.m_mapping.saveRep(rep, id_transformation, id_step);
        }
    }

    public void setDefault() {
        this.m_coreConfigURL = null;
        this.m_defaultConfigURL = null;
        this.m_targetTableName = null;
        this.m_targetMappingName = null;
        this.m_disableWriteToWAL = false;
        this.m_writeBufferSize = null;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getDialogClassName() {
        return "org.pentaho.di.trans.steps.hbaseoutput.HBaseOutputDialog";
    }
}

