/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.namedcluster;

import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.namedcluster.dialog.NamedClusterComposite;
import org.pentaho.di.ui.delegates.HadoopClusterDelegate;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class NamedClusterWidget
extends Composite {
    private static Class<?> PKG = NamedClusterComposite.class;
    private Combo nameClusterCombo;
    private HadoopClusterDelegate ncDelegate = new HadoopClusterDelegate(Spoon.getInstance());

    public NamedClusterWidget(Composite parent, boolean showLabel) {
        super(parent, 0);
        PropsUI props = PropsUI.getInstance();
        props.setLook((Control)this);
        RowLayout layout = new RowLayout(256);
        this.setLayout((Layout)layout);
        if (showLabel) {
            Label nameLabel = new Label((Composite)this, 0);
            nameLabel.setText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.Shell.Title", (String[])new String[0]) + ":");
            props.setLook((Control)nameLabel);
        }
        this.nameClusterCombo = new Combo((Composite)this, 12);
        this.nameClusterCombo.setLayoutData((Object)new RowData(150, -1));
        Button editButton = new Button((Composite)this, 0);
        editButton.setText(BaseMessages.getString(PKG, (String)"NamedClusterWidget.NamedCluster.Edit", (String[])new String[0]));
        editButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NamedClusterWidget.this.editNamedCluster();
            }
        });
        props.setLook((Control)editButton);
        Button newButton = new Button((Composite)this, 0);
        newButton.setText(BaseMessages.getString(PKG, (String)"NamedClusterWidget.NamedCluster.New", (String[])new String[0]));
        newButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NamedClusterWidget.this.newNamedCluster();
            }
        });
        props.setLook((Control)newButton);
        this.initiate();
    }

    private void newNamedCluster() {
        Spoon spoon = Spoon.getInstance();
        AbstractMeta meta = (AbstractMeta)spoon.getActiveMeta();
        this.ncDelegate.newNamedCluster((VariableSpace)meta, (IMetaStore)spoon.getMetaStore(), this.getShell());
        this.initiate();
    }

    private void editNamedCluster() {
        Spoon spoon = Spoon.getInstance();
        AbstractMeta meta = (AbstractMeta)spoon.getActiveMeta();
        if (meta != null) {
            List<NamedCluster> namedClusters = null;
            try {
                namedClusters = NamedClusterManager.getInstance().list((IMetaStore)spoon.getMetaStore());
            }
            catch (MetaStoreException e) {
                // empty catch block
            }
            int index = this.nameClusterCombo.getSelectionIndex();
            if (index > -1 && namedClusters != null && namedClusters.size() > 0) {
                this.ncDelegate.editNamedCluster((IMetaStore)spoon.getMetaStore(), namedClusters.get(index), this.getShell());
                this.initiate();
            }
        }
    }

    private String[] getNamedClusterNames() {
        try {
            return NamedClusterManager.getInstance().listNames((IMetaStore)Spoon.getInstance().getMetaStore()).toArray(new String[0]);
        }
        catch (MetaStoreException e) {
            return new String[0];
        }
    }

    public void initiate() {
        int selectedIndex = this.nameClusterCombo.getSelectionIndex();
        this.nameClusterCombo.removeAll();
        this.nameClusterCombo.setItems(this.getNamedClusterNames());
        this.nameClusterCombo.select(selectedIndex);
    }

    public NamedCluster getSelectedNamedCluster() {
        Spoon spoon = Spoon.getInstance();
        int index = this.nameClusterCombo.getSelectionIndex();
        if (index > -1) {
            String name = this.nameClusterCombo.getItem(index);
            try {
                return NamedClusterManager.getInstance().read(name, (IMetaStore)spoon.getMetaStore());
            }
            catch (MetaStoreException e) {
                return null;
            }
        }
        return null;
    }

    public void setSelectedNamedCluster(String name) {
        this.nameClusterCombo.deselectAll();
        for (int i = 0; i < this.nameClusterCombo.getItemCount(); ++i) {
            if (!this.nameClusterCombo.getItem(i).equals(name)) continue;
            this.nameClusterCombo.select(i);
            return;
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.nameClusterCombo.addSelectionListener(selectionListener);
    }
}

