/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.namedcluster.dialog;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.TextVar;

public class NamedClusterComposite
extends Composite {
    private static Class<?> PKG = NamedClusterComposite.class;
    private PropsUI props;
    private GridData gridData;
    private GridData numberGridData;
    private GridData labelGridData;
    private GridData userNameLabelGridData;
    private GridData userNameGridData;
    private GridData passwordLabelGridData;
    private GridData passwordGridData;
    private GridData portLabelGridData;
    private static final int ONE_COLUMN = 1;
    private static final int TWO_COLUMNS = 2;
    private static final int TEXT_FLAGS = 18436;
    private static final int PASSWORD_FLAGS = 0x404804;
    private Text nameValue;
    private Label jtHostLabel;
    private TextVar jtHostNameText;
    private Label jtPortLabel;
    private TextVar jtPortText;
    private Label hdfsHostLabel;
    private TextVar hdfsHostText;
    private Label hdfsPortLabel;
    private TextVar hdfsPortText;
    private Label hdfsUsernameLabel;
    private TextVar hdfsUsernameText;
    private Label hdfsPasswordLabel;
    private TextVar hdfsPasswordText;

    public NamedClusterComposite(Composite parent, NamedCluster namedCluster, PropsUI props) {
        super(parent, 0);
        props.setLook((Control)this);
        this.props = props;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 10;
        formLayout.marginHeight = 0;
        this.setLayout((Layout)formLayout);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.setLayoutData(fd);
        this.gridData = new GridData();
        this.gridData.widthHint = 270;
        this.numberGridData = new GridData();
        this.numberGridData.widthHint = 80;
        this.labelGridData = new GridData();
        this.labelGridData.widthHint = 270;
        this.portLabelGridData = new GridData();
        this.portLabelGridData.widthHint = 80;
        this.userNameLabelGridData = new GridData();
        this.userNameLabelGridData.widthHint = 165;
        this.userNameGridData = new GridData();
        this.userNameGridData.widthHint = 165;
        this.passwordLabelGridData = new GridData();
        this.passwordLabelGridData.widthHint = 185;
        this.passwordGridData = new GridData();
        this.passwordGridData.widthHint = 185;
        this.processNamedCluster(this, namedCluster);
        this.nameValue.forceFocus();
    }

    private void processNamedCluster(Composite c, final NamedCluster cluster) {
        Composite confUI = this.createConfigurationUI(c, cluster);
        Label topSeparator = new Label(c, 258);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)confUI, 10);
        topSeparator.setLayoutData((Object)fd);
        final Button maprButton = new Button(c, 32);
        maprButton.setText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.NamedCluster.IsMapR", (String[])new String[0]));
        maprButton.setToolTipText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.NamedCluster.IsMapR.Title", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)topSeparator, 10);
        maprButton.setLayoutData((Object)fd);
        this.props.setLook((Control)maprButton);
        maprButton.setSelection(cluster.isMapr());
        maprButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                cluster.setMapr(maprButton.getSelection());
                NamedClusterComposite.this.setHdfsAndJobTrackerState(!maprButton.getSelection());
            }
        });
        Composite c1 = new Composite(c, 0);
        fd = new FormData();
        fd.top = new FormAttachment((Control)maprButton, 10);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        c1.setLayoutData((Object)fd);
        this.props.setLook((Control)c1);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c1.setLayout((Layout)gl);
        this.createHdfsGroup(c1, cluster);
        this.createJobTrackerGroup(c1, cluster);
        this.createZooKeeperGroup(c1, cluster);
        this.createOozieGroup(c1, cluster);
        c1.setSize(c1.computeSize(-1, -1));
        this.setHdfsAndJobTrackerState(!cluster.isMapr());
    }

    private Composite createConfigurationUI(Composite c, final NamedCluster namedCluster) {
        Composite mainParent = new Composite(c, 0);
        this.props.setLook((Control)mainParent);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        mainParent.setLayout((Layout)gl);
        FormData fd = new FormData();
        mainParent.setLayoutData((Object)fd);
        this.createLabel(mainParent, BaseMessages.getString(PKG, (String)"NamedClusterDialog.NamedCluster.Name", (String[])new String[0]), this.labelGridData);
        this.nameValue = new Text(mainParent, 18436);
        this.nameValue.setText(String.valueOf(namedCluster.getName()));
        this.nameValue.setLayoutData((Object)this.gridData);
        this.props.setLook((Control)this.nameValue);
        this.nameValue.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
                namedCluster.setName(NamedClusterComposite.this.nameValue.getText());
            }

            public void keyPressed(KeyEvent event) {
            }
        });
        return mainParent;
    }

    private Label createLabel(Composite parent, String text, GridData gd) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)gd);
        this.props.setLook((Control)label);
        return label;
    }

    private TextVar createTextVar(final NamedCluster c, Composite parent, String val, GridData gd, int flags, final Callback cb) {
        final TextVar textVar = new TextVar((VariableSpace)c, parent, flags);
        textVar.setText(StringUtils.isEmpty((String)val) ? "" : val);
        textVar.setLayoutData((Object)gd);
        this.props.setLook((Control)textVar);
        textVar.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
                cb.invoke(c, textVar, textVar.getText());
            }

            public void keyPressed(KeyEvent event) {
            }
        });
        return textVar;
    }

    private Composite createGroup(Composite parent, String groupLabel) {
        Group group = new Group(parent, 0);
        group.setText(groupLabel);
        group.setLayout((Layout)new RowLayout(512));
        this.props.setLook((Control)group);
        GridData groupGridData = new GridData();
        groupGridData.grabExcessHorizontalSpace = true;
        groupGridData.horizontalAlignment = 4;
        group.setLayoutData((Object)groupGridData);
        Composite pp = new Composite((Composite)group, 0);
        this.props.setLook((Control)pp);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = -10;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginTop = -10;
        gridLayout.marginBottom = -5;
        pp.setLayout((Layout)gridLayout);
        return pp;
    }

    private Composite createTwoColumnsContainer(Composite parentComposite) {
        Composite twoColumnsComposite = new Composite(parentComposite, 0);
        this.props.setLook((Control)twoColumnsComposite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        twoColumnsComposite.setLayout((Layout)gridLayout);
        return twoColumnsComposite;
    }

    private void createHdfsGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.HDFS", (String[])new String[0]));
        Composite hdfsRowComposite = this.createTwoColumnsContainer(pp);
        Composite hostUIComposite = new Composite(hdfsRowComposite, 0);
        this.props.setLook((Control)hostUIComposite);
        hostUIComposite.setLayout((Layout)new GridLayout(1, false));
        Composite portUIComposite = new Composite(hdfsRowComposite, 0);
        this.props.setLook((Control)portUIComposite);
        portUIComposite.setLayout((Layout)new GridLayout(1, false));
        this.hdfsHostLabel = this.createLabel(hostUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Hostname", (String[])new String[0]), this.labelGridData);
        Callback hdfsHostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsHost(value);
            }
        };
        this.hdfsHostText = this.createTextVar(c, hostUIComposite, c.getHdfsHost(), this.gridData, 18436, hdfsHostCB);
        this.hdfsPortLabel = this.createLabel(portUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Port", (String[])new String[0]), this.portLabelGridData);
        Callback hdfsPortCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsPort(value);
            }
        };
        this.hdfsPortText = this.createTextVar(c, portUIComposite, c.getHdfsPort(), this.numberGridData, 18436, hdfsPortCB);
        Composite hdfsCredentialsRowComposite = this.createTwoColumnsContainer(pp);
        Composite usernameUIComposite = new Composite(hdfsCredentialsRowComposite, 0);
        this.props.setLook((Control)usernameUIComposite);
        usernameUIComposite.setLayout((Layout)new GridLayout(1, false));
        Composite passwordUIComposite = new Composite(hdfsCredentialsRowComposite, 0);
        this.props.setLook((Control)passwordUIComposite);
        passwordUIComposite.setLayout((Layout)new GridLayout(1, false));
        this.hdfsUsernameLabel = this.createLabel(usernameUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Username", (String[])new String[0]), this.userNameLabelGridData);
        Callback hdfsUsernameCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsUsername(value);
            }
        };
        this.hdfsUsernameText = this.createTextVar(c, usernameUIComposite, c.getHdfsUsername(), this.userNameGridData, 18436, hdfsUsernameCB);
        this.hdfsPasswordLabel = this.createLabel(passwordUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Password", (String[])new String[0]), this.passwordLabelGridData);
        Callback hdfsPasswordCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsPassword(value);
            }
        };
        this.hdfsPasswordText = this.createTextVar(c, passwordUIComposite, c.getHdfsPassword(), this.passwordGridData, 0x404804, hdfsPasswordCB);
    }

    private void createJobTrackerGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.JobTracker", (String[])new String[0]));
        Composite jobTrackerRowComposite = this.createTwoColumnsContainer(pp);
        Composite hostUIComposite = new Composite(jobTrackerRowComposite, 0);
        this.props.setLook((Control)hostUIComposite);
        hostUIComposite.setLayout((Layout)new GridLayout(1, false));
        Composite portUIComposite = new Composite(jobTrackerRowComposite, 0);
        this.props.setLook((Control)portUIComposite);
        portUIComposite.setLayout((Layout)new GridLayout(1, false));
        this.jtHostLabel = this.createLabel(hostUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Hostname", (String[])new String[0]), this.labelGridData);
        Callback hostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setJobTrackerHost(value);
            }
        };
        this.jtHostNameText = this.createTextVar(c, hostUIComposite, c.getJobTrackerHost(), this.gridData, 18436, hostCB);
        this.jtPortLabel = this.createLabel(portUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Port", (String[])new String[0]), this.portLabelGridData);
        Callback portCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setJobTrackerPort(value);
            }
        };
        this.jtPortText = this.createTextVar(c, portUIComposite, c.getJobTrackerPort(), this.numberGridData, 18436, portCB);
    }

    private void createZooKeeperGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.ZooKeeper", (String[])new String[0]));
        Composite zooKeeperRowComposite = this.createTwoColumnsContainer(pp);
        Composite hostUIComposite = new Composite(zooKeeperRowComposite, 0);
        this.props.setLook((Control)hostUIComposite);
        hostUIComposite.setLayout((Layout)new GridLayout(1, false));
        Composite portUIComposite = new Composite(zooKeeperRowComposite, 0);
        this.props.setLook((Control)portUIComposite);
        portUIComposite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(hostUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Hostname", (String[])new String[0]), this.labelGridData);
        Callback hostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setZooKeeperHost(value);
            }
        };
        this.createTextVar(c, hostUIComposite, c.getZooKeeperHost(), this.gridData, 18436, hostCB);
        this.createLabel(portUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Port", (String[])new String[0]), this.portLabelGridData);
        Callback portCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setZooKeeperPort(value);
            }
        };
        this.createTextVar(c, portUIComposite, c.getZooKeeperPort(), this.numberGridData, 18436, portCB);
    }

    private void createOozieGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Oozie", (String[])new String[0]));
        Composite container = new Composite(pp, 0);
        this.props.setLook((Control)container);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        container.setLayout((Layout)gridLayout);
        this.createLabel(container, BaseMessages.getString(PKG, (String)"NamedClusterDialog.URL", (String[])new String[0]), this.labelGridData);
        Callback hostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setOozieUrl(value);
            }
        };
        this.createTextVar(c, container, c.getOozieUrl(), this.gridData, 18436, hostCB);
    }

    private void setHdfsAndJobTrackerState(boolean state) {
        this.jtHostLabel.setEnabled(state);
        this.jtHostNameText.setEnabled(state);
        this.jtPortLabel.setEnabled(state);
        this.jtPortText.setEnabled(state);
        this.hdfsHostLabel.setEnabled(state);
        this.hdfsHostText.setEnabled(state);
        this.hdfsPortLabel.setEnabled(state);
        this.hdfsPortText.setEnabled(state);
        this.hdfsUsernameLabel.setEnabled(state);
        this.hdfsUsernameText.setEnabled(state);
        this.hdfsPasswordLabel.setEnabled(state);
        this.hdfsPasswordText.setEnabled(state);
    }

    private static interface Callback {
        public void invoke(NamedCluster var1, TextVar var2, String var3);
    }
}

