/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.namedcluster.dialog;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.namedcluster.NamedClusterUIHelper;
import org.pentaho.di.ui.core.namedcluster.dialog.NamedClusterComposite;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class NamedClusterDialog
extends Dialog {
    private static Class<?> PKG = NamedClusterDialog.class;
    private static final int RESULT_NO = 1;
    private Shell shell;
    private PropsUI props = PropsUI.getInstance();
    private Button wOK;
    private Button wCancel;
    private int margin;
    private NamedCluster originalNamedCluster;
    private NamedCluster namedCluster;
    private boolean newClusterCheck = false;
    private String result;

    public NamedClusterDialog(Shell parent) {
        super(parent);
    }

    public NamedClusterDialog(Shell parent, NamedCluster namedCluster) {
        super(parent);
        this.namedCluster = namedCluster;
        this.originalNamedCluster = namedCluster.clone();
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = namedCluster;
        this.originalNamedCluster = namedCluster.clone();
    }

    public boolean isNewClusterCheck() {
        return this.newClusterCheck;
    }

    public void setNewClusterCheck(boolean newClusterCheck) {
        this.newClusterCheck = newClusterCheck;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3313);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.margin = 5;
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(LifecyclePluginType.class, "HadoopSpoonPlugin");
        HelpUtils.createHelpButton((Composite)this.shell, (String)HelpUtils.getHelpDialogTitle((PluginInterface)plugin), (String)BaseMessages.getString(PKG, (String)"NamedClusterDialog.Shell.Doc", (String[])new String[0]), (String)BaseMessages.getString(PKG, (String)"NamedClusterDialog.Shell.Title", (String[])new String[0]));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.Shell.Title", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        NamedClusterComposite namedClusterComposite = new NamedClusterComposite((Composite)this.shell, this.namedCluster, this.props);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        namedClusterComposite.setLayoutData(fd);
        this.shell.setSize(431, 630);
        this.shell.setMinimumSize(431, 630);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        Button[] buttons = new Button[]{this.wOK, this.wCancel};
        BaseStepDialog.positionBottomRightButtons((Composite)this.shell, (Button[])buttons, (int)this.margin, null);
        Label bottomSeparator = new Label((Composite)this.shell, 258);
        int bottomSeparatorOffset = this.wOK.getBounds().height + 5;
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -bottomSeparatorOffset);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        bottomSeparator.setLayoutData((Object)fd);
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NamedClusterDialog.this.ok();
            }
        });
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NamedClusterDialog.this.cancel();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                NamedClusterDialog.this.cancel();
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void cancel() {
        this.result = null;
        this.dispose();
    }

    public void ok() {
        this.result = this.namedCluster.getName();
        if (StringUtils.isBlank((String)this.result)) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.Error", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameMissing", (String[])new String[0]));
            mb.open();
            return;
        }
        if (this.newClusterCheck || !this.originalNamedCluster.getName().equals(this.result)) {
            try {
                String doNotReplaceButton;
                String replaceButton;
                String message;
                String title;
                MessageDialog dialog;
                NamedCluster fetched = NamedClusterUIHelper.getNamedCluster(this.result);
                if (fetched != null && 1 == (dialog = new MessageDialog(this.shell, title = BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameExists.Title", (String[])new String[0]), null, message = BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameExists", (String[])new String[]{this.result}), 4, new String[]{replaceButton = BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameExists.Replace", (String[])new String[0]), doNotReplaceButton = BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameExists.DoNotReplace", (String[])new String[0])}, 0)).open()) {
                    return;
                }
            }
            catch (MetaStoreException metaStoreException) {
                // empty catch block
            }
        }
        this.dispose();
    }
}

