/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.delegates;

import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.namedcluster.dialog.NamedClusterDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class HadoopClusterDelegate
extends SpoonDelegate {
    private static Class<?> PKG = Spoon.class;

    public HadoopClusterDelegate(Spoon spoon) {
        super(spoon);
    }

    public void dupeNamedCluster(IMetaStore metaStore, NamedCluster nc, Shell shell) {
        if (metaStore == null) {
            metaStore = Spoon.getInstance().getMetaStore();
        }
        if (nc != null) {
            NamedCluster ncCopy = nc.clone();
            String dupename = BaseMessages.getString(PKG, (String)"Spoon.Various.DupeName", (String[])new String[0]) + nc.getName();
            ncCopy.setName(dupename);
            NamedClusterDialog namedClusterDialog = new NamedClusterDialog(shell, ncCopy);
            namedClusterDialog.setNewClusterCheck(true);
            String newname = namedClusterDialog.open();
            if (newname != null) {
                this.saveNamedCluster(metaStore, ncCopy);
                this.spoon.refreshTree();
            }
        }
    }

    public void delNamedCluster(IMetaStore metaStore, NamedCluster namedCluster) {
        if (metaStore == null) {
            metaStore = Spoon.getInstance().getMetaStore();
        }
        this.deleteNamedCluster(metaStore, namedCluster);
        this.spoon.refreshTree();
        this.spoon.setShellText();
    }

    public String editNamedCluster(IMetaStore metaStore, NamedCluster namedCluster, Shell shell) {
        if (metaStore == null) {
            metaStore = Spoon.getInstance().getMetaStore();
        }
        NamedClusterDialog namedClusterDialog = new NamedClusterDialog(shell, namedCluster.clone());
        namedClusterDialog.setNewClusterCheck(false);
        String result = namedClusterDialog.open();
        if (result != null) {
            this.deleteNamedCluster(metaStore, namedCluster);
            this.saveNamedCluster(metaStore, namedClusterDialog.getNamedCluster());
            this.spoon.refreshTree();
            if (namedClusterDialog.getNamedCluster() != null) {
                return namedClusterDialog.getNamedCluster().getName();
            }
        }
        return null;
    }

    public String newNamedCluster(VariableSpace variableSpace, IMetaStore metaStore, Shell shell) {
        if (metaStore == null) {
            metaStore = Spoon.getInstance().getMetaStore();
        }
        NamedCluster nc = NamedClusterManager.getInstance().getClusterTemplate();
        NamedClusterDialog namedClusterDialog = new NamedClusterDialog(shell, nc);
        namedClusterDialog.setNewClusterCheck(true);
        String result = namedClusterDialog.open();
        if (result != null) {
            if (variableSpace != null) {
                nc.shareVariablesWith(variableSpace);
            } else {
                nc.initializeVariablesFrom(null);
            }
            this.saveNamedCluster(metaStore, nc);
            this.spoon.refreshTree();
            return nc.getName();
        }
        return null;
    }

    private void deleteNamedCluster(IMetaStore metaStore, NamedCluster namedCluster) {
        try {
            if (NamedClusterManager.getInstance().read(namedCluster.getName(), metaStore) != null) {
                NamedClusterManager.getInstance().delete(namedCluster.getName(), metaStore);
            }
        }
        catch (MetaStoreException e) {
            new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingNamedCluster.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingNamedCluster.Message", (String[])new String[]{namedCluster.getName()}), (Exception)((Object)e));
        }
    }

    private void saveNamedCluster(IMetaStore metaStore, NamedCluster namedCluster) {
        try {
            NamedClusterManager.getInstance().create(namedCluster, metaStore);
        }
        catch (MetaStoreException e) {
            new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingNamedCluster.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingNamedCluster.Message", (String[])new String[]{namedCluster.getName()}), (Exception)((Object)e));
        }
    }
}

