/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.sqoop;

import java.util.Collection;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.sqoop.AbstractSqoopJobEntry;
import org.pentaho.di.job.entries.sqoop.SqoopExportConfig;
import org.pentaho.di.job.entries.sqoop.SqoopExportJobEntry;
import org.pentaho.di.ui.job.entries.sqoop.AbstractSqoopJobEntryController;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class SqoopExportJobEntryController
extends AbstractSqoopJobEntryController<SqoopExportConfig, SqoopExportJobEntry> {
    public SqoopExportJobEntryController(JobMeta jobMeta, XulDomContainer container, SqoopExportJobEntry sqoopJobEntry, BindingFactory bindingFactory) {
        super(jobMeta, container, sqoopJobEntry, bindingFactory);
    }

    @Override
    public String getDialogElementId() {
        return "sqoop-export";
    }

    @Override
    protected void createBindings(SqoopExportConfig config, XulDomContainer container, BindingFactory bindingFactory, Collection<Binding> bindings) {
        super.createBindings(config, container, bindingFactory, bindings);
        bindings.add(bindingFactory.createBinding((Object)config, "exportDir", "exportDir", "value", new BindingConvertor[0]));
    }

    public void browseForExportDirectory() {
        try {
            String[] schemeRestrictions = new String[1];
            if (this.selectedNamedCluster != null && !"false".equals(this.selectedNamedCluster.getVariable("valid"))) {
                schemeRestrictions[0] = this.selectedNamedCluster.isMapr() ? "maprfs" : "hdfs";
            } else {
                return;
            }
            String path = ((SqoopExportConfig)this.getConfig()).getExportDir();
            FileObject initialFile = this.getInitialFile(path);
            if (initialFile == null) {
                this.showErrorDialog(BaseMessages.getString((Class)PKG, (String)"Sqoop.JobEntry.Connection.Error.title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"Sqoop.JobEntry.Connection.error", (String[])new String[0]));
                return;
            }
            FileObject exportDir = this.browseVfs(null, initialFile, 1, schemeRestrictions, false, schemeRestrictions[0], this.selectedNamedCluster, false, false);
            VfsFileChooserDialog dialog = Spoon.getInstance().getVfsFileChooserDialog(null, null);
            boolean okPressed = dialog.okPressed;
            if (okPressed) {
                ((SqoopExportConfig)this.getConfig()).setExportDir(exportDir != null ? exportDir.getName().getPath() : null);
                this.extractNamedClusterFromVfsFileChooser();
            }
        }
        catch (KettleFileException e) {
            ((SqoopExportJobEntry)this.getJobEntry()).logError(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorBrowsingDirectory", (String[])new String[0]), e);
        }
        catch (FileSystemException e) {
            ((SqoopExportJobEntry)this.getJobEntry()).logError(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorBrowsingDirectory", (String[])new String[0]), e);
        }
    }

    @Override
    public void accept() {
        ((SqoopExportJobEntry)this.jobEntry).setDatabaseMeta(this.jobMeta.findDatabase(((SqoopExportConfig)this.config).getDatabase()));
        super.accept();
    }

    public void editNamedCluster() {
        if (this.isSelectedNamedCluster()) {
            XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("sqoop-export");
            Shell shell = (Shell)xulDialog.getRootObject();
            this.ncDelegate.editNamedCluster(null, this.selectedNamedCluster, shell);
            this.populateNamedClusters();
        }
    }

    public void newNamedCluster() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("sqoop-export");
        Shell shell = (Shell)xulDialog.getRootObject();
        this.ncDelegate.newNamedCluster((VariableSpace)this.jobMeta, null, shell);
        this.populateNamedClusters();
    }
}

