/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.sqoop;

import java.util.Collection;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.sqoop.AbstractSqoopJobEntry;
import org.pentaho.di.job.entries.sqoop.SqoopImportConfig;
import org.pentaho.di.job.entries.sqoop.SqoopImportJobEntry;
import org.pentaho.di.ui.job.entries.sqoop.AbstractSqoopJobEntryController;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class SqoopImportJobEntryController
extends AbstractSqoopJobEntryController<SqoopImportConfig, SqoopImportJobEntry> {
    public SqoopImportJobEntryController(JobMeta jobMeta, XulDomContainer container, SqoopImportJobEntry sqoopJobEntry, BindingFactory bindingFactory) {
        super(jobMeta, container, sqoopJobEntry, bindingFactory);
    }

    @Override
    public String getDialogElementId() {
        return "sqoop-import";
    }

    @Override
    protected void createBindings(SqoopImportConfig config, XulDomContainer container, BindingFactory bindingFactory, Collection<Binding> bindings) {
        super.createBindings(config, container, bindingFactory, bindings);
        bindings.add(bindingFactory.createBinding((Object)config, "targetDir", "targetDir", "value", new BindingConvertor[0]));
    }

    public void browseForTargetDirectory() {
        try {
            String[] schemeRestrictions = new String[1];
            if (this.selectedNamedCluster != null && !"false".equals(this.selectedNamedCluster.getVariable("valid"))) {
                schemeRestrictions[0] = this.selectedNamedCluster.isMapr() ? "maprfs" : "hdfs";
            } else {
                return;
            }
            String path = ((SqoopImportConfig)this.getConfig()).getTargetDir();
            FileObject initialFile = this.getInitialFile(path);
            if (initialFile == null) {
                this.showErrorDialog(BaseMessages.getString((Class)PKG, (String)"Sqoop.JobEntry.Connection.Error.title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"Sqoop.JobEntry.Connection.error", (String[])new String[0]));
                return;
            }
            FileObject targetDir = this.browseVfs(null, initialFile, 1, schemeRestrictions, false, schemeRestrictions[0], this.selectedNamedCluster, false, false);
            VfsFileChooserDialog dialog = Spoon.getInstance().getVfsFileChooserDialog(null, null);
            boolean okPressed = dialog.okPressed;
            if (okPressed) {
                ((SqoopImportConfig)this.getConfig()).setTargetDir(targetDir != null ? targetDir.getName().getPath() : null);
                this.extractNamedClusterFromVfsFileChooser();
            }
        }
        catch (KettleFileException e) {
            ((SqoopImportJobEntry)this.getJobEntry()).logError(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorBrowsingDirectory", (String[])new String[0]), e);
        }
        catch (FileSystemException e) {
            ((SqoopImportJobEntry)this.getJobEntry()).logError(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorBrowsingDirectory", (String[])new String[0]), e);
        }
    }

    public void editNamedCluster() {
        if (this.isSelectedNamedCluster()) {
            XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("sqoop-import");
            Shell shell = (Shell)xulDialog.getRootObject();
            this.ncDelegate.editNamedCluster(null, this.selectedNamedCluster, shell);
            this.populateNamedClusters();
        }
    }

    public void newNamedCluster() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("sqoop-import");
        Shell shell = (Shell)xulDialog.getRootObject();
        this.ncDelegate.newNamedCluster((VariableSpace)this.jobMeta, null, shell);
        this.populateNamedClusters();
    }
}

