/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.vfs;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.vfs.hadoopvfsfilechooserdialog.HadoopVfsFileChooserDialog;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class VfsFileChooserHelper {
    private VfsFileChooserDialog fileChooserDialog = null;
    private Shell shell = null;
    private VariableSpace variableSpace = null;
    private FileSystemOptions fileSystemOptions = null;
    private String defaultScheme = "file";
    private String[] schemeRestrictions = null;
    private boolean showFileScheme = true;

    public VfsFileChooserHelper(Shell shell, VfsFileChooserDialog fileChooserDialog, VariableSpace variableSpace) {
        this(shell, fileChooserDialog, variableSpace, new FileSystemOptions());
    }

    public VfsFileChooserHelper(Shell shell, VfsFileChooserDialog fileChooserDialog, VariableSpace variableSpace, FileSystemOptions fileSystemOptions) {
        this.fileChooserDialog = fileChooserDialog;
        this.shell = shell;
        this.variableSpace = variableSpace;
        this.fileSystemOptions = fileSystemOptions;
        this.schemeRestrictions = new String[0];
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, 1);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, int fileDialogMode) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, this.fileSystemOptions, fileDialogMode);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, int fileDialogMode, boolean showLocation) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, this.fileSystemOptions, fileDialogMode, showLocation, true);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, int fileDialogMode, boolean showLocation, boolean showCustomUI) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, this.fileSystemOptions, fileDialogMode, showLocation, showCustomUI);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, FileSystemOptions opts) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, opts, 1);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, FileSystemOptions opts, int fileDialogMode) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, opts, fileDialogMode, true, true);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, FileSystemOptions opts, int fileDialogMode, boolean showLocation, boolean showCustomUI) throws KettleException, FileSystemException {
        FileObject rootFile = null;
        FileObject initialFile = null;
        initialFile = fileUri != null ? KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.variableSpace, (FileSystemOptions)opts) : KettleVFS.getFileObject((String)Spoon.getInstance().getLastFileOpened());
        rootFile = initialFile.getFileSystem().getRoot();
        this.fileChooserDialog.setRootFile(rootFile);
        this.fileChooserDialog.setInitialFile(initialFile);
        this.fileChooserDialog.defaultInitialFile = rootFile;
        FileObject selectedFile = null;
        selectedFile = this.fileChooserDialog.open(this.shell, this.schemeRestrictions, this.getDefaultScheme(), this.showFileScheme(), initialFile.getName().getPath(), fileFilters, fileFilterNames, this.returnsUserAuthenticatedFileObjects(), fileDialogMode, showLocation, showCustomUI);
        return selectedFile;
    }

    public VariableSpace getVariableSpace() {
        return this.variableSpace;
    }

    public void setVariableSpace(VariableSpace variableSpace) {
        this.variableSpace = variableSpace;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    public void setFileSystemOptions(FileSystemOptions fileSystemOptions) {
        this.fileSystemOptions = fileSystemOptions;
    }

    public String getDefaultScheme() {
        return this.defaultScheme;
    }

    public void setDefaultScheme(String defaultScheme) {
        this.defaultScheme = defaultScheme;
    }

    public String getSchemeRestriction() {
        String schemaRestriction = null;
        if (this.schemeRestrictions != null && this.schemeRestrictions.length > 0) {
            schemaRestriction = this.schemeRestrictions[0];
        }
        return schemaRestriction;
    }

    public void setSchemeRestriction(String schemeRestriction) {
        this.schemeRestrictions = new String[1];
        this.schemeRestrictions[0] = schemeRestriction;
    }

    public void setSchemeRestrictions(String[] schemeRestrictions) {
        this.schemeRestrictions = schemeRestrictions;
    }

    public boolean showFileScheme() {
        return this.showFileScheme;
    }

    public void setShowFileScheme(boolean showFileScheme) {
        this.showFileScheme = showFileScheme;
    }

    protected boolean returnsUserAuthenticatedFileObjects() {
        return false;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        VfsFileChooserDialog dialog = Spoon.getInstance().getVfsFileChooserDialog(null, null);
        for (CustomVfsUiPanel currentPanel : dialog.getCustomVfsUiPanels()) {
            if (currentPanel == null || !(currentPanel instanceof HadoopVfsFileChooserDialog)) continue;
            HadoopVfsFileChooserDialog hadoopVfsFileChooserDialog = (HadoopVfsFileChooserDialog)currentPanel;
            if (namedCluster == null) continue;
            hadoopVfsFileChooserDialog.setNamedCluster(namedCluster.getName());
        }
    }
}

