/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.vfs.hadoopvfsfilechooserdialog;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.namedcluster.NamedClusterWidget;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.spi.HadoopConfigurationProvider;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class HadoopVfsFileChooserDialog
extends CustomVfsUiPanel {
    private static final Class<?> PKG = HadoopVfsFileChooserDialog.class;
    private static final String HDFS_HA_CLUSTER_NAMENODES_PROP = "dfs.ha.namenodes.hacluster";
    private static final String NAMENODE_LIST_DELIMITER = ",";
    private static final String HDFS_HA_CLUSTER_NAMENODE_RESOLVE_PREFIX = "dfs.namenode.rpc-address.hacluster.";
    private static final String NAMENODE_HOSTNAME_PORT_DELIMITER = ":";
    private LogChannel log = new LogChannel((Object)this);
    FileObject defaultInitialFile = null;
    FileObject hadoopRootFile = null;
    String hadoopOpenFromFolder = null;
    FileObject rootFile = null;
    FileObject initialFile = null;
    VfsFileChooserDialog vfsFileChooserDialog = null;
    String connectedHostname = null;
    String connectedPortString = null;
    boolean isHighAvailabilityCluster = false;
    private long lastConnectAttempt = 0L;
    String schemeName = "hdfs";
    private String ncHostname = "";
    private String ncPort = "";
    private String ncUsername = "";
    private String ncPassword = "";
    private NamedClusterWidget namedClusterWidget = null;
    private String namedCluster = null;

    public HadoopVfsFileChooserDialog(String schemeName, String displayName, VfsFileChooserDialog vfsFileChooserDialog, FileObject rootFile, FileObject initialFile) {
        super(schemeName, displayName, vfsFileChooserDialog, 0);
        this.schemeName = schemeName;
        this.rootFile = rootFile;
        this.initialFile = initialFile;
        this.vfsFileChooserDialog = vfsFileChooserDialog;
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.setLayoutData(gridData);
        this.setLayout((Layout)new GridLayout(1, false));
        this.createConnectionPanel();
    }

    private void createConnectionPanel() {
        Group connectionGroup = new Group((Composite)this, 16);
        connectionGroup.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.ConnectionGroup.Label", (String[])new String[0]));
        GridLayout connectionGroupLayout = new GridLayout();
        connectionGroupLayout.marginWidth = 5;
        connectionGroupLayout.marginHeight = 5;
        connectionGroupLayout.verticalSpacing = 5;
        connectionGroupLayout.horizontalSpacing = 5;
        GridData gData = new GridData(4, 4, true, false);
        connectionGroup.setLayoutData((Object)gData);
        connectionGroup.setLayout((Layout)connectionGroupLayout);
        this.namedClusterWidget = new NamedClusterWidget((Composite)connectionGroup, true);
        this.namedClusterWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                try {
                    HadoopVfsFileChooserDialog.this.connect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Composite textFieldPanel = new Composite((Composite)connectionGroup, 0);
        GridData gridData = new GridData(4, 4, true, false);
        textFieldPanel.setLayoutData((Object)gridData);
        textFieldPanel.setLayout((Layout)new GridLayout(5, false));
    }

    public String buildHadoopFileSystemUrlString() {
        StringBuffer urlString = new StringBuffer(this.schemeName);
        urlString.append("://");
        if (this.ncUsername != null && !this.ncUsername.trim().equals("")) {
            urlString.append(this.ncUsername);
            urlString.append(NAMENODE_HOSTNAME_PORT_DELIMITER);
            urlString.append(this.ncPassword);
            urlString.append("@");
        }
        urlString.append(this.ncHostname);
        if (!Const.isEmpty((String)this.ncPort)) {
            urlString.append(NAMENODE_HOSTNAME_PORT_DELIMITER);
            urlString.append(this.ncPort);
        }
        return urlString.toString();
    }

    public void initializeConnectionPanel(FileObject file) {
        this.initialFile = file;
        if (this.initialFile == null || this.initialFile.getName().getScheme().equals("hdfs")) {
            // empty if block
        }
    }

    private void showMessageAndLog(String title, String message, String messageToLog) {
        MessageBox box = new MessageBox(this.getShell());
        box.setText(title);
        box.setMessage(message);
        this.log.logError(messageToLog);
        box.open();
    }

    private HadoopConfiguration getHadoopConfig() throws ConfigurationException {
        HadoopConfiguration hadoopConfig = null;
        HadoopConfigurationProvider provider = HadoopConfigurationBootstrap.getHadoopConfigurationProvider();
        if (provider != null) {
            hadoopConfig = provider.getActiveConfiguration();
        }
        return hadoopConfig;
    }

    private void loadNamedCluster() {
        NamedCluster namedCluster = this.namedClusterWidget.getSelectedNamedCluster();
        if (namedCluster != null) {
            this.ncHostname = namedCluster.getHdfsHost() != null ? namedCluster.getHdfsHost() : "";
            this.ncPort = namedCluster.getHdfsPort() != null ? namedCluster.getHdfsPort() : "";
            this.ncUsername = namedCluster.getHdfsUsername() != null ? namedCluster.getHdfsUsername() : "";
            this.ncPassword = namedCluster.getHdfsPassword() != null ? namedCluster.getHdfsPassword() : "";
            this.ncHostname = this.getVariableSpace().environmentSubstitute(this.ncHostname);
            this.ncPort = this.getVariableSpace().environmentSubstitute(this.ncPort);
            this.ncUsername = this.getVariableSpace().environmentSubstitute(this.ncUsername);
            this.ncPassword = this.getVariableSpace().environmentSubstitute(this.ncPassword);
        }
    }

    public VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }

    public NamedClusterWidget getNamedClusterWidget() {
        return this.namedClusterWidget;
    }

    public void setNamedCluster(String namedCluster) {
        this.namedCluster = namedCluster;
    }

    public void activate() {
        this.ncHostname = "";
        this.ncPort = "";
        this.ncUsername = "";
        this.ncPassword = "";
        this.namedClusterWidget.setSelectedNamedCluster(this.namedCluster);
        super.activate();
    }

    public void connect() {
        this.vfsFileChooserDialog.setRootFile(null);
        this.vfsFileChooserDialog.setInitialFile(null);
        this.vfsFileChooserDialog.openFileCombo.setText("hdfs://");
        this.vfsFileChooserDialog.vfsBrowser.fileSystemTree.removeAll();
        NamedCluster nc = this.namedClusterWidget.getSelectedNamedCluster();
        if (nc == null) {
            return;
        }
        this.loadNamedCluster();
        this.connectedHostname = this.ncHostname;
        this.connectedPortString = this.ncPort;
        boolean showErrors = System.currentTimeMillis() - this.lastConnectAttempt > 1000L;
        this.lastConnectAttempt = System.currentTimeMillis();
        Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.host", this.ncHostname);
        Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.port", this.connectedPortString);
        Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.user", this.ncUsername);
        Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.password", this.ncPassword);
        FileObject root = this.rootFile;
        try {
            root = KettleVFS.getFileObject((String)this.buildHadoopFileSystemUrlString());
        }
        catch (KettleFileException e1) {
            String unsupportedSchemeMessage = BaseMessages.getString(HadoopConfiguration.class, (String)"Error.UnsupportedSchemeForConfiguration", (String[])new String[]{"@!@", "!@!"});
            String unsupportedSchemeMessagePrefix = unsupportedSchemeMessage.split("@!@")[0];
            String message = e1.getMessage();
            if (message.contains(unsupportedSchemeMessagePrefix)) {
                try {
                    HadoopConfiguration hadoopConfig = this.getHadoopConfig();
                    String hadoopConfigName = hadoopConfig == null ? "Unknown" : hadoopConfig.getName();
                    this.showMessageAndLog(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.Connection.schemeError", (String[])new String[]{hadoopConfigName}), message);
                }
                catch (ConfigurationException ce) {
                    this.showMessageAndLog(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.Connection.error", (String[])new String[0]), ce.getMessage());
                }
            } else {
                this.showMessageAndLog(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.Connection.error", (String[])new String[0]), e1.getMessage());
            }
            return;
        }
        this.vfsFileChooserDialog.setRootFile(root);
        this.vfsFileChooserDialog.setSelectedFile(root);
        this.rootFile = root;
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)this.getFileSystemOptions());
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public FileObject resolveFile(String fileUri, FileSystemOptions opts) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)opts);
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    protected FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        return opts;
    }
}

